/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.network.ServerboundSorterPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.network.PacketDistributor;

public class ControlTab
extends WidgetBase {
    public ControlTab(TravelersBackpackScreen screen, int x, int y, int width, int height) {
        super(screen, x, y, width, height);
        this.isVisible = true;
    }

    @Override
    void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isVisible()) {
            guiGraphics.blit(TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK, this.x, this.y, 133, 0, this.width, this.height);
            if (this.isButtonHovered(mouseX, mouseY, Buttons.SORT)) {
                guiGraphics.blit(TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK, this.x + 4, this.y + 4, 137, 18, 9, 9);
            }
            if (this.isButtonHovered(mouseX, mouseY, Buttons.QUICK_STACK)) {
                guiGraphics.blit(TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK, this.x + 15, this.y + 4, 148, 18, 9, 9);
            }
            if (this.isButtonHovered(mouseX, mouseY, Buttons.TRANSFER_TO_BACKPACK)) {
                guiGraphics.blit(TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK, this.x + 26, this.y + 4, 159, 18, 9, 9);
            }
            if (this.isButtonHovered(mouseX, mouseY, Buttons.TRANSFER_TO_PLAYER)) {
                guiGraphics.blit(TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK, this.x + 37, this.y + 4, 170, 18, 9, 9);
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (BackpackUtils.isShiftPressed()) {
            ArrayList<FormattedCharSequence> list;
            if (this.isButtonHovered(mouseX, mouseY, Buttons.SORT)) {
                list = new ArrayList<FormattedCharSequence>();
                list.add(Component.translatable((String)"screen.travelersbackpack.sort").getVisualOrderText());
                guiGraphics.renderTooltip(this.screen.getFont(), list, mouseX, mouseY);
            }
            if (this.isButtonHovered(mouseX, mouseY, Buttons.QUICK_STACK)) {
                list = new ArrayList();
                list.add(Component.translatable((String)"screen.travelersbackpack.quick_stack").getVisualOrderText());
                list.add(Component.translatable((String)"screen.travelersbackpack.quick_stack_shift").getVisualOrderText());
                guiGraphics.renderTooltip(this.screen.getFont(), list, mouseX, mouseY);
            }
            if (this.isButtonHovered(mouseX, mouseY, Buttons.TRANSFER_TO_BACKPACK)) {
                list = new ArrayList();
                list.add(Component.translatable((String)"screen.travelersbackpack.transfer_to_backpack").getVisualOrderText());
                list.add(Component.translatable((String)"screen.travelersbackpack.transfer_to_backpack_shift").getVisualOrderText());
                guiGraphics.renderTooltip(this.screen.getFont(), list, mouseX, mouseY);
            }
            if (this.isButtonHovered(mouseX, mouseY, Buttons.TRANSFER_TO_PLAYER)) {
                guiGraphics.renderTooltip(this.screen.getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.transfer_to_player"), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean isSettingsChild() {
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.screen.container.getSlotManager().isSelectorActive((byte)0) || this.screen.container.getSlotManager().isSelectorActive((byte)1)) {
            return false;
        }
        if (this.isButtonHovered((int)mouseX, (int)mouseY, Buttons.SORT)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSorterPacket(this.screen.container.getScreenID(), 0, BackpackUtils.isShiftPressed()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.playUIClickSound();
            return true;
        }
        if (this.isButtonHovered((int)mouseX, (int)mouseY, Buttons.QUICK_STACK)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSorterPacket(this.screen.container.getScreenID(), 1, BackpackUtils.isShiftPressed()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.playUIClickSound();
            return true;
        }
        if (this.isButtonHovered((int)mouseX, (int)mouseY, Buttons.TRANSFER_TO_BACKPACK)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSorterPacket(this.screen.container.getScreenID(), 2, BackpackUtils.isShiftPressed()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.playUIClickSound();
            return true;
        }
        if (this.isButtonHovered((int)mouseX, (int)mouseY, Buttons.TRANSFER_TO_PLAYER)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSorterPacket(this.screen.container.getScreenID(), 3, BackpackUtils.isShiftPressed()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    public void setFocused(boolean p_265728_) {
    }

    public boolean isFocused() {
        return false;
    }

    public boolean isButtonHovered(int mouseX, int mouseY, Buttons button) {
        return 65 + button.ordinal() * 11 + this.screen.getGuiLeft() <= mouseX && mouseX <= 65 + button.ordinal() * 11 + 8 + this.screen.getGuiLeft() && -6 + this.screen.getGuiTop() <= mouseY && mouseY <= 2 + this.screen.getGuiTop();
    }

    public static enum Buttons {
        SORT,
        QUICK_STACK,
        TRANSFER_TO_BACKPACK,
        TRANSFER_TO_PLAYER;

    }
}

