/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.FluidTanks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class BackpackTooltipComponent
implements TooltipComponent {
    protected List<ItemStack> storage = new ArrayList<ItemStack>();
    protected List<ItemStack> tools = new ArrayList<ItemStack>();
    protected List<ItemStack> crafting = new ArrayList<ItemStack>();
    protected FluidStack leftFluidStack = FluidStack.EMPTY;
    protected FluidStack rightFluidStack = FluidStack.EMPTY;

    public BackpackTooltipComponent(ItemStack stack) {
        this.loadComponentData(stack);
    }

    public void loadComponentData(ItemStack stack) {
        this.loadFluidStacks(stack);
        this.storage = this.loadInventory(stack);
        this.crafting = this.loadCraftingInventory(stack);
        this.storage.addAll(this.crafting);
        this.storage = this.mergeStacks(this.storage);
        this.tools = this.loadTools(stack);
    }

    public void loadFluidStacks(ItemStack stack) {
        if (stack.has((DataComponentType)ModDataComponents.FLUID_TANKS.get())) {
            FluidTanks tanks = (FluidTanks)stack.get((DataComponentType)ModDataComponents.FLUID_TANKS.get());
            this.leftFluidStack = tanks.leftFluidStack();
            this.rightFluidStack = tanks.rightFluidStack();
        }
    }

    public List<ItemStack> loadInventory(ItemStack stack) {
        if (stack.has((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get())) {
            return new ArrayList<ItemStack>(((BackpackContainerContents)stack.get((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get())).getItems().stream().filter(itemStack -> !itemStack.isEmpty()).toList());
        }
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> mergeStacks(List<ItemStack> stacks) {
        if (!stacks.isEmpty()) {
            ArrayList<ItemStack> uniqueList = new ArrayList<ItemStack>();
            for (ItemStack stack : stacks) {
                if (uniqueList.isEmpty()) {
                    uniqueList.add(stack);
                    continue;
                }
                boolean flag = false;
                for (int i = 0; i < uniqueList.size(); ++i) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)uniqueList.get(i)))) continue;
                    int count = stack.getCount() + ((ItemStack)uniqueList.get(i)).getCount();
                    uniqueList.set(i, stack.copyWithCount(count));
                    flag = true;
                    break;
                }
                if (flag) continue;
                uniqueList.add(stack);
            }
            ArrayList<ItemStack> splittedList = new ArrayList<ItemStack>();
            for (ItemStack itemStack : uniqueList) {
                if (itemStack.getCount() > 999) {
                    int count = itemStack.getCount();
                    int c = count / 999;
                    int reminder = count % 999;
                    for (int j = 0; j < c; ++j) {
                        splittedList.add(itemStack.copyWithCount(999));
                    }
                    splittedList.add(itemStack.copyWithCount(reminder));
                    continue;
                }
                splittedList.add(itemStack);
            }
            return splittedList;
        }
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> loadTools(ItemStack stack) {
        if (stack.has((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get())) {
            return new ArrayList<ItemStack>(((BackpackContainerContents)stack.get((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get())).getItems().stream().filter(itemStack -> !itemStack.isEmpty()).toList());
        }
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> loadCraftingInventory(ItemStack stack) {
        if (stack.has((DataComponentType)ModDataComponents.CRAFTING_CONTAINER.get())) {
            return new ArrayList<ItemStack>(((BackpackContainerContents)stack.get((DataComponentType)ModDataComponents.CRAFTING_CONTAINER.get())).getItems().stream().filter(itemStack -> !itemStack.isEmpty()).toList());
        }
        return new ArrayList<ItemStack>();
    }
}

