/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.Button;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.ServerboundAbilitySliderPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.network.PacketDistributor;

public class AbilitySliderButton
extends Button {
    public AbilitySliderButton(TravelersBackpackScreen screen) {
        super(screen, 5, screen.container.getRows() <= 4 ? 26 : 56, 18, 11);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.screen.container.hasBlockEntity()) {
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.container.getItemStack()) && !this.screen.toolSlotsWidget.isCoveringAbility()) {
                this.drawButton(guiGraphics, mouseX, mouseY, TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK);
            }
        } else if (AttachmentUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.screen.getMenu()).inventory.player) && this.screen.container.getScreenID() == 2 && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.screen.container.getItemStack()) && !this.screen.toolSlotsWidget.isCoveringAbility()) {
            this.drawButton(guiGraphics, mouseX, mouseY, TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK);
        }
    }

    public void drawButton(GuiGraphics guiGraphics, int mouseX, int mouseY, ResourceLocation texture) {
        if (this.screen.container.getAbilityValue()) {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 114, 0, 95, 0);
        } else {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 114, 12, 95, 12);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!(this.screen.container.getScreenID() != 3 && this.screen.container.getScreenID() != 2 || !BackpackAbilities.isOnList(this.screen.container.getScreenID() == 2 ? BackpackAbilities.ITEM_ABILITIES_LIST : BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.container.getItemStack()) || !this.inButton(mouseX, mouseY) || this.screen.isWidgetVisible(3, this.screen.leftTankSlotWidget) || this.screen.isWidgetVisible(4, this.screen.leftTankSlotWidget) || this.screen.toolSlotsWidget.isCoveringAbility())) {
            if (this.screen.container.getAbilityValue()) {
                ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
                list.add(Component.translatable((String)"screen.travelersbackpack.ability_enabled").getVisualOrderText());
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_TIMER_ABILITIES_LIST, this.screen.container.getItemStack()) || BackpackAbilities.isOnList(BackpackAbilities.BLOCK_TIMER_ABILITIES_LIST, this.screen.container.getItemStack())) {
                    list.add(this.screen.container.getLastTime() == 0 ? Component.translatable((String)"screen.travelersbackpack.ability_ready").getVisualOrderText() : Component.translatable((String)BackpackUtils.getConvertedTime(this.screen.container.getLastTime())).getVisualOrderText());
                }
                guiGraphics.renderTooltip(this.screen.getFont(), list, mouseX, mouseY);
            } else if (!((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() || !BackpackAbilities.ALLOWED_ABILITIES.contains(this.screen.container.getItemStack().getItem())) {
                guiGraphics.renderTooltip(this.screen.getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.screen.getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.ability_disabled"), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.screen.container.hasBlockEntity()) {
            if (!this.screen.toolSlotsWidget.isCoveringAbility() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.container.getItemStack()) && this.inButton((int)mouseX, (int)mouseY) && !this.screen.isWidgetVisible(3, this.screen.leftTankSlotWidget) && !this.screen.isWidgetVisible(4, this.screen.leftTankSlotWidget)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundAbilitySliderPacket(this.screen.container.getScreenID(), !this.screen.container.getAbilityValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.screen.playUIClickSound();
                return true;
            }
        } else if (this.screen.container.getScreenID() == 2 && !this.screen.toolSlotsWidget.isCoveringAbility() && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.screen.container.getItemStack()) && this.inButton((int)mouseX, (int)mouseY) && !this.screen.isWidgetVisible(3, this.screen.leftTankSlotWidget) && !this.screen.isWidgetVisible(4, this.screen.leftTankSlotWidget)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundAbilitySliderPacket(this.screen.container.getScreenID(), !this.screen.container.getAbilityValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}

