/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.client.screens.TankScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.AbilitySliderButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.EquipButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.SleepingBagButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.UnequipButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.ControlTab;
import com.tiviacz.travelersbackpack.client.screens.widgets.CraftingWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SortWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.TankSlotWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.ServerboundSorterPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSpecialActionPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackScreen
extends AbstractContainerScreen<TravelersBackpackBaseMenu>
implements MenuAccess<TravelersBackpackBaseMenu> {
    public static final ResourceLocation BACKGROUND_TRAVELERS_BACKPACK = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/travelers_backpack_background.png");
    public static final ResourceLocation SLOTS_TRAVELERS_BACKPACK = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/travelers_backpack_slots.png");
    public static final ResourceLocation SETTINGS_TRAVELERS_BACKPACK = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/travelers_backpack_settings.png");
    public static final ResourceLocation EXTRAS_TRAVELERS_BACKPACK = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/travelers_backpack_extras.png");
    public List<IButton> buttons = new ArrayList<IButton>();
    public ControlTab controlTab;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public SortWidget sortWidget;
    public MemoryWidget memoryWidget;
    public TankSlotWidget leftTankSlotWidget;
    public TankSlotWidget rightTankSlotWidget;
    public CraftingWidget craftingWidget;
    public final ITravelersBackpackContainer container;
    private final TankScreen tankLeft;
    private final TankScreen tankRight;
    private boolean fluidSlotsAsWidget;
    private int rows;

    public TravelersBackpackScreen(TravelersBackpackBaseMenu screenContainer, Inventory inventory, Component component) {
        super((AbstractContainerMenu)screenContainer, inventory, component);
        this.container = screenContainer.container;
        this.leftPos = 0;
        this.topPos = 0;
        this.imageWidth = 248;
        this.tankLeft = new TankScreen(this.container.getLeftTank(), 25, 7, 52 + this.container.getYOffset(), 16);
        this.tankRight = new TankScreen(this.container.getRightTank(), 207, 7, 52 + this.container.getYOffset(), 16);
        this.initScreen();
    }

    public Font getFont() {
        return this.font;
    }

    protected void init() {
        super.init();
        this.initControlTab();
        this.initToolSlotsWidget();
        this.initSettingsTab();
        this.initTankSlotWidgets();
        this.initCraftingWidget();
        this.initButtons();
    }

    public void initTankSlotWidgets() {
        if (this.fluidSlotsAsWidget) {
            this.leftTankSlotWidget = new TankSlotWidget(this, this.leftPos, this.topPos, 28, 60);
            this.addWidget(this.leftTankSlotWidget);
            this.rightTankSlotWidget = new TankSlotWidget(this, this.leftPos + 220, this.topPos, 28, 60);
            this.addWidget(this.rightTankSlotWidget);
        }
    }

    public void initControlTab() {
        this.controlTab = new ControlTab(this, this.leftPos + 61, this.topPos - 10, 50, 13);
        this.addWidget(this.controlTab);
    }

    public void initToolSlotsWidget() {
        this.toolSlotsWidget = new ToolSlotsWidget(this, this.leftPos + 5, this.topPos - 15, 18, 15);
        this.addWidget(this.toolSlotsWidget);
    }

    public void initSettingsTab() {
        this.settingsWidget = new SettingsWidget(this, this.leftPos + this.imageWidth, this.topPos + 10, 15, 18);
        this.addWidget(this.settingsWidget);
        this.sortWidget = new SortWidget(this, this.leftPos + this.imageWidth, this.topPos + 29, 15, 18);
        this.addWidget(this.sortWidget);
        this.memoryWidget = new MemoryWidget(this, this.leftPos + this.imageWidth, this.topPos + 48, 15, 18);
        this.addWidget(this.memoryWidget);
    }

    public void initCraftingWidget() {
        this.craftingWidget = new CraftingWidget(this, this.leftPos + this.imageWidth, this.topPos + 29, 15, 18);
        this.addWidget(this.craftingWidget);
    }

    public void initButtons() {
        this.buttons.clear();
        this.buttons.add(new SleepingBagButton(this));
        this.buttons.add(new EquipButton(this));
        this.buttons.add(new UnequipButton(this));
        this.buttons.add(new AbilitySliderButton(this));
    }

    public void initScreen() {
        this.rows = Math.max(3, Math.min(this.container.getRows(), 7));
        this.fluidSlotsAsWidget = true;
        this.imageHeight = 153;
        if (this.rows > 3) {
            this.imageHeight = 153 + (this.rows - 3) * 18;
            if (this.rows > 4) {
                this.fluidSlotsAsWidget = false;
            }
        }
    }

    public void drawBackground(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(BACKGROUND_TRAVELERS_BACKPACK, x, y, 0, 0, this.imageWidth, 5);
        if (this.rows < this.container.getToolSlotsHandler().getSlots() && this.container.getSettingsManager().showToolSlots()) {
            int sub = this.container.getToolSlotsHandler().getSlots() - this.rows;
            for (int i = 0; i < sub; ++i) {
                guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, x + 2, y + this.container.getYOffset() + 61 + 18 * i, 186, 61, 24, 18);
            }
            guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, x + 2, y + this.container.getYOffset() + 61 + 18 * sub, 186, 80, 24, 2);
        }
        int offset = 5 + Math.abs(this.rows - 7) * 18;
        guiGraphics.blit(BACKGROUND_TRAVELERS_BACKPACK, x, y + 5, 0, offset, this.imageWidth, this.imageHeight - 5);
        if (((Boolean)TravelersBackpackConfig.CLIENT.enableLegacyGui.get()).booleanValue()) {
            this.drawSlotsLegacy(guiGraphics, x + 43, y + 6);
        } else {
            this.drawSlots(guiGraphics, x + 43, y + 6);
        }
        this.drawTank(guiGraphics, x + 24, y);
        this.drawTank(guiGraphics, x + 206, y);
        this.drawFluidSlot(guiGraphics, x + 5, y + 6);
        this.drawFluidSlot(guiGraphics, x + 225, y + 6);
    }

    public void drawSlots(GuiGraphics guiGraphics, int x, int y) {
        int rows = this.container.getRows();
        int additionalSlots = this.container.getHandler().getSlots() % 9;
        int gridX = 162;
        int gridY = (rows - 1) * 18;
        guiGraphics.blit(SLOTS_TRAVELERS_BACKPACK, x, y, 43, 6, gridX, gridY);
        if (additionalSlots == 0) {
            additionalSlots = 9;
        }
        gridX = additionalSlots * 18;
        gridY = 18;
        guiGraphics.blit(SLOTS_TRAVELERS_BACKPACK, x, y + 18 * (rows - 1), 43, 6, gridX, gridY);
    }

    public void drawTank(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, x, y + 6, 232, 38, 18, 18);
        for (int i = 1; i <= this.rows - 2; ++i) {
            guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, x, y + 6 + 18 * i, 232, 57, 18, 18);
        }
        guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, x, y + 6 + 18 * (this.rows - 1), 232, 76, 18, 18);
    }

    public void drawFluidSlot(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, x, y, 213, 38, 18, this.fluidSlotsAsWidget ? 18 : 48);
    }

    public void drawSlotsLegacy(GuiGraphics guiGraphics, int x, int y) {
        int rows = this.container.getRows() - 1;
        int additionalSlots = this.container.getHandler().getSlots() % 9;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.drawSlotLegacy(guiGraphics, x + j * 18, y + i * 18, 213, 0);
            }
        }
        if (additionalSlots == 0) {
            additionalSlots = 9;
        }
        for (int j = 0; j < additionalSlots; ++j) {
            this.drawSlotLegacy(guiGraphics, x + j * 18, y + rows * 18, 213, 0);
        }
    }

    public void drawSlotLegacy(GuiGraphics guiGraphics, int x, int y, int vOffset, int uWidth) {
        guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, x, y, vOffset, uWidth, 18, 18);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.container.getLeftTank().isEmpty()) {
            this.tankLeft.drawScreenFluidBar(this, guiGraphics);
        }
        if (!this.container.getRightTank().isEmpty()) {
            this.tankRight.drawScreenFluidBar(this, guiGraphics);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.controlTab.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.toolSlotsWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.fluidSlotsAsWidget) {
            this.leftTankSlotWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.rightTankSlotWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.settingsWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.children().stream().filter(w -> w instanceof WidgetBase).filter(w -> ((WidgetBase)w).isSettingsChild() && ((WidgetBase)w).isVisible()).forEach(w -> ((WidgetBase)w).render(guiGraphics, mouseX, mouseY, partialTicks));
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            guiGraphics.renderComponentTooltip(this.font, this.tankLeft.getTankTooltip(this.container.getLevel()), mouseX, mouseY);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            guiGraphics.renderComponentTooltip(this.font, this.tankRight.getTankTooltip(this.container.getLevel()), mouseX, mouseY);
        }
        this.buttons.forEach(button -> button.renderTooltip(guiGraphics, mouseX, mouseY));
        this.craftingWidget.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean isWidgetVisible(int rowsCount, TankSlotWidget widget) {
        return this.container.getRows() == rowsCount && widget.isVisible();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.craftingWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.drawBackground(guiGraphics, x, y);
        this.drawToolSlots(guiGraphics);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public void drawToolSlots(GuiGraphics guiGraphics) {
        if (this.container.getSettingsManager().showToolSlots()) {
            boolean enableLegacy = (Boolean)TravelersBackpackConfig.CLIENT.enableLegacyGui.get();
            for (int i = 0; i < this.container.getToolSlotsHandler().getSlots(); ++i) {
                guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + 5, this.getGuiTop() + 6 + 18 * i, 232, enableLegacy ? 0 : 19, 18, 18);
                if (enableLegacy) continue;
                guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + 5, this.getGuiTop() + 6 + 18 * i, 76, 0, 18, 18);
            }
        }
    }

    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (!this.container.getSlotManager().getUnsortableSlots().isEmpty() && !this.container.getSlotManager().isSelectorActive((byte)1)) {
            this.container.getSlotManager().getUnsortableSlots().forEach(i -> guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(i.intValue() + 1)).x, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(i.intValue() + 1)).y, 77, 20, 16, 16));
        }
    }

    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (!this.container.getSlotManager().getMemorySlots().isEmpty()) {
            this.container.getSlotManager().getMemorySlots().forEach(pair -> {
                if (this.container.getSlotManager().isSelectorActive((byte)1)) {
                    guiGraphics.blit(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(((Integer)pair.getFirst()).intValue() + 1)).x, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(((Integer)pair.getFirst()).intValue() + 1)).y, 115, 24, 16, 16);
                }
                if (!((TravelersBackpackBaseMenu)this.menu).getSlot((Integer)pair.getFirst() + 1).getItem().isEmpty()) {
                    return;
                }
                ItemStack itemstack = (ItemStack)pair.getSecond();
                guiGraphics.renderFakeItem(itemstack, this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(((Integer)pair.getFirst()).intValue() + 1)).x, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(((Integer)pair.getFirst()).intValue() + 1)).y);
                guiGraphics.fill(RenderType.guiGhostRecipeOverlay(), this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(((Integer)pair.getFirst()).intValue() + 1)).x, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(((Integer)pair.getFirst()).intValue() + 1)).y, this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(((Integer)pair.getFirst()).intValue() + 1)).x + 16, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.getMenu()).getSlot((int)(((Integer)pair.getFirst()).intValue() + 1)).y + 16, 0x30FFFFFF);
            });
        }
    }

    protected boolean hasClickedOutside(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (!((TravelersBackpackBaseMenu)this.menu).getCarried().isEmpty()) {
            for (GuiEventListener widget : this.children()) {
                WidgetBase base;
                if (!(widget instanceof WidgetBase) || !(base = (WidgetBase)widget).isMouseOver(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.imageWidth) || pMouseY >= (double)(pGuiTop + this.imageHeight);
    }

    protected void slotClicked(Slot slot, int slotId, int button, ClickType type) {
        super.slotClicked(slot, slotId, button, type);
        this.selectSlots(slot, button);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        Slot slot = this.getSlotUnderMouse();
        this.selectSlots(slot, pButton);
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void selectSlots(Slot slot, int button) {
        if (slot != null && slot.index >= 1 && slot.index <= this.container.getHandler().getSlots()) {
            if (this.container.getSlotManager().isSelectorActive((byte)0)) {
                if (button == 0 && !this.container.getSlotManager().isSlot((byte)0, slot.index - 1)) {
                    this.container.getSlotManager().setUnsortableSlot(slot.index - 1);
                }
                if (button == 1 && this.container.getSlotManager().isSlot((byte)0, slot.index - 1)) {
                    this.container.getSlotManager().setUnsortableSlot(slot.index - 1);
                }
            } else if (this.container.getSlotManager().isSelectorActive((byte)1)) {
                if (button == 0 && !this.container.getSlotManager().isSlot((byte)1, slot.index - 1) && !slot.getItem().isEmpty()) {
                    this.container.getSlotManager().setMemorySlot(slot.index - 1, slot.getItem());
                }
                if (button == 1 && this.container.getSlotManager().isSlot((byte)1, slot.index - 1)) {
                    this.container.getSlotManager().setMemorySlot(slot.index - 1, slot.getItem());
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.container.getSlotManager().isSelectorActive((byte)0) && !this.sortWidget.isMouseOver(mouseX, mouseY) || this.container.getSlotManager().isSelectorActive((byte)1) && !this.memoryWidget.isMouseOver(mouseX, mouseY)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (!this.container.getLeftTank().isEmpty() && this.tankLeft.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            if (this.container.getScreenID() == 1) {
                ServerActions.emptyTank(1.0, ((TravelersBackpackBaseMenu)this.menu).inventory.player, this.container.getLevel(), this.container.getScreenID());
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSpecialActionPacket(this.container.getScreenID(), 3, 1.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!this.container.getRightTank().isEmpty() && this.tankRight.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            if (this.container.getScreenID() == 1) {
                ServerActions.emptyTank(2.0, ((TravelersBackpackBaseMenu)this.menu).inventory.player, this.container.getLevel(), this.container.getScreenID());
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSpecialActionPacket(this.container.getScreenID(), 3, 2.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.buttons.forEach(b -> b.mouseClicked(mouseX, mouseY, button));
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void playUIClickSound() {
        ((TravelersBackpackBaseMenu)this.menu).inventory.player.level().playSound(((TravelersBackpackBaseMenu)this.menu).inventory.player, ((TravelersBackpackBaseMenu)this.menu).inventory.player.blockPosition(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.MASTER, 0.25f, 1.0f);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventHandler.SORT_BACKPACK.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSorterPacket(this.container.getScreenID(), 0, BackpackUtils.isShiftPressed()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.playUIClickSound();
            return true;
        }
        if (ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().player;
            if (playerEntity != null) {
                this.onClose();
            }
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }
}

