/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TankScreen {
    private final int height;
    private final int width;
    private final int startX;
    private final int startY;
    private final FluidTank tank;

    public TankScreen(FluidTank tank, int x, int y, int height, int width) {
        this.startX = x;
        this.startY = y;
        this.height = height;
        this.width = width;
        this.tank = tank;
    }

    public List<Component> getTankTooltip(Level level) {
        String fluidAmount;
        FluidStack fluidStack = this.tank.getFluid();
        ArrayList<Component> tankTips = new ArrayList<Component>();
        String fluidName = !fluidStack.isEmpty() ? fluidStack.getHoverName().getString() : I18n.get((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        String string = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + this.tank.getCapacity() : I18n.get((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.has(DataComponents.POTION_CONTENTS)) {
            fluidName = null;
            PotionContents contents = (PotionContents)fluidStack.get(DataComponents.POTION_CONTENTS);
            contents.addPotionTooltip(tankTips::add, 1.0f, level.tickRateManager().tickrate());
        }
        if (fluidName != null) {
            tankTips.add((Component)Component.literal((String)fluidName));
        }
        tankTips.add((Component)Component.literal((String)fluidAmount));
        return tankTips;
    }

    public void drawScreenFluidBar(TravelersBackpackScreen screen, GuiGraphics guiGraphics) {
        RenderUtils.renderScreenTank(guiGraphics, this.tank, screen.getGuiLeft() + this.startX, screen.getGuiTop() + this.startY, 0.0, this.height, this.width);
    }

    public boolean inTank(TravelersBackpackScreen screen, int mouseX, int mouseY) {
        return screen.getGuiLeft() + this.startX <= mouseX && mouseX <= this.startX + this.width + screen.getGuiLeft() && this.startY + screen.getGuiTop() <= mouseY && mouseY <= this.startY + this.height + screen.getGuiTop();
    }
}

