/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;

public class HudOverlay {
    public static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/travelers_backpack_overlay.png");
    private static float animationProgress = 0.0f;

    public static void renderOverlay(Minecraft mc, GuiGraphics guiGraphics) {
        LocalPlayer player = mc.player;
        Window mainWindow = mc.getWindow();
        int scaledWidth = mainWindow.getGuiScaledWidth() - (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetX.get();
        int scaledHeight = mainWindow.getGuiScaledHeight() - (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetY.get();
        int textureX = 10;
        int textureY = 0;
        TravelersBackpackContainer inv = AttachmentUtils.getBackpackInv((Player)player);
        KeyMapping key = ModClientEventHandler.SWAP_TOOL;
        List<ItemStack> tools = HudOverlay.getTools(inv.getToolSlotsHandler());
        if (key.isDown() && tools.size() > 2) {
            if (animationProgress < 1.0f) {
                animationProgress += 0.05f;
            }
            for (i = 0; i < HudOverlay.getTools(inv.getToolSlotsHandler()).size(); ++i) {
                HudOverlay.drawItemStack(guiGraphics, HudOverlay.getTools(inv.getToolSlotsHandler()).get(i), scaledWidth - 30, (int)((float)(scaledHeight + 11) - animationProgress * (float)(i * 15)));
            }
        } else if (!tools.isEmpty()) {
            if (animationProgress > 0.0f) {
                for (i = 0; i < HudOverlay.getTools(inv.getToolSlotsHandler()).size(); ++i) {
                    HudOverlay.drawItemStack(guiGraphics, HudOverlay.getTools(inv.getToolSlotsHandler()).get(i), scaledWidth - 30, (int)((float)(scaledHeight + 11) - animationProgress * (float)(i * 15)));
                }
                animationProgress -= 0.05f;
            } else {
                if (!inv.getToolSlotsHandler().getStackInSlot(0).isEmpty()) {
                    HudOverlay.drawItemStack(guiGraphics, inv.getToolSlotsHandler().getStackInSlot(0), scaledWidth - 30, scaledHeight - 4);
                }
                if (tools.size() > 1 && !inv.getToolSlotsHandler().getStackInSlot(tools.size() - 1).isEmpty()) {
                    HudOverlay.drawItemStack(guiGraphics, inv.getToolSlotsHandler().getStackInSlot(tools.size() - 1), scaledWidth - 30, scaledHeight + 11);
                }
            }
        }
        if (!inv.getRightTank().getFluid().isEmpty()) {
            HudOverlay.drawGuiTank(guiGraphics, inv.getRightTank(), scaledWidth + 1, scaledHeight, 21, 8);
        }
        if (!inv.getLeftTank().getFluid().isEmpty()) {
            HudOverlay.drawGuiTank(guiGraphics, inv.getLeftTank(), scaledWidth - 11, scaledHeight, 21, 8);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (player != null && player.getMainHandItem().getItem() instanceof HoseItem) {
            int tank = HoseItem.getHoseTank(player.getMainHandItem());
            int selectedTextureX = 0;
            int selectedTextureY = 0;
            if (tank == 1) {
                guiGraphics.blit(OVERLAY, scaledWidth, scaledHeight, textureX, textureY, 10, 23);
                guiGraphics.blit(OVERLAY, scaledWidth - 12, scaledHeight, selectedTextureX, selectedTextureY, 10, 23);
            }
            if (tank == 2) {
                guiGraphics.blit(OVERLAY, scaledWidth, scaledHeight, selectedTextureX, selectedTextureY, 10, 23);
                guiGraphics.blit(OVERLAY, scaledWidth - 12, scaledHeight, textureX, textureY, 10, 23);
            }
            if (tank == 0) {
                guiGraphics.blit(OVERLAY, scaledWidth, scaledHeight, textureX, textureY, 10, 23);
                guiGraphics.blit(OVERLAY, scaledWidth - 12, scaledHeight, textureX, textureY, 10, 23);
            }
        } else {
            guiGraphics.blit(OVERLAY, scaledWidth, scaledHeight, textureX, textureY, 10, 23);
            guiGraphics.blit(OVERLAY, scaledWidth - 12, scaledHeight, textureX, textureY, 10, 23);
        }
    }

    public static void drawGuiTank(GuiGraphics guiGraphics, FluidTank tank, int startX, int startY, int height, int width) {
        RenderUtils.renderScreenTank(guiGraphics, tank, startX, startY, 0.0, height, width);
    }

    private static void drawItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        guiGraphics.renderFakeItem(stack, x, y);
        guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y);
    }

    public static List<ItemStack> getTools(ItemStackHandler inventory) {
        ArrayList<ItemStack> tools = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).isEmpty()) continue;
            tools.add(inventory.getStackInSlot(i));
        }
        Collections.reverse(tools);
        return tools;
    }
}

