/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public TravelersBackpackWearableModel model;

    public TravelersBackpackLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer clientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        TravelersBackpackContainer inv;
        if (((Boolean)TravelersBackpackConfig.CLIENT.disableBackpackRender.get()).booleanValue() || TravelersBackpack.enableIntegration()) {
            return;
        }
        if (AttachmentUtils.isWearingBackpack((Player)clientPlayer) && (inv = AttachmentUtils.getBackpackInv((Player)clientPlayer)) != null && !clientPlayer.isInvisible()) {
            if (!((Boolean)TravelersBackpackConfig.CLIENT.renderBackpackWithElytra.get()).booleanValue() && clientPlayer.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ElytraItem) {
                return;
            }
            this.renderLayer(poseStack, bufferIn, packedLightIn, clientPlayer, inv, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    private void renderLayer(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer clientPlayer, ITravelersBackpackContainer container, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item;
        boolean flag;
        this.model = new TravelersBackpackWearableModel((LivingEntity)clientPlayer, bufferIn, TravelersBackpackBlockEntityRenderer.createTravelersBackpack(true).bakeRoot());
        boolean bl = flag = container.getItemStack().getItem() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || container.getItemStack().getItem() == ModItems.SNOW_TRAVELERS_BACKPACK.get();
        if (container.getItemStack().isEmpty() || !((item = container.getItemStack().getItem()) instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)item;
        ResourceLocation loc = travelersBackpackItem.getBackpackTexture();
        boolean isColorable = false;
        boolean isCustomSleepingBag = false;
        if (container.getItemStack().has(DataComponents.DYED_COLOR) && container.getItemStack().getItem() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            isColorable = true;
            loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed.png");
        }
        if (container.getItemStack().has(ModDataComponents.SLEEPING_BAG_COLOR)) {
            isCustomSleepingBag = true;
        }
        VertexConsumer vertexConsumer = bufferIn.getBuffer(flag ? RenderType.entityTranslucentCull((ResourceLocation)loc) : RenderType.entitySolid((ResourceLocation)loc));
        poseStack.pushPose();
        if (clientPlayer.isCrouching()) {
            poseStack.translate(0.0, -0.155, 0.025);
        }
        ((PlayerModel)this.getParentModel()).copyPropertiesTo((HumanoidModel)this.model);
        this.model.setupAngles((HumanoidModel)this.getParentModel());
        poseStack.translate(0.0, 0.175, 0.325);
        poseStack.scale(0.85f, 0.85f, 0.85f);
        if (isColorable) {
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.opaque((int)((DyedItemColor)container.getItemStack().get(DataComponents.DYED_COLOR)).rgb()));
            loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
            vertexConsumer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
        }
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
        loc = isCustomSleepingBag ? ResourceUtils.getSleepingBagTexture(container.getSleepingBagColor()) : ResourceUtils.getDefaultSleepingBagTexture();
        vertexConsumer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
        this.model.sleepingBag.render(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }
}

