/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackEntityLayer
extends RenderLayer<LivingEntity, HumanoidModel<LivingEntity>> {
    public TravelersBackpackWearableModel model;

    public TravelersBackpackEntityLayer(RenderLayerParent<LivingEntity, HumanoidModel<LivingEntity>> renderer) {
        super(renderer);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, LivingEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (((Boolean)TravelersBackpackConfig.CLIENT.disableBackpackRender.get()).booleanValue()) {
            return;
        }
        if (AttachmentUtils.isWearingBackpack(pLivingEntity) && !pLivingEntity.isInvisible()) {
            this.renderLayer(pPoseStack, pBuffer, pPackedLight, pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTick, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        }
    }

    private void renderLayer(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = AttachmentUtils.getEntityAttachment(livingEntity).get().getWearable();
        this.model = new TravelersBackpackWearableModel(livingEntity, bufferIn, TravelersBackpackBlockEntityRenderer.createTravelersBackpack(true).bakeRoot());
        boolean flag = stack.getItem() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || stack.getItem() == ModItems.SNOW_TRAVELERS_BACKPACK.get();
        boolean isCustomSleepingBag = false;
        ResourceLocation loc = ((TravelersBackpackItem)stack.getItem()).getBackpackTexture();
        if (stack.has(ModDataComponents.SLEEPING_BAG_COLOR)) {
            isCustomSleepingBag = true;
        }
        VertexConsumer vertexConsumer = bufferIn.getBuffer(flag ? RenderType.entityTranslucentCull((ResourceLocation)loc) : RenderType.entitySolid((ResourceLocation)loc));
        poseStack.pushPose();
        if (livingEntity.isCrouching()) {
            poseStack.translate(0.0, -0.155, 0.025);
        }
        if (livingEntity.isBaby()) {
            poseStack.translate(0.0, 0.65, 0.0);
            poseStack.scale(0.5f, 0.5f, 0.5f);
        }
        ((HumanoidModel)this.getParentModel()).copyPropertiesTo((HumanoidModel)this.model);
        this.model.setupAngles((HumanoidModel)this.getParentModel());
        poseStack.translate(0.0, 0.175, 0.325);
        poseStack.scale(0.85f, 0.85f, 0.85f);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
        loc = isCustomSleepingBag ? ResourceUtils.getSleepingBagTexture((Integer)stack.get(ModDataComponents.SLEEPING_BAG_COLOR)) : ResourceUtils.getDefaultSleepingBagTexture();
        vertexConsumer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
        this.model.sleepingBag.render(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }
}

