/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackBlockModel;
import com.tiviacz.travelersbackpack.client.renderer.RenderData;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TravelersBackpackBlockEntityRenderer
implements BlockEntityRenderer<TravelersBackpackBlockEntity> {
    public static final TravelersBackpackBlockModel model = new TravelersBackpackBlockModel(TravelersBackpackBlockEntityRenderer.createTravelersBackpack(false).bakeRoot());

    public TravelersBackpackBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TravelersBackpackBlockEntity blockEntity, float v, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        TravelersBackpackBlockEntityRenderer.render(blockEntity, blockEntity.getLevel(), poseStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    public static LayerDefinition createTravelersBackpack(boolean isWearable) {
        PartDefinition part;
        MeshDefinition mesh;
        if (isWearable) {
            CubeDeformation cube = CubeDeformation.NONE;
            mesh = HumanoidModel.createMesh((CubeDeformation)cube, (float)0.0f);
            part = mesh.getRoot().getChild("body");
        } else {
            mesh = new MeshDefinition();
            part = mesh.getRoot();
        }
        PartDefinition mainBody = part.addOrReplaceChild("main_body", CubeListBuilder.create().texOffs(0, 9).addBox(-5.0f, 0.0f, -3.0f, 10.0f, 9.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        mainBody.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -3.0f, 0.0f, 10.0f, 3.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        mainBody.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 34).addBox(0.0f, 0.0f, 0.0f, 10.0f, 1.0f, 4.0f), PartPose.offset((float)-5.0f, (float)9.0f, (float)-3.0f));
        mainBody.addOrReplaceChild("pocketFace", CubeListBuilder.create().texOffs(0, 24).addBox(-4.0f, -6.0f, 0.0f, 8.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)6.9f, (float)2.0f));
        mainBody.addOrReplaceChild("leftStrap", CubeListBuilder.create().texOffs(21, 24).addBox(0.0f, 0.0f, -1.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)3.0f, (float)0.0f, (float)-3.0f));
        mainBody.addOrReplaceChild("rightStrap", CubeListBuilder.create().texOffs(26, 24).addBox(0.0f, 0.0f, -1.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)-4.0f, (float)0.0f, (float)-3.0f));
        PartDefinition leftTankTop = part.addOrReplaceChild("tankLeftTop", CubeListBuilder.create().texOffs(0, 40).addBox(TravelersBackpackBlockEntityRenderer.or(isWearable, 5.0f, 0.0f), 0.0f, TravelersBackpackBlockEntityRenderer.or(isWearable, -2.5f, 0.0f), 4.0f, 1.0f, 4.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 5.0f), (float)0.0f, (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, -2.5f)));
        PartDefinition leftTankBottom = leftTankTop.addOrReplaceChild("tankLeftBottom", CubeListBuilder.create().texOffs(0, 46).addBox(0.0f, 0.0f, 0.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 5.0f, 0.0f), (float)9.0f, (float)TravelersBackpackBlockEntityRenderer.or(isWearable, -2.5f, 0.0f)));
        leftTankBottom.addOrReplaceChild("tankLeftWall1", CubeListBuilder.create().texOffs(0, 52).addBox(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)3.0f, (float)-8.0f, (float)0.0f));
        leftTankBottom.addOrReplaceChild("tankLeftWall2", CubeListBuilder.create().texOffs(5, 52).addBox(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        leftTankBottom.addOrReplaceChild("tankLeftWall3", CubeListBuilder.create().texOffs(10, 52).addBox(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)3.0f));
        leftTankBottom.addOrReplaceChild("tankLeftWall4", CubeListBuilder.create().texOffs(15, 52).addBox(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)3.0f, (float)-8.0f, (float)3.0f));
        PartDefinition rightTankTop = part.addOrReplaceChild("tankRightTop", CubeListBuilder.create().texOffs(17, 40).addBox(-9.0f, 0.0f, -2.5f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightTankBottom = rightTankTop.addOrReplaceChild("tankRightBottom", CubeListBuilder.create().texOffs(17, 46).addBox(0.0f, 0.0f, 0.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)-9.0f, (float)9.0f, (float)-2.5f));
        rightTankBottom.addOrReplaceChild("tankRightWall1", CubeListBuilder.create().texOffs(22, 52).addBox(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)3.0f, (float)-8.0f, (float)3.0f));
        rightTankBottom.addOrReplaceChild("tankRightWall2", CubeListBuilder.create().texOffs(27, 52).addBox(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)3.0f, (float)-8.0f, (float)0.0f));
        rightTankBottom.addOrReplaceChild("tankRightWall3", CubeListBuilder.create().texOffs(32, 52).addBox(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)3.0f));
        rightTankBottom.addOrReplaceChild("tankRightWall4", CubeListBuilder.create().texOffs(37, 52).addBox(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition sleepingBag = part.addOrReplaceChild("sleepingBag", CubeListBuilder.create().texOffs(31, 0).addBox(TravelersBackpackBlockEntityRenderer.or(isWearable, -7.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 7.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 2.0f, 0.0f), 14.0f, 2.0f, 2.0f), PartPose.offset((float)-7.0f, (float)7.0f, (float)2.0f));
        PartDefinition sleepingBagExtras = part.addOrReplaceChild("sleepingBagExtras", CubeListBuilder.create().texOffs(64, 64).addBox(TravelersBackpackBlockEntityRenderer.or(isWearable, -7.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 7.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 2.0f, 0.0f), 0.0f, 0.0f, 0.0f), PartPose.offset((float)-7.0f, (float)7.0f, (float)2.0f));
        sleepingBagExtras.addOrReplaceChild("sleepingBagStrapRightTop", CubeListBuilder.create().texOffs(40, 5).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, -5.0f, 2.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 6.0f, -1.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 2.0f, 0.0f)));
        sleepingBagExtras.addOrReplaceChild("sleepingBagStrapRightMid", CubeListBuilder.create().texOffs(38, 10).addBox(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, -5.0f, 2.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 7.0f, 0.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 2.0f)));
        sleepingBagExtras.addOrReplaceChild("sleepingBagStrapRightBottom", CubeListBuilder.create().texOffs(42, 15).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 3.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, -5.0f, 2.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 9.0f, 2.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 1.0f, -1.0f)));
        sleepingBagExtras.addOrReplaceChild("sleepingBagStrapLeftTop", CubeListBuilder.create().texOffs(31, 5).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 11.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 6.0f, -1.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 2.0f, 0.0f)));
        sleepingBagExtras.addOrReplaceChild("sleepingBagStrapLeftMid", CubeListBuilder.create().texOffs(31, 10).addBox(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 3.0f, 10.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 7.0f, 0.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 2.0f)));
        sleepingBagExtras.addOrReplaceChild("sleepingBagStrapLeftBottom", CubeListBuilder.create().texOffs(31, 15).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 3.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 3.0f, 10.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 9.0f, 2.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 1.0f, -1.0f)));
        part.addOrReplaceChild("villagerNose", CubeListBuilder.create().texOffs(31, 20).addBox(TravelersBackpackBlockEntityRenderer.or(isWearable, -1.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 0.0f), 2.0f, 4.0f, 2.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, -1.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 4.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 4.0f)));
        part.addOrReplaceChild("ocelotNose", CubeListBuilder.create().texOffs(42, 20).addBox(TravelersBackpackBlockEntityRenderer.or(isWearable, -1.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 0.0f), 3.0f, 2.0f, 1.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, -1.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 3.9f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 4.0f)));
        part.addOrReplaceChild("pigNose", CubeListBuilder.create().texOffs(42, 20).addBox(TravelersBackpackBlockEntityRenderer.or(isWearable, -2.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 0.0f), 4.0f, 3.0f, 1.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, -2.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 4.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 4.0f)));
        part.addOrReplaceChild("foxNose", CubeListBuilder.create().texOffs(31, 27).addBox(TravelersBackpackBlockEntityRenderer.or(isWearable, -2.0f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.9f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 0.0f), 4.0f, 2.0f, 3.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, -2.0f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 4.9f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 4.0f)));
        part.addOrReplaceChild("wolfNose", CubeListBuilder.create().texOffs(46, 25).addBox(TravelersBackpackBlockEntityRenderer.or(isWearable, -1.5f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 3.9f, 0.0f), TravelersBackpackBlockEntityRenderer.or(isWearable, 4.0f, 0.0f), 3.0f, 3.0f, 3.0f), PartPose.offset((float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, -1.5f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 3.9f), (float)TravelersBackpackBlockEntityRenderer.or(isWearable, 0.0f, 4.0f)));
        part.addOrReplaceChild("stacks", CubeListBuilder.create(), PartPose.ZERO);
        part.addOrReplaceChild("fluids", CubeListBuilder.create(), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public static float or(boolean isWearable, float first, float second) {
        return isWearable ? first : second;
    }

    public static void render(ITravelersBackpackContainer inv, Level level, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate;
        boolean flag = level != null;
        boolean isBlockEntity = inv instanceof TravelersBackpackBlockEntity;
        BlockState blockState = blockstate = flag && isBlockEntity ? ((TravelersBackpackBlockEntity)inv).getBlockState() : ((TravelersBackpackBlock)((Object)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get())).defaultBlockState();
        if (blockstate.getBlock() instanceof TravelersBackpackBlock) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            Direction direction = !flag || !isBlockEntity ? Direction.SOUTH : ((TravelersBackpackBlockEntity)inv).getBlockDirection((TravelersBackpackBlockEntity)inv);
            if (direction == Direction.NORTH) {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            if (direction == Direction.EAST) {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            }
            if (direction == Direction.SOUTH) {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
            }
            if (direction == Direction.WEST) {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            poseStack.scale(0.7777778f, 0.7692308f, 0.7777778f);
            poseStack.translate(0.0, 0.016, 0.0);
            model.render(inv, poseStack, buffer, combinedLightIn, combinedOverlayIn);
            poseStack.popPose();
        }
    }

    public static void renderByItem(RenderData inv, PoseStack poseStack, MultiBufferSource vertexConsumer, int combinedLightIn, int combinedOverlayIn) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
        poseStack.scale(0.7777778f, 0.7692308f, 0.7777778f);
        poseStack.translate(0.0, 0.016, 0.0);
        model.renderByItem(inv, poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
    }
}

