/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.screens.HudOverlay;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;

public class StackModelPart
extends ModelPart {
    public StackModelPart(ModelPart parent) {
        super(parent.cubes, parent.children);
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, Player player, MultiBufferSource buffer, int combinedLight, int combinedOverlay, int pColor) {
        BakedModel model;
        TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
        List<ItemStack> tools = HudOverlay.getTools(container.getToolSlotsHandler());
        if (tools.isEmpty()) {
            return;
        }
        ItemStack toolUpper = container.getToolSlotsHandler().getStackInSlot(0);
        ItemStack toolLower = ItemStack.EMPTY;
        if (!toolUpper.isEmpty() && tools.size() > 1) {
            toolLower = container.getToolSlotsHandler().getStackInSlot(tools.size() - 1);
        }
        poseStack.pushPose();
        this.translateAndRotate(poseStack);
        if (!toolUpper.isEmpty()) {
            model = Minecraft.getInstance().getItemRenderer().getModel(toolUpper, player.level(), (LivingEntity)player, 0);
            model = ClientHooks.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)ItemDisplayContext.NONE, (boolean)false);
            poseStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            poseStack.translate(0.05, 0.075, 0.27);
            poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.scale(0.65f, 0.65f, 0.65f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            Minecraft.getInstance().getItemRenderer().render(toolUpper, ItemDisplayContext.NONE, false, poseStack, buffer, combinedLight, combinedOverlay, model);
            RenderSystem.disableBlend();
            poseStack.popPose();
        }
        if (!toolLower.isEmpty()) {
            model = Minecraft.getInstance().getItemRenderer().getModel(toolLower, player.level(), (LivingEntity)player, 0);
            model = ClientHooks.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)ItemDisplayContext.NONE, (boolean)false);
            poseStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            poseStack.translate(-0.35, 0.95, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            poseStack.scale(0.65f, 0.65f, 0.65f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            Minecraft.getInstance().getItemRenderer().render(toolLower, ItemDisplayContext.NONE, false, poseStack, buffer, combinedLight, combinedOverlay, model);
            RenderSystem.disableBlend();
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

