/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability.entity;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.network.ClientboundSyncAttachmentPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.UnknownNullability;

public class TravelersBackpackEntitySerializable
implements INBTSerializable<CompoundTag>,
IEntityTravelersBackpack {
    private ItemStack wearable = new ItemStack((ItemLike)Items.AIR, 0);
    private final LivingEntity livingEntity;

    public TravelersBackpackEntitySerializable(IAttachmentHolder holder) {
        this.livingEntity = (LivingEntity)holder;
    }

    @Override
    public boolean hasWearable() {
        return !this.wearable.isEmpty();
    }

    @Override
    public ItemStack getWearable() {
        return this.wearable;
    }

    @Override
    public void setWearable(ItemStack stack) {
        this.wearable = stack;
    }

    @Override
    public void removeWearable() {
        this.wearable = new ItemStack((ItemLike)Items.AIR, 0);
    }

    @Override
    public void synchronise() {
        if (this.livingEntity != null && !this.livingEntity.level().isClientSide) {
            AttachmentUtils.getEntityAttachment(this.livingEntity).ifPresent(data -> PacketDistributor.sendToPlayersTrackingEntity((Entity)this.livingEntity, (CustomPacketPayload)new ClientboundSyncAttachmentPacket(this.livingEntity.getId(), false, this.wearable), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        if (this.hasWearable()) {
            ItemStack wearable = this.getWearable();
            wearable.save(provider, (Tag)compound);
        }
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ItemStack wearable = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt);
        this.setWearable(wearable);
    }
}

