/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.network.ClientboundSyncAttachmentPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.UnknownNullability;

public class TravelersBackpackSerializable
implements ITravelersBackpack,
INBTSerializable<CompoundTag> {
    public final Player player;
    public TravelersBackpackContainer container;
    public ItemStack wearable = new ItemStack((ItemLike)Items.AIR, 0);

    public TravelersBackpackSerializable(IAttachmentHolder holder) {
        this.player = (Player)holder;
        this.container = new TravelersBackpackContainer(this.wearable, this.player, 2);
    }

    @Override
    public boolean hasWearable() {
        return !this.wearable.isEmpty();
    }

    @Override
    public ItemStack getWearable() {
        return this.wearable;
    }

    @Override
    public void setWearable(ItemStack stack) {
        this.wearable = stack;
    }

    @Override
    public void removeWearable() {
        this.wearable = new ItemStack((ItemLike)Items.AIR, 0);
        this.container.setStack(new ItemStack((ItemLike)Items.AIR, 0));
    }

    @Override
    public TravelersBackpackContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContents(ItemStack stack) {
        this.container.setStack(stack);
        if (!stack.isEmpty()) {
            this.container.loadAllData();
        }
    }

    @Override
    public void synchronise() {
        if (this.player != null && !this.player.level().isClientSide) {
            ServerPlayer serverPlayer = (ServerPlayer)this.player;
            AttachmentUtils.getAttachment((Player)serverPlayer).ifPresent(cap -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundSyncAttachmentPacket(serverPlayer.getId(), true, this.wearable), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    @Override
    public void synchroniseToOthers(Player player) {
        if (player != null && !player.level().isClientSide) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AttachmentUtils.getAttachment((Player)serverPlayer).ifPresent(cap -> PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)new ClientboundSyncAttachmentPacket(serverPlayer.getId(), true, this.wearable), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        if (this.hasWearable()) {
            ItemStack wearable = this.getWearable();
            compound = (CompoundTag)wearable.saveOptional(provider);
        }
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ItemStack wearable = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt);
        this.setWearable(wearable);
        this.setContents(wearable);
    }
}

