/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.init.ModAttachmentTypes;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AttachmentUtils {
    public static Optional<ITravelersBackpack> getAttachment(Player player) {
        return Optional.of((ITravelersBackpack)player.getData(ModAttachmentTypes.TRAVELERS_BACKPACK.get()));
    }

    public static Optional<IEntityTravelersBackpack> getEntityAttachment(LivingEntity livingEntity) {
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(livingEntity.getType())) {
            return Optional.of((IEntityTravelersBackpack)livingEntity.getData(ModAttachmentTypes.TRAVELERS_BACKPACK_ENTITY.get()));
        }
        return Optional.empty();
    }

    public static void synchronise(Player player) {
        AttachmentUtils.getAttachment(player).ifPresent(ITravelersBackpack::synchronise);
    }

    public static void synchroniseToOthers(Player player) {
        AttachmentUtils.getAttachment(player).ifPresent(data -> data.synchroniseToOthers(player));
    }

    public static void synchroniseEntity(LivingEntity livingEntity) {
        AttachmentUtils.getEntityAttachment(livingEntity).ifPresent(IEntityTravelersBackpack::synchronise);
    }

    public static boolean isWearingBackpack(Player player) {
        Optional<ITravelersBackpack> data = AttachmentUtils.getAttachment(player);
        ItemStack backpack = data.map(ITravelersBackpack::getWearable).orElse(ItemStack.EMPTY);
        return data.map(ITravelersBackpack::hasWearable).orElse(false) != false && backpack.getItem() instanceof TravelersBackpackItem;
    }

    public static boolean isWearingBackpack(LivingEntity livingEntity) {
        Optional<IEntityTravelersBackpack> data = AttachmentUtils.getEntityAttachment(livingEntity);
        ItemStack backpack = data.map(IEntityTravelersBackpack::getWearable).orElse(ItemStack.EMPTY);
        return data.map(IEntityTravelersBackpack::hasWearable).orElse(false) != false && backpack.getItem() instanceof TravelersBackpackItem;
    }

    public static ItemStack getWearingBackpack(Player player) {
        Optional<ITravelersBackpack> data = AttachmentUtils.getAttachment(player);
        ItemStack backpack = data.map(ITravelersBackpack::getWearable).orElse(ItemStack.EMPTY);
        return AttachmentUtils.isWearingBackpack(player) ? backpack : ItemStack.EMPTY;
    }

    public static ItemStack getWearingBackpack(LivingEntity livingEntity) {
        Optional<IEntityTravelersBackpack> data = AttachmentUtils.getEntityAttachment(livingEntity);
        ItemStack backpack = data.map(IEntityTravelersBackpack::getWearable).orElse(ItemStack.EMPTY);
        return AttachmentUtils.isWearingBackpack(livingEntity) ? backpack : ItemStack.EMPTY;
    }

    public static void equipBackpack(Player player, ItemStack stack) {
        if (player.level().isClientSide) {
            return;
        }
        Optional<ITravelersBackpack> data = AttachmentUtils.getAttachment(player);
        if (!data.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
            data.ifPresent(inv -> inv.setWearable(stack));
            data.ifPresent(inv -> inv.setContents(stack));
            player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, (1.0f + (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.2f) * 0.7f);
            AttachmentUtils.synchronise(player);
            AttachmentUtils.synchroniseToOthers(player);
        }
    }

    @Nullable
    public static TravelersBackpackContainer getBackpackInv(Player player) {
        ItemStack wearable = AttachmentUtils.getWearingBackpack(player);
        if (wearable.getItem() instanceof TravelersBackpackItem) {
            return AttachmentUtils.getAttachment(player).map(ITravelersBackpack::getContainer).orElse(null);
        }
        return null;
    }
}

