/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blockentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.FluidTanks;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class TravelersBackpackBlockEntity
extends BlockEntity
implements ITravelersBackpackContainer,
MenuProvider,
Nameable {
    private ItemStackHandler inventory = this.createHandler((NonNullList<ItemStack>)NonNullList.withSize((int)Tiers.LEATHER.getStorageSlots(), (Object)ItemStack.EMPTY), true);
    private ItemStackHandler craftingInventory = this.createHandler((NonNullList<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY), false);
    private ItemStackHandler toolSlots = this.createToolsHandler((NonNullList<ItemStack>)NonNullList.withSize((int)Tiers.LEATHER.getToolSlots(), (Object)ItemStack.EMPTY));
    private final ItemStackHandler fluidSlots = this.createTemporaryHandler();
    private final FluidTank leftTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final FluidTank rightTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private SlotManager slotManager = new SlotManager(this);
    private SettingsManager settingsManager = new SettingsManager(this);
    private Player player = null;
    private boolean isSleepingBagDeployed = false;
    private int color = 0;
    private int sleepingBagColor = DyeColor.RED.getId();
    private Tiers.Tier tier = Tiers.LEATHER;
    private boolean ability;
    private int lastTime;
    private Component customName;

    public TravelersBackpackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.TRAVELERS_BACKPACK.get(), pos, state);
        this.ability = (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get();
        this.lastTime = 0;
        this.customName = null;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        this.saveAllData(compound, pRegistries);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.loadAllData(compound, pRegistries);
    }

    @Override
    public ItemStackHandler getHandler() {
        return this.inventory;
    }

    @Override
    public ItemStackHandler getToolSlotsHandler() {
        return this.toolSlots;
    }

    @Override
    public ItemStackHandler getCraftingGridHandler() {
        return this.craftingInventory;
    }

    @Override
    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlots;
    }

    @Override
    public IItemHandlerModifiable getCombinedHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.getHandler(), this.getToolSlotsHandler(), this.getFluidSlotsHandler(), this.getCraftingGridHandler()});
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public void saveTier(CompoundTag compound) {
        compound.putInt("Tier", this.tier.getOrdinal());
    }

    public void loadTier(CompoundTag compound) {
        this.tier = compound.contains("Tier") ? Tiers.of(compound.getInt("Tier")) : ((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.enableTierUpgrades.get() != false ? Tiers.LEATHER : Tiers.DIAMOND);
    }

    public void saveItems(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(provider));
        compound.put("ToolsInventory", (Tag)this.toolSlots.serializeNBT(provider));
        compound.put("CraftingInventory", (Tag)this.craftingInventory.serializeNBT(provider));
    }

    public void loadItems(CompoundTag compound, HolderLookup.Provider provider) {
        this.inventory.deserializeNBT(provider, compound.getCompound("Inventory"));
        this.toolSlots.deserializeNBT(provider, compound.getCompound("ToolsInventory"));
        this.craftingInventory.deserializeNBT(provider, compound.getCompound("CraftingInventory"));
    }

    public void saveTanks(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("LeftTank", (Tag)this.leftTank.writeToNBT(provider, new CompoundTag()));
        compound.put("RightTank", (Tag)this.rightTank.writeToNBT(provider, new CompoundTag()));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        this.tier = Tiers.of((Integer)pComponentInput.getOrDefault((DataComponentType)ModDataComponents.TIER.get(), (Object)0));
        this.inventory = this.createHandler(((BackpackContainerContents)pComponentInput.getOrDefault((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), (Object)BackpackContainerContents.fromItems(this.tier.getStorageSlots(), (List<ItemStack>)NonNullList.withSize((int)this.tier.getStorageSlots(), (Object)ItemStack.EMPTY)))).getItems(), true);
        this.toolSlots = this.createToolsHandler(((BackpackContainerContents)pComponentInput.getOrDefault((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get(), (Object)BackpackContainerContents.fromItems(this.tier.getToolSlots(), (List<ItemStack>)NonNullList.withSize((int)this.tier.getToolSlots(), (Object)ItemStack.EMPTY)))).getItems());
        this.craftingInventory = this.createHandler(((BackpackContainerContents)pComponentInput.getOrDefault((DataComponentType)ModDataComponents.CRAFTING_CONTAINER.get(), (Object)BackpackContainerContents.fromItems(9, (List<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY)))).getItems(), false);
        FluidTanks tanks = (FluidTanks)pComponentInput.getOrDefault(ModDataComponents.FLUID_TANKS, (Object)FluidTanks.createTanks(this.tier.getTankCapacity()));
        this.leftTank.setCapacity(tanks.capacity());
        this.leftTank.setFluid(tanks.leftFluidStack());
        this.rightTank.setCapacity(tanks.capacity());
        this.rightTank.setFluid(tanks.rightFluidStack());
        this.color = ((DyedItemColor)pComponentInput.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0, true))).rgb();
        this.sleepingBagColor = (Integer)pComponentInput.getOrDefault(ModDataComponents.SLEEPING_BAG_COLOR, (Object)DyeColor.RED.getId());
        this.settingsManager = this.settingsManager.getManager((List)pComponentInput.getOrDefault(ModDataComponents.SETTINGS, this.settingsManager.createDefaults()));
        this.slotManager = this.slotManager.getManager((Slots)pComponentInput.getOrDefault(ModDataComponents.SLOTS, (Object)Slots.createDefault()));
        this.lastTime = (Integer)pComponentInput.getOrDefault(ModDataComponents.LAST_TIME, (Object)0);
        this.customName = (Component)pComponentInput.getOrDefault(DataComponents.CUSTOM_NAME, null);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(ModDataComponents.TIER, (Object)this.tier.getOrdinal());
        if (!ContainerUtils.isEmpty(this.inventory)) {
            pComponents.set(ModDataComponents.BACKPACK_CONTAINER, (Object)this.itemsToList(this.inventory.getSlots(), this.inventory));
        }
        if (!ContainerUtils.isEmpty(this.toolSlots)) {
            pComponents.set(ModDataComponents.TOOLS_CONTAINER, (Object)this.itemsToList(this.toolSlots.getSlots(), this.toolSlots));
        }
        if (!ContainerUtils.isEmpty(this.craftingInventory)) {
            pComponents.set(ModDataComponents.CRAFTING_CONTAINER, (Object)this.itemsToList(this.craftingInventory.getSlots(), this.craftingInventory));
        }
        if (!this.leftTank.isEmpty() || !this.rightTank.isEmpty()) {
            pComponents.set(ModDataComponents.FLUID_TANKS, (Object)new FluidTanks(this.leftTank.getCapacity(), this.leftTank.getFluid(), this.rightTank.getFluid()));
        }
        if (this.hasColor()) {
            pComponents.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(this.color, true));
        }
        if (this.hasSleepingBagColor()) {
            pComponents.set(ModDataComponents.SLEEPING_BAG_COLOR, (Object)this.sleepingBagColor);
        }
        if (!this.settingsManager.isDefault()) {
            pComponents.set(ModDataComponents.SETTINGS, this.settingsManager.getSettings());
        }
        if (!this.slotManager.getMemorySlots().isEmpty() || !this.slotManager.getUnsortableSlots().isEmpty()) {
            pComponents.set(ModDataComponents.SLOTS, (Object)this.slotManager.getSlots());
        }
        if (this.lastTime != 0) {
            pComponents.set(ModDataComponents.LAST_TIME, (Object)this.lastTime);
        }
        if (this.hasCustomName()) {
            pComponents.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
    }

    public void loadTanks(CompoundTag compound, HolderLookup.Provider provider) {
        this.leftTank.readFromNBT(provider, compound.getCompound("LeftTank"));
        this.rightTank.readFromNBT(provider, compound.getCompound("RightTank"));
    }

    public void saveColor(CompoundTag compound) {
        compound.putInt("Color", this.color);
    }

    public void loadColor(CompoundTag compound) {
        this.color = compound.getInt("Color");
    }

    public void saveSleepingBagColor(CompoundTag compound) {
        compound.putInt("SleepingBagColor", this.sleepingBagColor);
    }

    public void loadSleepingBagColor(CompoundTag compound) {
        this.sleepingBagColor = compound.contains("SleepingBagColor") ? compound.getInt("SleepingBagColor") : DyeColor.RED.getId();
    }

    public void saveAbility(CompoundTag compound) {
        compound.putBoolean("Ability", this.ability);
    }

    public void loadAbility(CompoundTag compound) {
        this.ability = !compound.contains("Ability") && (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get() != false || compound.getBoolean("Ability");
    }

    public void saveTime(CompoundTag compound) {
        compound.putInt("LastTime", this.lastTime);
    }

    public void loadTime(CompoundTag compound) {
        this.lastTime = compound.getInt("LastTime");
    }

    public void saveSleepingBag(CompoundTag compound) {
        compound.putBoolean("SleepingBag", this.isSleepingBagDeployed);
    }

    public void loadSleepingBag(CompoundTag compound) {
        this.isSleepingBagDeployed = compound.getBoolean("SleepingBag");
    }

    public void saveName(CompoundTag compound, HolderLookup.Provider pRegistries) {
        if (this.customName != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)pRegistries));
        }
    }

    public void loadName(CompoundTag compound, HolderLookup.Provider pRegistries) {
        if (compound.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)compound.getString("CustomName"), (HolderLookup.Provider)pRegistries);
        }
    }

    public void saveAllData(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.saveTier(compound);
        this.saveTanks(compound, pRegistries);
        this.saveItems(compound, pRegistries);
        this.saveSleepingBag(compound);
        this.saveColor(compound);
        this.saveSleepingBagColor(compound);
        this.saveAbility(compound);
        this.saveTime(compound);
        this.saveName(compound, pRegistries);
        this.slotManager.saveUnsortableSlots(compound);
        this.slotManager.saveMemorySlots(pRegistries, compound);
        this.settingsManager.saveSettings(compound);
    }

    public void loadAllData(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.loadTier(compound);
        this.loadTanks(compound, pRegistries);
        this.loadItems(compound, pRegistries);
        this.loadSleepingBag(compound);
        this.loadColor(compound);
        this.loadSleepingBagColor(compound);
        this.loadAbility(compound);
        this.loadTime(compound);
        this.loadName(compound, pRegistries);
        this.slotManager.loadUnsortableSlots(compound);
        this.slotManager.loadMemorySlots(pRegistries, compound);
        this.settingsManager.loadSettings(compound);
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 0, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 2, this.player);
    }

    @Override
    public boolean hasColor() {
        return this.color != 0;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.sleepingBagColor != DyeColor.RED.getId();
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.sleepingBagColor;
        }
        return DyeColor.RED.getId();
    }

    public void setSleepingBagColor(int colorId) {
        this.sleepingBagColor = colorId;
    }

    @Override
    public boolean getAbilityValue() {
        return ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() ? (BackpackAbilities.ALLOWED_ABILITIES.contains(this.getItemStack().getItem()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
        this.setDataChanged();
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((double)this.getHandler().getSlots() / 9.0);
    }

    @Override
    public int getYOffset() {
        return 18 * Math.max(0, this.getRows() - 3);
    }

    @Override
    public boolean hasBlockEntity() {
        return true;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    public void resetTier() {
        this.tier = Tiers.LEATHER;
        this.setDataChanged();
    }

    @Override
    public Level getLevel() {
        return super.getLevel();
    }

    @Override
    public BlockPos getPosition() {
        return this.getBlockPos();
    }

    @Override
    public byte getScreenID() {
        return 3;
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.level.getBlockState(this.getBlockPos()).getBlock();
        if (block instanceof TravelersBackpackBlock) {
            TravelersBackpackBlock block2 = (TravelersBackpackBlock)block;
            return new ItemStack((ItemLike)block2);
        }
        return new ItemStack((ItemLike)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get());
    }

    @Override
    public void setUsingPlayer(@Nullable Player player) {
        this.player = player;
    }

    @Override
    public void setDataChanged(byte ... dataIds) {
    }

    @Override
    public void setDataChanged() {
        if (!this.level.isClientSide) {
            super.setChanged();
            if (this.slotManager.isSelectorActive((byte)1) || this.slotManager.isSelectorActive((byte)0)) {
                return;
            }
            this.notifyBlockUpdate();
        }
    }

    private void notifyBlockUpdate() {
        BlockState blockstate = this.getLevel().getBlockState(this.getBlockPos());
        this.getLevel().setBlocksDirty(this.getBlockPos(), blockstate, blockstate);
        this.getLevel().sendBlockUpdated(this.getBlockPos(), blockstate, blockstate, 3);
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
    }

    public boolean deploySleepingBag(Level level, BlockPos pos) {
        BlockPos sleepingBagPos1;
        BlockPos sleepingBagPos2;
        Direction direction = this.getBlockDirection(level.getBlockEntity(this.getBlockPos()));
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed && level.getBlockState(sleepingBagPos2 = (sleepingBagPos1 = pos.relative(direction)).relative(direction)).isAir() && level.getBlockState(sleepingBagPos1).isAir() && level.getBlockState(sleepingBagPos1.below()).isCollisionShapeFullBlock((BlockGetter)level, sleepingBagPos1.below()) && level.getBlockState(sleepingBagPos2.below()).isCollisionShapeFullBlock((BlockGetter)level, sleepingBagPos2.below())) {
            level.playSound(null, sleepingBagPos2, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (!level.isClientSide) {
                BlockState sleepingBagState = this.getProperSleepingBag(this.getSleepingBagColor());
                level.setBlock(sleepingBagPos1, (BlockState)((BlockState)((BlockState)sleepingBagState.setValue((Property)SleepingBagBlock.FACING, (Comparable)direction)).setValue(SleepingBagBlock.PART, (Comparable)BedPart.FOOT)).setValue((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.setBlock(sleepingBagPos2, (BlockState)((BlockState)((BlockState)sleepingBagState.setValue((Property)SleepingBagBlock.FACING, (Comparable)direction)).setValue(SleepingBagBlock.PART, (Comparable)BedPart.HEAD)).setValue((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.updateNeighborsAt(pos, sleepingBagState.getBlock());
                level.updateNeighborsAt(sleepingBagPos2, sleepingBagState.getBlock());
            }
            this.isSleepingBagDeployed = true;
            this.setDataChanged();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(Level level, Direction direction) {
        this.isThereSleepingBag(direction);
        if (this.isSleepingBagDeployed()) {
            BlockPos sleepingBagPos1 = this.getBlockPos().relative(direction);
            BlockPos sleepingBagPos2 = sleepingBagPos1.relative(direction);
            if (level.getBlockState(sleepingBagPos1).getBlock() instanceof SleepingBagBlock && level.getBlockState(sleepingBagPos2).getBlock() instanceof SleepingBagBlock) {
                level.playSound(null, sleepingBagPos2, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.5f, 1.0f);
                level.setBlock(sleepingBagPos2, Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(sleepingBagPos1, Blocks.AIR.defaultBlockState(), 3);
                this.isSleepingBagDeployed = false;
                this.setDataChanged();
                return true;
            }
        } else {
            this.isSleepingBagDeployed = false;
            this.setDataChanged();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(Direction direction) {
        if (this.level.getBlockState(this.getBlockPos().relative(direction)).getBlock() instanceof SleepingBagBlock && this.level.getBlockState(this.getBlockPos().relative(direction).relative(direction)).getBlock() instanceof SleepingBagBlock) {
            return true;
        }
        this.isSleepingBagDeployed = false;
        return false;
    }

    public BlockState getProperSleepingBag(int colorId) {
        return switch (colorId) {
            case 0 -> ((SleepingBagBlock)((Object)ModBlocks.WHITE_SLEEPING_BAG.get())).defaultBlockState();
            case 1 -> ((SleepingBagBlock)((Object)ModBlocks.ORANGE_SLEEPING_BAG.get())).defaultBlockState();
            case 2 -> ((SleepingBagBlock)((Object)ModBlocks.MAGENTA_SLEEPING_BAG.get())).defaultBlockState();
            case 3 -> ((SleepingBagBlock)((Object)ModBlocks.LIGHT_BLUE_SLEEPING_BAG.get())).defaultBlockState();
            case 4 -> ((SleepingBagBlock)((Object)ModBlocks.YELLOW_SLEEPING_BAG.get())).defaultBlockState();
            case 5 -> ((SleepingBagBlock)((Object)ModBlocks.LIME_SLEEPING_BAG.get())).defaultBlockState();
            case 6 -> ((SleepingBagBlock)((Object)ModBlocks.PINK_SLEEPING_BAG.get())).defaultBlockState();
            case 7 -> ((SleepingBagBlock)((Object)ModBlocks.GRAY_SLEEPING_BAG.get())).defaultBlockState();
            case 8 -> ((SleepingBagBlock)((Object)ModBlocks.LIGHT_GRAY_SLEEPING_BAG.get())).defaultBlockState();
            case 9 -> ((SleepingBagBlock)((Object)ModBlocks.CYAN_SLEEPING_BAG.get())).defaultBlockState();
            case 10 -> ((SleepingBagBlock)((Object)ModBlocks.PURPLE_SLEEPING_BAG.get())).defaultBlockState();
            case 11 -> ((SleepingBagBlock)((Object)ModBlocks.BLUE_SLEEPING_BAG.get())).defaultBlockState();
            case 12 -> ((SleepingBagBlock)((Object)ModBlocks.BROWN_SLEEPING_BAG.get())).defaultBlockState();
            case 13 -> ((SleepingBagBlock)((Object)ModBlocks.GREEN_SLEEPING_BAG.get())).defaultBlockState();
            case 14 -> ((SleepingBagBlock)((Object)ModBlocks.RED_SLEEPING_BAG.get())).defaultBlockState();
            case 15 -> ((SleepingBagBlock)((Object)ModBlocks.BLACK_SLEEPING_BAG.get())).defaultBlockState();
            default -> ((SleepingBagBlock)((Object)ModBlocks.RED_SLEEPING_BAG.get())).defaultBlockState();
        };
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.level.getBlockEntity(this.getBlockPos()) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    public Direction getBlockDirection(BlockEntity blockEntity) {
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            if (this.level == null || !(this.level.getBlockState(this.getBlockPos()).getBlock() instanceof TravelersBackpackBlock)) {
                return Direction.NORTH;
            }
            return (Direction)this.level.getBlockState(this.getBlockPos()).getValue((Property)TravelersBackpackBlock.FACING);
        }
        return Direction.NORTH;
    }

    public boolean hasData() {
        boolean isDefaultTier = this.getTier() == Tiers.LEATHER;
        boolean isInvEmpty = ContainerUtils.isEmpty(this.getHandler());
        boolean isToolsEmpty = ContainerUtils.isEmpty(this.getToolSlotsHandler());
        boolean isCraftingGridEmpty = ContainerUtils.isEmpty(this.getCraftingGridHandler());
        boolean leftTankEmpty = this.getLeftTank().isEmpty();
        boolean rightTankEmpty = this.getRightTank().isEmpty();
        boolean hasColor = this.hasColor();
        boolean hasSleepingBagColor = this.hasSleepingBagColor();
        boolean hasTime = this.getLastTime() != 0;
        boolean hasUnsortableSlots = !this.slotManager.getUnsortableSlots().isEmpty();
        boolean hasMemorySlots = !this.slotManager.getMemorySlots().isEmpty();
        boolean hasChangedSettings = !this.settingsManager.isDefault();
        boolean hasCustomName = this.hasCustomName();
        return !isDefaultTier || !isInvEmpty || !isToolsEmpty || !isCraftingGridEmpty || !leftTankEmpty || !rightTankEmpty || hasColor || hasSleepingBagColor || hasTime || hasUnsortableSlots || hasMemorySlots || hasChangedSettings || hasCustomName;
    }

    public ItemStack transferToItemStack(ItemStack stack) {
        DataComponentMap.Builder map = DataComponentMap.builder();
        this.collectImplicitComponents(map);
        stack.applyComponents(map.build());
        return stack;
    }

    public BackpackContainerContents itemsToList(int size, ItemStackHandler handler) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            list.add(handler.getStackInSlot(i));
        }
        return BackpackContainerContents.fromItems(size, list);
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getDefaultName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        super.onDataPacket(net, pkt, pRegistries);
        this.handleUpdateTag(pkt.getTag(), pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity.getAbilityValue() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, blockEntity.getItemStack())) {
            if (blockEntity.getLastTime() > 0) {
                blockEntity.setLastTime(blockEntity.getLastTime() - 1);
                blockEntity.setDataChanged();
            }
            BackpackAbilities.ABILITIES.abilityTick(null, null, blockEntity);
        }
    }

    public void openGUI(Player player, MenuProvider containerSupplier, BlockPos pos) {
        if (!player.level().isClientSide && this.player == null) {
            ((ServerPlayer)player).openMenu(containerSupplier, pos);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new TravelersBackpackBlockEntityMenu(id, inventory, this);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> stacks, final boolean isInventory) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                TravelersBackpackBlockEntity.this.setDataChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return BackpackSlotItemHandler.isItemValid(stack);
            }

            public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
                if (isInventory) {
                    this.setSize(nbt.contains("Size", 3) ? nbt.getInt("Size") : TravelersBackpackBlockEntity.this.tier.getStorageSlots());
                    ListTag tagList = nbt.getList("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundTag itemTags = tagList.getCompound(i);
                        int slot = itemTags.getInt("Slot");
                        if (slot < 0 || slot >= this.stacks.size()) continue;
                        ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemTags).ifPresent(stack -> this.stacks.set(slot, stack));
                    }
                    this.onLoad();
                } else {
                    super.deserializeNBT(provider, nbt);
                }
            }
        };
    }

    private ItemStackHandler createToolsHandler(NonNullList<ItemStack> items) {
        return new ItemStackHandler(items){

            protected void onContentsChanged(int slot) {
                TravelersBackpackBlockEntity.this.setDataChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return ToolSlotItemHandler.isValid(stack);
            }

            public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
                this.setSize(nbt.contains("Size", 3) ? nbt.getInt("Size") : TravelersBackpackBlockEntity.this.tier.getToolSlots());
                ListTag tagList = nbt.getList("Items", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag itemTags = tagList.getCompound(i);
                    int slot = itemTags.getInt("Slot");
                    if (slot < 0 || slot >= this.stacks.size()) continue;
                    ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemTags).ifPresent(stack -> this.stacks.set(slot, stack));
                }
                this.onLoad();
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackBlockEntity.this.setDataChanged();
            }

            public FluidTank readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
                this.setCapacity(nbt.contains("Capacity", 3) ? nbt.getInt("Capacity") : TravelersBackpackBlockEntity.this.tier.getTankCapacity());
                FluidStack fluid = FluidStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Fluid"));
                this.setFluid(fluid);
                return this;
            }

            public CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
                if (!nbt.contains("Capacity", 3)) {
                    nbt.putInt("Capacity", TravelersBackpackBlockEntity.this.tier.getTankCapacity());
                }
                if (!this.fluid.isEmpty()) {
                    nbt.put("Fluid", this.fluid.save(lookupProvider));
                }
                return nbt;
            }
        };
    }
}

