/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.dawnoftime.armoroftheages.client.ArmorModelProvider;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;
import org.dawnoftime.armoroftheages.item.HumanoidArmorItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class MixinHumanoidArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public MixinHumanoidArmorLayer(RenderLayerParent<T, M> parentLayer) {
        super(parentLayer);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.armorOfTheAges$renderCustomArmor(poseStack, buffer, livingEntity, EquipmentSlot.HEAD, packedLight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.armorOfTheAges$renderCustomArmor(poseStack, buffer, livingEntity, EquipmentSlot.CHEST, packedLight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.armorOfTheAges$renderCustomArmor(poseStack, buffer, livingEntity, EquipmentSlot.LEGS, packedLight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.armorOfTheAges$renderCustomArmor(poseStack, buffer, livingEntity, EquipmentSlot.FEET, packedLight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Unique
    private void armorOfTheAges$renderCustomArmor(PoseStack stack, MultiBufferSource buffer, T entity, EquipmentSlot slot, int packedLight, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ArmorModelProvider provider;
        HumanoidArmorItem armorItem;
        ItemStack itemStack = entity.getItemBySlot(slot);
        Item item = itemStack.getItem();
        if (item instanceof HumanoidArmorItem && (armorItem = (HumanoidArmorItem)item).getEquipmentSlot() == slot && (provider = armorItem.getModelProvider()) != null) {
            ArmorModel<?> model = provider.getArmorModel((Entity)entity);
            model.copyEntityModelPosition((HumanoidModel)this.getParentModel());
            model.young = entity.isBaby();
            model.crouching = entity.isShiftKeyDown();
            model.riding = ((HumanoidModel)this.getParentModel()).riding;
            model.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)provider.getTexture((Entity)entity)));
            model.renderToBuffer(stack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
            if (itemStack.hasFoil()) {
                model.renderToBuffer(stack, buffer.getBuffer(RenderType.armorEntityGlint()), packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    @Inject(method={"renderArmorPiece"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArmorPiece(PoseStack stack, MultiBufferSource buffer, T entity, EquipmentSlot slot, int packedLight, A defaultModel, CallbackInfo ci) {
        ItemStack itemStack = entity.getItemBySlot(slot);
        if (itemStack.getItem() instanceof HumanoidArmorItem) {
            ci.cancel();
        }
    }
}

