/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.quetzalcoatl_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class HeadQuetzalcoatlArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart featherCrownLeft;
    private final ModelPart featherCrownRight;
    private final ModelPart featherCrownMiddle;

    public HeadQuetzalcoatlArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.featherCrownLeft = this.head.getChild("featherCrownLeft");
        this.featherCrownRight = this.head.getChild("featherCrownRight");
        this.featherCrownMiddle = this.head.getChild("featherCrownMiddle");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new HeadQuetzalcoatlArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = HeadQuetzalcoatlArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 0).addBox(-2.0f, -15.0f, -1.0f, 4.0f, 5.0f, 2.0f, CubeDeformation.NONE).texOffs(52, 0).addBox(-5.0f, -10.0f, -1.0f, 10.0f, 3.0f, 2.0f, CubeDeformation.NONE).texOffs(19, 4).addBox(-6.25f, -7.5f, 0.0f, 3.0f, 3.0f, 0.0f, CubeDeformation.NONE).texOffs(19, 4).mirror().addBox(3.25f, -7.5f, 0.0f, 3.0f, 3.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("featherCrownLeft", CubeListBuilder.create().texOffs(40, 7).mirror().addBox(-1.5f, -9.0f, 0.0f, 6.0f, 6.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)1.3963f));
        head.addOrReplaceChild("featherCrownRight", CubeListBuilder.create().texOffs(40, 7).addBox(-4.5f, -9.0f, 0.0f, 6.0f, 6.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)-1.3963f));
        head.addOrReplaceChild("featherCrownMiddle", CubeListBuilder.create().texOffs(0, 8).addBox(-6.5f, -13.0f, 0.0f, 13.0f, 12.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("smallEarringLeft", CubeListBuilder.create().texOffs(18, 3).mirror().addBox(-1.5f, -2.0f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)4.75f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        head.addOrReplaceChild("smallEarringRight", CubeListBuilder.create().texOffs(18, 3).addBox(-1.5f, -2.0f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-4.75f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        head.addOrReplaceChild("crownLeft", CubeListBuilder.create().texOffs(40, 0).mirror().addBox(-8.0f, -12.0f, -0.75f, 4.0f, 5.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        head.addOrReplaceChild("crownRight", CubeListBuilder.create().texOffs(40, 0).addBox(4.0f, -12.0f, -0.75f, 4.0f, 5.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        head.addOrReplaceChild("skull", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -6.0f, -3.0f, 7.0f, 6.0f, 2.0f, CubeDeformation.NONE).texOffs(18, 0).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-3.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rh;
        this.featherCrownLeft.xRot = rh = -0.4363f + 0.1f * HeadQuetzalcoatlArmorModel.sinPI(ageInTicks / 40.0f);
        this.featherCrownRight.xRot = rh;
        this.featherCrownMiddle.xRot = rh;
    }
}

