/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.iron_plate_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class LegsIronPlateArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart miscB;
    private final ModelPart beltA;
    private final ModelPart beltB;

    public LegsIronPlateArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.miscB = this.body.getChild("miscB");
        this.beltA = this.body.getChild("beltA");
        this.beltB = this.body.getChild("beltB");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new LegsIronPlateArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = LegsIronPlateArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("beltA", CubeListBuilder.create().texOffs(84, 57).addBox(-4.51f, 10.0f, -2.4f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("beltB", CubeListBuilder.create().texOffs(60, 54).addBox(-3.0f, 8.9f, -3.7f, 6.0f, 4.0f, 6.0f, new CubeDeformation(-0.8f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("miscB", CubeListBuilder.create().texOffs(50, 44).addBox(-1.5f, -0.1f, 0.2f, 3.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)12.1f, (float)-3.0f, (float)-0.0456f, (float)0.0f, (float)0.0f));
        PartDefinition armorLeftLeg = root.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        armorLeftLeg.addOrReplaceChild("leftLegging", CubeListBuilder.create().texOffs(32, 36).addBox(-0.3f, -0.2f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1367f));
        PartDefinition armorRightLeg = root.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        armorRightLeg.addOrReplaceChild("rightLegging", CubeListBuilder.create().texOffs(32, 36).mirror(true).addBox(-2.7f, -0.2f, -3.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1367f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Math.abs(this.rightLeg.xRot);
        this.miscB.xRot = -(f + 0.05f * LegsIronPlateArmorModel.sinPI(ageInTicks / 60.0f + 1.0f));
        if (this.riding) {
            this.miscB.xRot -= 1.0f;
        }
        this.beltA.y = 0.0f;
        this.beltB.y = 0.0f;
        this.miscB.y = 12.1f;
    }
}

