/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.iron_plate_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class HeadIronPlateArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart middleFeatherA;
    private final ModelPart middleFeatherB;

    public HeadIronPlateArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.middleFeatherA = this.head.getChild("middleFeatherA");
        this.middleFeatherB = this.middleFeatherA.getChild("middleFeatherB");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new HeadIronPlateArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = HeadIronPlateArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(62, 11).addBox(-4.5f, -8.2f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition earMiddle = head.addOrReplaceChild("earMiddle", CubeListBuilder.create().texOffs(57, 49).addBox(-5.5f, -1.0f, -1.0f, 11.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.4f, (float)-0.3187f, (float)0.0f, (float)0.0f));
        earMiddle.addOrReplaceChild("leftEarBottom", CubeListBuilder.create().texOffs(0, 34).mirror(true).addBox(4.0f, -1.5f, -7.5f, 1.0f, 3.0f, 9.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        earMiddle.addOrReplaceChild("rightEarBottom", CubeListBuilder.create().texOffs(0, 34).addBox(-5.0f, -1.5f, -7.5f, 1.0f, 3.0f, 9.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        earMiddle.addOrReplaceChild("middleBottom", CubeListBuilder.create().texOffs(0, 30).addBox(-4.0f, -7.5f, -1.5f, 8.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("leftHead", CubeListBuilder.create().texOffs(52, 31).addBox(-2.0f, -9.1f, -4.5f, 4.0f, 1.0f, 9.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2731f));
        head.addOrReplaceChild("rightHead", CubeListBuilder.create().texOffs(52, 31).mirror(true).addBox(-2.0f, -9.1f, -4.5f, 4.0f, 1.0f, 9.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2731f));
        head.addOrReplaceChild("middleCraneC", CubeListBuilder.create().texOffs(45, 28).addBox(-1.0f, -10.6f, -2.0f, 2.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4189f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("middleHeadA", CubeListBuilder.create().texOffs(45, 28).addBox(-1.0f, -10.6f, -2.0f, 2.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4189f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("middleHeadB", CubeListBuilder.create().texOffs(44, 19).addBox(-1.0f, -10.5f, -2.5f, 2.0f, 2.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition middleFeatherA = head.addOrReplaceChild("middleFeatherA", CubeListBuilder.create().texOffs(89, -8).addBox(-2.0f, -4.5f, -1.5f, 4.0f, 9.0f, 9.0f, new CubeDeformation(-2.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)5.0f, (float)-0.1905f, (float)0.0f, (float)0.0f));
        middleFeatherA.addOrReplaceChild("middleFeatherB", CubeListBuilder.create().texOffs(89, 2).addBox(-2.0f, -4.5f, -2.0f, 4.0f, 9.0f, 9.0f, new CubeDeformation(-2.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.5f, (float)-0.1188f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("topHead", CubeListBuilder.create().texOffs(28, 5).addBox(-5.0f, -8.2f, -5.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(-0.3f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Math.abs(this.rightLeg.xRot);
        this.middleFeatherA.xRot = -0.15f - f * 0.1f + 0.05f * HeadIronPlateArmorModel.sinPI(ageInTicks / 60.0f + 1.0f);
        this.middleFeatherB.xRot = -0.15f - f * 0.1f + 0.1f * HeadIronPlateArmorModel.sinPI((ageInTicks - 15.0f) / 60.0f + 1.0f);
    }
}

