/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.crockery;

import com.mojang.serialization.MapCodec;
import earth.terrarium.handcrafted.common.blocks.base.SimpleBlock;
import earth.terrarium.handcrafted.common.blocks.crockery.CrockeryBlockEntity;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import earth.terrarium.handcrafted.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CrockeryComboBlock
extends SimpleBlock
implements EntityBlock {
    public static final MapCodec<CrockeryComboBlock> CODEC = CrockeryComboBlock.simpleCodec(CrockeryComboBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public CrockeryComboBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof CrockeryBlockEntity) {
            CrockeryBlockEntity crockery = (CrockeryBlockEntity)blockEntity;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)crockery.getStack());
        }
        super.onRemove(state, level, pos, newState, moved);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrockeryBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tootipComponents, TooltipFlag tooltipFlag) {
        TooltipUtils.addDescriptionComponent(tootipComponents, ConstantComponents.CROCKERY_COMBO);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CrockeryBlockEntity crockery;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrockeryBlockEntity && (crockery = (CrockeryBlockEntity)blockEntity).getStack().isEmpty()) {
            crockery.setStack(stack.copyWithCount(1));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, player.getSoundSource(), 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        CrockeryBlockEntity crockery;
        ItemStack stack;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrockeryBlockEntity && !(stack = (crockery = (CrockeryBlockEntity)blockEntity).getStack()).isEmpty()) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            crockery.setStack(ItemStack.EMPTY);
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, player.getSoundSource(), 1.0f, 1.0f);
        }
        return InteractionResult.CONSUME_PARTIAL;
    }
}

