/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.raijin_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class LegsRaijinArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart chestBeltHangA;
    private final ModelPart chestBeltHangB;

    public LegsRaijinArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.chestBeltHangA = this.body.getChild("chestBeltHangA");
        this.chestBeltHangB = this.body.getChild("chestBeltHangB");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new LegsRaijinArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = LegsRaijinArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.5f, 9.0f, -2.5f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chestBeltJewel", CubeListBuilder.create().texOffs(0, 23).addBox(0.0f, 8.5f, -3.0f, 3.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chestBeltHangA", CubeListBuilder.create().texOffs(14, 23).addBox(0.0f, 0.0f, -0.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)11.2f, (float)-2.5f));
        body.addOrReplaceChild("chestBeltHangB", CubeListBuilder.create().texOffs(8, 23).addBox(0.0f, 0.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(-0.3f)), PartPose.offset((float)1.0f, (float)11.0f, (float)-2.75f));
        PartDefinition chestPant = body.addOrReplaceChild("chestPant", CubeListBuilder.create().texOffs(20, 23).addBox(-4.0f, 11.0f, -2.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        chestPant.addOrReplaceChild("chestPantLeftFront", CubeListBuilder.create().texOffs(23, 18).addBox(0.4f, -2.0f, -0.5f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)2.0f, (float)-0.523599f, (float)0.0f, (float)0.0f));
        chestPant.addOrReplaceChild("chestPantRightFront", CubeListBuilder.create().texOffs(23, 18).addBox(-4.4f, -2.0f, -0.5f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)2.0f, (float)-0.523599f, (float)0.0f, (float)0.0f));
        chestPant.addOrReplaceChild("chestPantLeft", CubeListBuilder.create().texOffs(28, 16).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)9.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.523599f));
        chestPant.addOrReplaceChild("chestPantRight", CubeListBuilder.create().texOffs(28, 16).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)9.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.523599f));
        chestPant.addOrReplaceChild("chestPantLeftBack", CubeListBuilder.create().texOffs(23, 18).addBox(0.4f, -2.0f, -0.5f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.523599f, (float)0.0f, (float)0.0f));
        chestPant.addOrReplaceChild("chestPantRightBack", CubeListBuilder.create().texOffs(23, 18).addBox(-4.4f, -2.0f, -0.5f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.523599f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(24, 7).addBox(-2.0f, 5.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        left_leg.addOrReplaceChild("legLeftPantTop", CubeListBuilder.create().texOffs(35, 7).addBox(-2.5f, -1.0f, -2.5f, 5.0f, 6.0f, 5.0f, CubeDeformation.NONE), PartPose.ZERO);
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(24, 7).addBox(-2.0f, 5.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        right_leg.addOrReplaceChild("legRightPantTop", CubeListBuilder.create().texOffs(35, 7).addBox(-2.5f, -1.0f, -2.5f, 5.0f, 6.0f, 5.0f, CubeDeformation.NONE), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = LegsRaijinArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.5f, 9.0f, -2.5f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chestBeltJewel", CubeListBuilder.create().texOffs(0, 23).addBox(0.0f, 8.5f, -3.0f, 3.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chestBeltHangA", CubeListBuilder.create().texOffs(14, 23).addBox(0.0f, 0.0f, -0.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)11.2f, (float)-2.5f));
        body.addOrReplaceChild("chestBeltHangB", CubeListBuilder.create().texOffs(8, 23).addBox(0.0f, 0.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(-0.3f)), PartPose.offset((float)1.0f, (float)11.0f, (float)-2.75f));
        PartDefinition chestPant = body.addOrReplaceChild("chestPant", CubeListBuilder.create().texOffs(20, 23).addBox(-4.0f, 11.0f, -2.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        chestPant.addOrReplaceChild("chestPantLeftFront", CubeListBuilder.create().texOffs(23, 18).addBox(0.4f, -2.0f, -0.5f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)2.0f, (float)-0.523599f, (float)0.0f, (float)0.0f));
        chestPant.addOrReplaceChild("chestPantRightFront", CubeListBuilder.create().texOffs(23, 18).addBox(-4.4f, -2.0f, -0.5f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)2.0f, (float)-0.523599f, (float)0.0f, (float)0.0f));
        chestPant.addOrReplaceChild("chestPantLeft", CubeListBuilder.create().texOffs(28, 16).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)9.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.523599f));
        chestPant.addOrReplaceChild("chestPantRight", CubeListBuilder.create().texOffs(28, 16).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)9.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.523599f));
        chestPant.addOrReplaceChild("chestPantLeftBack", CubeListBuilder.create().texOffs(23, 18).addBox(0.4f, -2.0f, -0.5f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.523599f, (float)0.0f, (float)0.0f));
        chestPant.addOrReplaceChild("chestPantRightBack", CubeListBuilder.create().texOffs(23, 18).addBox(-4.4f, -2.0f, -0.5f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.523599f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(24, 7).addBox(-2.0f, 3.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        left_leg.addOrReplaceChild("legLeftPantTop", CubeListBuilder.create().texOffs(35, 7).addBox(-2.5f, -1.0f, -2.5f, 5.0f, 4.0f, 5.0f, CubeDeformation.NONE), PartPose.ZERO);
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(24, 7).addBox(-2.0f, 3.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        right_leg.addOrReplaceChild("legRightPantTop", CubeListBuilder.create().texOffs(35, 7).addBox(-2.5f, -1.0f, -2.5f, 5.0f, 4.0f, 5.0f, CubeDeformation.NONE), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = this.leftLeg.xRot;
        if (f > 0.0f) {
            this.chestBeltHangA.xRot = f * 0.5f;
            this.chestBeltHangB.xRot = f * 0.5f;
        } else {
            this.chestBeltHangA.xRot = f;
            this.chestBeltHangA.zRot = f * 0.25f;
            this.chestBeltHangB.xRot = f;
            this.chestBeltHangB.yRot = f * 0.25f;
            this.chestBeltHangB.zRot = f * 0.5f;
        }
        if (this.riding) {
            this.chestBeltHangA.xRot += 3.0f;
            this.chestBeltHangB.xRot += 3.0f;
        }
        this.chestBeltHangA.y = 11.2f;
        this.chestBeltHangB.y = 11.0f;
    }
}

