/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.pharaoh_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class HeadPharaohArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart headTail;

    public HeadPharaohArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.headTail = this.head.getChild("headTail");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new HeadPharaohArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = HeadPharaohArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(20, 19).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("headLeftSideBottom", CubeListBuilder.create().texOffs(0, 57).mirror(true).addBox(-3.0f, -1.0f, -4.0f, 3.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)9.58f, (float)-1.23f, (float)0.91f, (float)0.0f, (float)0.9147271f, (float)-0.2687807f));
        head.addOrReplaceChild("headLeftSideMiddle", CubeListBuilder.create().texOffs(14, 51).mirror(true).addBox(-5.0f, 0.0f, 0.19f, 5.0f, 6.0f, 2.0f, new CubeDeformation(0.14f)), PartPose.offsetAndRotation((float)7.82f, (float)-7.11f, (float)0.86f, (float)0.0f, (float)0.0f, (float)-0.2687807f));
        head.addOrReplaceChild("headRightSideTop", CubeListBuilder.create().texOffs(0, 51).addBox(-5.15f, 0.13f, 0.19f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.13f)), PartPose.offsetAndRotation((float)-4.6f, (float)-11.4f, (float)0.86f, (float)0.0f, (float)0.0f, (float)-0.8901179f));
        head.addOrReplaceChild("headRightSideMiddle", CubeListBuilder.create().texOffs(14, 51).addBox(0.0f, 0.0f, 0.19f, 5.0f, 6.0f, 2.0f, new CubeDeformation(0.14f)), PartPose.offsetAndRotation((float)-7.82f, (float)-7.11f, (float)0.86f, (float)0.0f, (float)0.0f, (float)0.2687807f));
        head.addOrReplaceChild("headRightSideBottom", CubeListBuilder.create().texOffs(0, 57).addBox(0.0f, -1.0f, -4.0f, 3.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-9.58f, (float)-1.23f, (float)0.91f, (float)0.0f, (float)-0.9147271f, (float)0.2687807f));
        head.addOrReplaceChild("headLeftSideTop", CubeListBuilder.create().texOffs(0, 51).mirror(true).addBox(0.15f, 0.13f, 0.19f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.13f)), PartPose.offsetAndRotation((float)4.6f, (float)-11.4f, (float)0.86f, (float)0.0f, (float)0.0f, (float)0.8901179f));
        head.addOrReplaceChild("headTop", CubeListBuilder.create().texOffs(20, 37).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 4.0f, 8.0f, new CubeDeformation(0.09f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.55f, (float)-4.45f, (float)0.47141343f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("headCap", CubeListBuilder.create().texOffs(18, 49).addBox(-4.5f, 0.15f, 0.19f, 9.0f, 0.0f, 2.0f, new CubeDeformation(0.131f)), PartPose.offset((float)0.0f, (float)-11.4f, (float)0.85f));
        head.addOrReplaceChild("headTail", CubeListBuilder.create().texOffs(28, 51).addBox(0.0f, 0.0f, 0.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)-1.5f, (float)0.4f, (float)2.5f));
        head.addOrReplaceChild("snakeBody", CubeListBuilder.create().texOffs(60, 0).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-7.5f, (float)-4.6f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("snakeHead", CubeListBuilder.create().texOffs(47, 19).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.99f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.65f, (float)-4.5f, (float)0.27925268f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headTail.xRot = HeadPharaohArmorModel.sinPI(ageInTicks / 60.0f + 1.0f) * 0.05f - this.head.xRot * 0.8f;
        this.headTail.zRot = (0.3f * HeadPharaohArmorModel.sinPI(ageInTicks / 60.0f + 1.0f) + this.rightLeg.xRot) * 0.1f;
    }
}

