/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.iron_plate_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class ChestIronPlateArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart miscA;

    public ChestIronPlateArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.miscA = this.body.getChild("miscA");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new ChestIronPlateArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = ChestIronPlateArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 4).addBox(-4.5f, -0.1f, -2.5f, 9.0f, 13.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("backLeftBody", CubeListBuilder.create().texOffs(32, 27).addBox(-1.45f, 1.0f, 3.4f, 5.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3187f, (float)0.0f));
        body.addOrReplaceChild("backRightBody", CubeListBuilder.create().texOffs(32, 27).mirror(true).addBox(-3.55f, 1.0f, 3.4f, 5.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3187f, (float)0.0f));
        body.addOrReplaceChild("leftTopBody", CubeListBuilder.create().texOffs(33, 18).addBox(-2.9f, 0.1f, -5.3f, 4.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3643f, (float)-0.4554f, (float)-0.3643f));
        body.addOrReplaceChild("middleTopBody", CubeListBuilder.create().texOffs(54, 57).addBox(0.0f, -7.0f, 0.0f, 3.0f, 7.0f, 0.0f), PartPose.offsetAndRotation((float)-1.5f, (float)9.2f, (float)-2.4f, (float)0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("rightTopBody", CubeListBuilder.create().texOffs(33, 18).mirror(true).addBox(-1.1f, 0.1f, -5.3f, 4.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3643f, (float)0.4554f, (float)0.3643f));
        body.addOrReplaceChild("miscA", CubeListBuilder.create().texOffs(85, 35).addBox(-3.5f, 0.2f, 0.0f, 7.0f, 12.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.6f, (float)3.3f, (float)0.0456f, (float)0.0f, (float)0.0f));
        PartDefinition leftHand = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(112, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftShoulderA = leftHand.addOrReplaceChild("leftShoulderA", CubeListBuilder.create().texOffs(0, 54).addBox(-1.4f, -3.2f, -2.5f, 6.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        leftShoulderA.addOrReplaceChild("leftShoulderB", CubeListBuilder.create().texOffs(0, 46).addBox(-0.4f, -1.3f, -2.5f, 6.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        leftShoulderA.addOrReplaceChild("leftShoulderC", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, -1.3f, -3.0f, 2.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1396f));
        PartDefinition rightHand = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(112, 48).mirror(true).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightShoulderA = rightHand.addOrReplaceChild("rightShoulderA", CubeListBuilder.create().texOffs(0, 54).mirror(true).addBox(-5.0f, -3.2f, -2.5f, 6.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        rightShoulderA.addOrReplaceChild("rightShoulderB", CubeListBuilder.create().texOffs(0, 46).mirror(true).addBox(-5.8f, -1.4f, -2.5f, 6.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        rightShoulderA.addOrReplaceChild("rightShoulderC", CubeListBuilder.create().texOffs(0, 22).mirror(true).addBox(-1.5f, -1.3f, -3.0f, 2.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1396f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = ChestIronPlateArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 4).addBox(-4.5f, -0.1f, -2.5f, 9.0f, 13.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("backLeftBody", CubeListBuilder.create().texOffs(32, 27).addBox(-1.45f, 1.0f, 3.4f, 5.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3187f, (float)0.0f));
        body.addOrReplaceChild("backRightBody", CubeListBuilder.create().texOffs(32, 27).mirror(true).addBox(-3.55f, 1.0f, 3.4f, 5.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3187f, (float)0.0f));
        body.addOrReplaceChild("leftTopBody", CubeListBuilder.create().texOffs(33, 18).addBox(-2.9f, 0.1f, -5.3f, 4.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3643f, (float)-0.4554f, (float)-0.3643f));
        body.addOrReplaceChild("middleTopBody", CubeListBuilder.create().texOffs(54, 57).addBox(0.0f, -7.0f, 0.0f, 3.0f, 7.0f, 0.0f), PartPose.offsetAndRotation((float)-1.5f, (float)9.2f, (float)-2.4f, (float)0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("rightTopBody", CubeListBuilder.create().texOffs(33, 18).mirror(true).addBox(-1.1f, 0.1f, -5.3f, 4.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3643f, (float)0.4554f, (float)0.3643f));
        body.addOrReplaceChild("miscA", CubeListBuilder.create().texOffs(85, 35).addBox(-3.5f, 0.2f, 0.0f, 7.0f, 12.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.6f, (float)3.3f, (float)0.0456f, (float)0.0f, (float)0.0f));
        PartDefinition leftHand = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(112, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        PartDefinition leftShoulderA = leftHand.addOrReplaceChild("leftShoulderA", CubeListBuilder.create().texOffs(0, 54).addBox(-1.4f, -3.2f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        leftShoulderA.addOrReplaceChild("leftShoulderB", CubeListBuilder.create().texOffs(0, 46).addBox(-0.4f, -1.3f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        leftShoulderA.addOrReplaceChild("leftShoulderC", CubeListBuilder.create().texOffs(0, 22).addBox(-0.5f, -1.3f, -3.0f, 2.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1396f));
        PartDefinition rightHand = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(112, 48).mirror(true).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        PartDefinition rightShoulderA = rightHand.addOrReplaceChild("rightShoulderA", CubeListBuilder.create().texOffs(0, 54).mirror(true).addBox(-4.0f, -3.2f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        rightShoulderA.addOrReplaceChild("rightShoulderB", CubeListBuilder.create().texOffs(0, 46).mirror(true).addBox(-4.8f, -1.4f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        rightShoulderA.addOrReplaceChild("rightShoulderC", CubeListBuilder.create().texOffs(0, 22).mirror(true).addBox(-1.5f, -1.3f, -3.0f, 2.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1396f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Math.abs(this.rightLeg.xRot);
        this.miscA.xRot = 0.05f + 0.05f * ChestIronPlateArmorModel.sinPI(ageInTicks / 60.0f + 1.0f);
        if (this.riding) {
            this.miscA.xRot += 1.0f;
        }
        this.miscA.xRot = this.crouching ? (this.miscA.xRot -= 0.18f) : (this.miscA.xRot += f);
    }
}

