/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.holy_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class ChestHolyArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart chestEffectFrontA;
    private final ModelPart chestEffectFrontB;
    private final ModelPart chestEffectBig;
    private final ModelPart chestEffectMiddle;
    private final ModelPart chestEffectMiddleRotated;
    private final ModelPart chestEffectSmall;
    private final ModelPart chestEffectSmallRotated;
    private final ModelPart armLeftEffect;
    private final ModelPart armLeftEffectRotated;
    private final ModelPart armLeftWing;
    private final ModelPart armRightEffect;
    private final ModelPart armRightEffectRotated;
    private final ModelPart armRightWing;

    public ChestHolyArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        ModelPart chestCore = this.body.getChild("chestCore");
        this.chestEffectFrontA = chestCore.getChild("chestEffectFrontA");
        this.chestEffectFrontB = chestCore.getChild("chestEffectFrontB");
        this.chestEffectBig = this.body.getChild("chestEffectBig");
        this.chestEffectMiddle = this.body.getChild("chestEffectMiddle");
        this.chestEffectMiddleRotated = this.body.getChild("chestEffectMiddleRotated");
        this.chestEffectSmall = this.body.getChild("chestEffectSmall");
        this.chestEffectSmallRotated = this.body.getChild("chestEffectSmallRotated");
        this.armLeftEffect = this.leftArm.getChild("armLeftEffect");
        this.armLeftEffectRotated = this.leftArm.getChild("armLeftEffectRotated");
        this.armLeftWing = this.leftArm.getChild("armLeftElbow").getChild("armLeftWing");
        this.armRightEffect = this.rightArm.getChild("armRightEffect");
        this.armRightEffectRotated = this.rightArm.getChild("armRightEffectRotated");
        this.armRightWing = this.rightArm.getChild("armRightElbow").getChild("armRightWing");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new ChestHolyArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = ChestHolyArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 28).addBox(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.ZERO);
        PartDefinition chestEffectBig = body.addOrReplaceChild("chestEffectBig", CubeListBuilder.create().texOffs(66, 0).addBox(-15.5f, -15.5f, 0.0f, 31.0f, 31.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)7.0f));
        chestEffectBig.addOrReplaceChild("chestEffectBigRotated", CubeListBuilder.create().texOffs(90, 31).addBox(-9.5f, -9.5f, 0.0f, 19.0f, 19.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body.addOrReplaceChild("chestEffectMiddle", CubeListBuilder.create().texOffs(0, 63).addBox(-8.5f, -8.5f, 0.01f, 17.0f, 17.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)8.0f));
        body.addOrReplaceChild("chestEffectMiddleRotated", CubeListBuilder.create().texOffs(0, 80).addBox(-6.5f, -6.5f, 0.0f, 13.0f, 13.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)8.0f));
        body.addOrReplaceChild("chestEffectSmall", CubeListBuilder.create().texOffs(83, 50).addBox(-4.5f, -4.5f, 0.0f, 9.0f, 9.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)9.0f));
        body.addOrReplaceChild("chestEffectSmallRotated", CubeListBuilder.create().texOffs(101, 50).addBox(-4.5f, -4.5f, 0.01f, 9.0f, 9.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)9.0f));
        body.addOrReplaceChild("chestBack", CubeListBuilder.create().texOffs(0, 46).addBox(-3.5f, -6.5f, -1.7f, 7.0f, 12.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.2f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chestPecRight", CubeListBuilder.create().texOffs(37, 45).mirror().addBox(-4.0f, -5.0f, -2.9f, 4.0f, 5.0f, 4.0f), PartPose.offsetAndRotation((float)0.5f, (float)4.0f, (float)-0.5f, (float)-0.2007f, (float)0.0f, (float)-0.2618f));
        body.addOrReplaceChild("chestPecLeft", CubeListBuilder.create().texOffs(37, 45).addBox(0.0f, -5.0f, -2.9f, 4.0f, 5.0f, 4.0f), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)-0.5f, (float)-0.2007f, (float)0.0f, (float)0.2618f));
        PartDefinition chestCore = body.addOrReplaceChild("chestCore", CubeListBuilder.create().texOffs(0, 19).addBox(-1.0f, -3.5f, 0.0f, 2.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)-3.6f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        chestCore.addOrReplaceChild("chestEffectFrontA", CubeListBuilder.create().texOffs(34, 70).addBox(-2.5f, -2.5f, 0.01f, 5.0f, 5.0f, 0.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.3f));
        chestCore.addOrReplaceChild("chestEffectFrontB", CubeListBuilder.create().texOffs(34, 75).addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.3f));
        body.addOrReplaceChild("abs", CubeListBuilder.create().texOffs(18, 48).addBox(-3.5f, -1.0f, 0.3f, 7.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.7f, (float)-3.3f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition armRight = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(46, 28).mirror().addBox(-3.5f, -2.0f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(-0.19f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        armRight.addOrReplaceChild("armRightShoulderA", CubeListBuilder.create().texOffs(25, 21).mirror().addBox(-4.0f, -3.5f, -3.5f, 6.0f, 5.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        armRight.addOrReplaceChild("armRightShoulderB", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(-6.2f, -2.0f, -4.0f, 8.0f, 1.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition armRightElbow = armRight.addOrReplaceChild("armRightElbow", CubeListBuilder.create().texOffs(44, 20).mirror().addBox(-3.5f, 3.3f, -3.0f, 5.0f, 2.0f, 6.0f), PartPose.ZERO);
        armRightElbow.addOrReplaceChild("armRightElbowDetail", CubeListBuilder.create().texOffs(0, 6).mirror().addBox(-4.0f, 3.8f, -1.1f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        armRightElbow.addOrReplaceChild("armRightWing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-0.099f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)-3.401f, (float)4.3f, (float)-1.6f, (float)0.1745f, (float)-0.3054f, (float)0.0f));
        armRight.addOrReplaceChild("armRightGlove", CubeListBuilder.create().texOffs(47, 48).mirror().addBox(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-1.0f, (float)9.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        armRight.addOrReplaceChild("armRightEffect", CubeListBuilder.create().texOffs(34, 56).mirror().addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0f));
        armRight.addOrReplaceChild("armRightEffectRotated", CubeListBuilder.create().texOffs(34, 56).mirror().addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-3.0f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)-1.0f));
        PartDefinition armLeft = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(46, 28).addBox(-1.5f, -2.0f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(-0.19f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        armLeft.addOrReplaceChild("armLeftShoulderA", CubeListBuilder.create().texOffs(25, 21).addBox(-2.0f, -3.5f, -3.5f, 6.0f, 5.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        armLeft.addOrReplaceChild("armLeftShoulderB", CubeListBuilder.create().texOffs(0, 19).addBox(-1.8f, -2.0f, -4.0f, 8.0f, 1.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition armLeftElbow = armLeft.addOrReplaceChild("armLeftElbow", CubeListBuilder.create().texOffs(44, 20).addBox(-1.5f, 3.3f, -3.0f, 5.0f, 2.0f, 6.0f), PartPose.ZERO);
        armLeftElbow.addOrReplaceChild("armLeftElbowDetail", CubeListBuilder.create().texOffs(0, 6).addBox(3.0f, 3.8f, -1.1f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        armLeftElbow.addOrReplaceChild("armLeftWing", CubeListBuilder.create().texOffs(0, 0).addBox(0.099f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)3.401f, (float)4.3f, (float)-1.6f, (float)0.1745f, (float)0.3054f, (float)0.0f));
        armLeft.addOrReplaceChild("armLeftGlove", CubeListBuilder.create().texOffs(47, 48).addBox(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)1.0f, (float)9.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        armLeft.addOrReplaceChild("armLeftEffect", CubeListBuilder.create().texOffs(34, 56).addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        armLeft.addOrReplaceChild("armLeftEffectRotated", CubeListBuilder.create().texOffs(34, 56).addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)3.0f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = ChestHolyArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 28).addBox(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chestEffectBig = body.addOrReplaceChild("chestEffectBig", CubeListBuilder.create().texOffs(66, 0).addBox(-15.5f, -15.5f, 0.0f, 31.0f, 31.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)7.0f));
        chestEffectBig.addOrReplaceChild("chestEffectBigRotated", CubeListBuilder.create().texOffs(90, 31).addBox(-9.5f, -9.5f, 0.0f, 19.0f, 19.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body.addOrReplaceChild("chestEffectMiddle", CubeListBuilder.create().texOffs(0, 63).addBox(-8.5f, -8.5f, 0.01f, 17.0f, 17.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)8.0f));
        body.addOrReplaceChild("chestEffectMiddleRotated", CubeListBuilder.create().texOffs(0, 80).addBox(-6.5f, -6.5f, 0.0f, 13.0f, 13.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)8.0f));
        body.addOrReplaceChild("chestEffectSmall", CubeListBuilder.create().texOffs(83, 50).addBox(-4.5f, -4.5f, 0.0f, 9.0f, 9.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)9.0f));
        body.addOrReplaceChild("chestEffectSmallRotated", CubeListBuilder.create().texOffs(101, 50).addBox(-4.5f, -4.5f, 0.01f, 9.0f, 9.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)9.0f));
        body.addOrReplaceChild("chestBack", CubeListBuilder.create().texOffs(0, 46).addBox(-3.5f, -6.5f, -1.7f, 7.0f, 12.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.2f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chestPecRight", CubeListBuilder.create().texOffs(37, 45).mirror().addBox(-4.0f, -4.0f, -3.5f, 4.0f, 5.0f, 4.0f), PartPose.offsetAndRotation((float)0.5f, (float)4.0f, (float)-0.5f, (float)-0.3752f, (float)0.0f, (float)-0.1745f));
        body.addOrReplaceChild("chestPecLeft", CubeListBuilder.create().texOffs(37, 45).addBox(0.0f, -4.0f, -3.5f, 4.0f, 5.0f, 4.0f), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)-0.5f, (float)-0.3752f, (float)0.0f, (float)0.1745f));
        PartDefinition chestCore = body.addOrReplaceChild("chestCore", CubeListBuilder.create().texOffs(0, 19).addBox(-1.0f, -3.5f, -0.7f, 2.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)-3.6f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        chestCore.addOrReplaceChild("chestEffectFrontA", CubeListBuilder.create().texOffs(34, 70).addBox(-2.5f, -2.5f, 0.01f, 5.0f, 5.0f, 0.0f), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.3f));
        chestCore.addOrReplaceChild("chestEffectFrontB", CubeListBuilder.create().texOffs(34, 75).addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.3f));
        body.addOrReplaceChild("abs", CubeListBuilder.create().texOffs(18, 48).addBox(-3.5f, -1.0f, 0.8f, 7.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)4.7f, (float)-3.3f));
        PartDefinition armRight = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(46, 28).mirror().addBox(-2.5f, -2.0f, -2.5f, 4.0f, 12.0f, 5.0f, new CubeDeformation(-0.19f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        armRight.addOrReplaceChild("armRightShoulderA", CubeListBuilder.create().texOffs(25, 21).mirror().addBox(-3.0f, -3.5f, -3.5f, 5.0f, 5.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        armRight.addOrReplaceChild("armRightShoulderB", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(-5.2f, -2.0f, -4.0f, 7.0f, 1.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition armRightElbow = armRight.addOrReplaceChild("armRightElbow", CubeListBuilder.create().texOffs(44, 20).mirror().addBox(-2.5f, 3.3f, -3.0f, 4.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        armRightElbow.addOrReplaceChild("armRightElbowDetail", CubeListBuilder.create().texOffs(0, 6).mirror().addBox(-3.0f, 3.8f, -1.1f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        armRightElbow.addOrReplaceChild("armRightWing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.901f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)-3.401f, (float)4.3f, (float)-1.6f, (float)0.1745f, (float)-0.3054f, (float)0.0f));
        armRight.addOrReplaceChild("armRightGlove", CubeListBuilder.create().texOffs(47, 48).mirror().addBox(-1.5f, -1.5f, 0.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-1.0f, (float)9.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        armRight.addOrReplaceChild("armRightEffect", CubeListBuilder.create().texOffs(34, 56).mirror().addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0f));
        armRight.addOrReplaceChild("armRightEffectRotated", CubeListBuilder.create().texOffs(34, 56).mirror().addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-3.0f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)-1.0f));
        PartDefinition armLeft = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(46, 28).addBox(-1.5f, -2.0f, -2.5f, 4.0f, 12.0f, 5.0f, new CubeDeformation(-0.19f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        armLeft.addOrReplaceChild("armLeftShoulderA", CubeListBuilder.create().texOffs(25, 21).addBox(-2.0f, -3.5f, -3.5f, 5.0f, 5.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        armLeft.addOrReplaceChild("armLeftShoulderB", CubeListBuilder.create().texOffs(0, 19).addBox(-1.8f, -2.0f, -4.0f, 7.0f, 1.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition armLeftElbow = armLeft.addOrReplaceChild("armLeftElbow", CubeListBuilder.create().texOffs(44, 20).addBox(-1.5f, 3.3f, -3.0f, 4.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        armLeftElbow.addOrReplaceChild("armLeftElbowDetail", CubeListBuilder.create().texOffs(0, 6).addBox(2.0f, 3.8f, -1.1f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        armLeftElbow.addOrReplaceChild("armLeftWing", CubeListBuilder.create().texOffs(0, 0).addBox(-0.901f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)3.401f, (float)4.3f, (float)-1.6f, (float)0.1745f, (float)0.3054f, (float)0.0f));
        armLeft.addOrReplaceChild("armLeftGlove", CubeListBuilder.create().texOffs(47, 48).addBox(-2.5f, -1.5f, 0.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)1.0f, (float)9.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        armLeft.addOrReplaceChild("armLeftEffect", CubeListBuilder.create().texOffs(34, 56).addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        armLeft.addOrReplaceChild("armLeftEffectRotated", CubeListBuilder.create().texOffs(34, 56).addBox(0.0f, -3.5f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)3.0f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float dA = ageInTicks / 40.0f;
        float rotation = dA % ((float)Math.PI * 2);
        float rotationD = (dA + 0.7853982f) % ((float)Math.PI * 2);
        this.chestEffectFrontA.zRot = rotation;
        this.chestEffectFrontB.zRot = rotationD;
        this.chestEffectMiddle.zRot = rotation;
        this.chestEffectMiddleRotated.zRot = rotationD;
        this.armLeftEffect.xRot = -rotation;
        this.armLeftEffectRotated.xRot = -rotationD;
        this.armRightEffect.xRot = -rotation;
        this.armRightEffectRotated.xRot = -rotationD;
        dA = 0.1f * ChestHolyArmorModel.sinPI(dA);
        this.armLeftWing.xRot = 0.1745f + dA;
        this.armRightWing.xRot = 0.1745f + dA;
        this.chestEffectBig.y = dA = 0.06f * ChestHolyArmorModel.sinPI(ageInTicks / 80.0f);
        this.chestEffectMiddle.y = dA;
        this.chestEffectMiddleRotated.y = dA;
        this.chestEffectSmall.y = dA;
        this.chestEffectSmallRotated.y = dA;
        dA = ageInTicks / 20.0f;
        rotation = dA % ((float)Math.PI * 2);
        rotationD = (dA + 0.7853982f) % ((float)Math.PI * 2);
        this.chestEffectSmall.zRot = -rotation;
        this.chestEffectSmallRotated.zRot = -rotationD;
    }
}

