/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.anubis_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class HeadAnubisArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart ribbonLeft;
    private final ModelPart ribbonRight;
    private final ModelPart earLeft;
    private final ModelPart earRight;

    public HeadAnubisArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.ribbonLeft = this.head.getChild("ribbonLeft");
        this.ribbonRight = this.head.getChild("ribbonRight");
        this.earLeft = this.head.getChild("earLeft");
        this.earRight = this.head.getChild("earRight");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new HeadAnubisArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = HeadAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(96, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(34, 0).addBox(-4.5f, -10.25f, -4.5f, 9.0f, 12.0f, 9.0f, new CubeDeformation(0.05f)).texOffs(0, 0).addBox(-4.0f, -10.0f, -6.0f, 8.0f, 7.0f, 9.0f, CubeDeformation.NONE), PartPose.ZERO);
        head.addOrReplaceChild("ribbonLeft", CubeListBuilder.create().texOffs(10, 16).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.75f, (float)-8.0f, (float)-4.386f, (float)0.0f, (float)-0.9599f, (float)0.0f));
        head.addOrReplaceChild("ribbonLeftNode", CubeListBuilder.create().texOffs(0, 5).addBox(0.1f, -2.1f, -0.032f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)2.7151f, (float)-6.9f, (float)-4.168f, (float)0.0f, (float)0.6109f, (float)0.0f));
        head.addOrReplaceChild("ribbonRight", CubeListBuilder.create().mirror().texOffs(10, 16).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.75f, (float)-8.0f, (float)-4.386f, (float)0.0f, (float)0.9599f, (float)0.0f));
        head.addOrReplaceChild("ribbonRightNode", CubeListBuilder.create().mirror().texOffs(0, 5).addBox(-2.1f, -2.1f, -0.032f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)-2.7151f, (float)-6.9f, (float)-4.168f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        head.addOrReplaceChild("nose_r1", CubeListBuilder.create().texOffs(25, 0).addBox(-3.0f, 0.0f, -5.0f, 4.0f, 4.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)-7.0f, (float)-6.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("headLayerRight_r1", CubeListBuilder.create().mirror().texOffs(98, 0).addBox(0.05f, 0.05f, 0.04f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)-4.55f, (float)-10.3f, (float)-0.55f, (float)0.0f, (float)0.0f, (float)0.2618f));
        head.addOrReplaceChild("headLayerLeft_r1", CubeListBuilder.create().texOffs(98, 0).addBox(-3.05f, 0.05f, 0.04f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)4.55f, (float)-10.3f, (float)-0.55f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        head.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(0, 0).addBox(-0.7342f, -5.0323f, -1.0764f, 2.0f, 4.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 16).addBox(-3.2342f, -10.5323f, -0.5764f, 5.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)-7.0f, (float)-0.5f, (float)0.1249f, (float)0.2577f, (float)-0.0465f));
        head.addOrReplaceChild("earLeft", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-1.2658f, -5.0323f, -1.0764f, 2.0f, 4.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 16).addBox(-1.7658f, -10.5323f, -0.5764f, 5.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)-7.0f, (float)-0.5f, (float)0.1249f, (float)-0.2577f, (float)0.0465f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = HeadAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(96, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(34, 0).addBox(-4.5f, -10.25f, -4.5f, 9.0f, 12.0f, 9.0f, new CubeDeformation(0.05f)).texOffs(0, 0).addBox(-4.0f, -10.0f, -6.0f, 8.0f, 7.0f, 9.0f, CubeDeformation.NONE), PartPose.ZERO);
        head.addOrReplaceChild("ribbonLeft", CubeListBuilder.create().texOffs(10, 16).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.75f, (float)-8.0f, (float)-4.386f, (float)0.0f, (float)-0.9599f, (float)0.0f));
        head.addOrReplaceChild("ribbonLeftNode", CubeListBuilder.create().texOffs(0, 5).addBox(0.1f, -2.1f, -0.032f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)2.7151f, (float)-6.9f, (float)-4.168f, (float)0.0f, (float)0.6109f, (float)0.0f));
        head.addOrReplaceChild("ribbonRight", CubeListBuilder.create().mirror().texOffs(10, 16).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.75f, (float)-8.0f, (float)-4.386f, (float)0.0f, (float)0.9599f, (float)0.0f));
        head.addOrReplaceChild("ribbonRightNode", CubeListBuilder.create().mirror().texOffs(0, 5).addBox(-2.1f, -2.1f, -0.032f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)-2.7151f, (float)-6.9f, (float)-4.168f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        head.addOrReplaceChild("nose_r1", CubeListBuilder.create().texOffs(25, 0).addBox(-3.0f, 0.0f, -5.0f, 4.0f, 4.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)-7.0f, (float)-6.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("headLayerRight_r1", CubeListBuilder.create().mirror().texOffs(98, 0).addBox(0.05f, 0.05f, 0.04f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)-4.55f, (float)-10.3f, (float)-0.55f, (float)0.0f, (float)0.0f, (float)0.2618f));
        head.addOrReplaceChild("headLayerLeft_r1", CubeListBuilder.create().texOffs(98, 0).addBox(-3.05f, 0.05f, 0.04f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)4.55f, (float)-10.3f, (float)-0.55f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        head.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(0, 0).addBox(-0.7342f, -5.0323f, -1.0764f, 2.0f, 4.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 16).addBox(-3.2342f, -10.5323f, -0.5764f, 5.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)-7.0f, (float)-0.5f, (float)0.1681f, (float)0.2322f, (float)0.1315f));
        head.addOrReplaceChild("earLeft", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-1.2658f, -5.0323f, -1.0764f, 2.0f, 4.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 16).addBox(-1.7658f, -10.5323f, -0.5764f, 5.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)-7.0f, (float)-0.5f, (float)0.1681f, (float)-0.2322f, (float)-0.1315f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rh = 0.1f * HeadAnubisArmorModel.sinPI(ageInTicks / 35.0f);
        if (this.isSlim) {
            this.earRight.setRotation(0.1249f + rh, 0.2577f, -0.0465f);
            this.earLeft.setRotation(0.1249f + rh, -0.2577f, 0.0465f);
        } else {
            this.earRight.setRotation(0.1681f + rh, 0.2322f, 0.1315f);
            this.earLeft.setRotation(0.1681f + rh, -0.2322f, -0.1315f);
        }
        this.ribbonRight.zRot = rh = 0.05f * HeadAnubisArmorModel.sinPI((ageInTicks - 15.0f) / 50.0f);
        this.ribbonLeft.zRot = -rh;
    }
}

