/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AotAArmorMaterialRegistry {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((Registry)BuiltInRegistries.ARMOR_MATERIAL, (String)"armoroftheages");
    public static final Holder<ArmorMaterial> IRON_PLATE = AotAArmorMaterialRegistry.createArmorMaterial("iron_plate", 3, 9, 7, 3, 9, 6, 0.0f, 0.05f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK.asItem()}));
    public static final Holder<ArmorMaterial> HOLY = AotAArmorMaterialRegistry.createArmorMaterial("holy", 4, 10, 8, 4, 8, 4, 0.0f, 0.0f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GOLD_BLOCK.asItem()}));
    public static final Holder<ArmorMaterial> JAPANESE_LIGHT = AotAArmorMaterialRegistry.createArmorMaterial("japanese_light", 2, 7, 6, 2, 7, 10, 0.0f, -0.03f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER}));
    public static final Holder<ArmorMaterial> O_YOROI = AotAArmorMaterialRegistry.createArmorMaterial("o_yoroi", 3, 8, 6, 3, 6, 16, 2.0f, 0.0f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE_BLOCK.asItem()}));
    public static final Holder<ArmorMaterial> RAIJIN = AotAArmorMaterialRegistry.createArmorMaterial("raijin", 3, 9, 7, 3, 7, 26, 2.0f, 0.0f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GOLD_BLOCK.asItem()}));
    public static final Holder<ArmorMaterial> PHARAOH = AotAArmorMaterialRegistry.createArmorMaterial("pharaoh", 3, 8, 6, 3, 6, 37, 2.0f, 0.0f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK.asItem()}));
    public static final Holder<ArmorMaterial> ANUBIS = AotAArmorMaterialRegistry.createArmorMaterial("anubis", 3, 8, 6, 3, 6, 52, 3.0f, 0.2f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Blocks.LAPIS_BLOCK.asItem()}));
    public static final Holder<ArmorMaterial> CENTURION = AotAArmorMaterialRegistry.createArmorMaterial("centurion", 3, 7, 5, 3, 5, 10, 3.0f, 0.025f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, () -> Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GOLD_BLOCK.asItem()}));
    public static final Holder<ArmorMaterial> QUETZALCOATL = AotAArmorMaterialRegistry.createArmorMaterial("quetzalcoatl", 3, 8, 6, 3, 6, 20, 5.0f, 0.04f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_TURTLE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER}));

    private static Holder<ArmorMaterial> createArmorMaterial(String name, int helmetDef, int chestDef, int legsDef, int feetDef, int globalDef, int enchantability, float toughness, float knockbackRes, Holder<SoundEvent> sound, Supplier<Ingredient> repairSupplier) {
        return ARMOR_MATERIALS.register(name, () -> new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, feetDef);
            map.put(ArmorItem.Type.LEGGINGS, legsDef);
            map.put(ArmorItem.Type.CHESTPLATE, chestDef);
            map.put(ArmorItem.Type.HELMET, helmetDef);
            map.put(ArmorItem.Type.BODY, globalDef);
        }), enchantability, sound, repairSupplier, new ArrayList(), toughness, knockbackRes));
    }
}

