/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class BlackwoodTreeFeature
extends Feature<RuTreeConfiguration> {
    public BlackwoodTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = context.random().nextInt(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.move(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (placeCheck > 1) {
                this.placeBranchDecorator((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeTop((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.move(Direction.UP);
        }
        return true;
    }

    public void placeTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(pos.getX(), pos.getY() - 6, pos.getZ());
        this.placeLeavesBlobTop(level, pos, randomSource, treeConfiguration);
        this.placeBranchesShort(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.move(Direction.DOWN);
        placePos.move(Direction.DOWN);
        placePos.move(Direction.DOWN);
        this.placeBranchesLong(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.move(Direction.DOWN);
        placePos.move(Direction.DOWN);
        placePos.move(Direction.DOWN);
        this.placeBranchesXLong(level, (BlockPos)placePos, randomSource, treeConfiguration);
        placePos.move(Direction.DOWN);
        placePos.move(Direction.DOWN);
        placePos.move(Direction.DOWN);
        if (randomSource.nextInt(3) == 0) {
            this.placeBranchesXLong(level, (BlockPos)placePos, randomSource, treeConfiguration);
        }
    }

    public void placeBranchesShort(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        int type = randomSource.nextInt(2);
        this.placeLog(level, pos.north(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLeavesBlobNorth(level, pos.north(), randomSource, treeConfiguration);
        this.placeLog(level, pos.south(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLeavesBlobSouth(level, pos.south(), randomSource, treeConfiguration);
        this.placeLog(level, pos.east(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlobEast(level, pos.east(), randomSource, treeConfiguration);
        this.placeLog(level, pos.west(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlobWest(level, pos.west(), randomSource, treeConfiguration);
    }

    public void placeBranchesLong(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        int type = randomSource.nextInt(2);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().west(), randomSource, treeConfiguration);
        this.placeLog(level, pos.north(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos.north(2), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLeavesBlobNorth(level, pos.north(2), randomSource, treeConfiguration);
        this.placeLog(level, pos.south(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos.south(2), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLeavesBlobSouth(level, pos.south(2), randomSource, treeConfiguration);
        this.placeLog(level, pos.east(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos.east(2), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlobEast(level, pos.east(2), randomSource, treeConfiguration);
        this.placeLog(level, pos.west(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos.west(2), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlobWest(level, pos.west(2), randomSource, treeConfiguration);
    }

    public void placeBranchesXLong(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        int type = randomSource.nextInt(2);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().west(), randomSource, treeConfiguration);
        this.placeLog(level, pos.below().north(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos.north(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos.north(2), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos.north(3), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLeavesBlobNorth(level, pos.north(3), randomSource, treeConfiguration);
        this.placeLog(level, pos.below().south(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos.south(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos.south(2), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos.south(3), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLeavesBlobSouth(level, pos.south(3), randomSource, treeConfiguration);
        this.placeLog(level, pos.below().east(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos.east(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos.east(2), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos.east(3), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlobEast(level, pos.east(3), randomSource, treeConfiguration);
        this.placeLog(level, pos.below().west(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos.west(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos.west(2), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos.west(3), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlobWest(level, pos.west(3), randomSource, treeConfiguration);
    }

    public boolean placeLeavesBlobTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        BlockPos pos2 = pos.below(3);
        int top = random.nextInt(2);
        if (top == 0) {
            this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.above(2), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below(2).north(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below(2).south(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below(2).east(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below(2).west(), randomSource, treeConfiguration);
        } else {
            this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.above().north(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.above().south(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.above().east(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.above().west(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.above(2), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.above(3), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below().north(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below().south(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below().east(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below().west(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below(2).north(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below(2).south(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below(2).east(), randomSource, treeConfiguration);
            this.placeLeavesBlock(level, pos.below(2).west(), randomSource, treeConfiguration);
        }
        this.placeLeavesBlock(level, pos2, randomSource, treeConfiguration);
        this.placeLog(level, pos2.north(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos2.south(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, pos2.east(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, pos2.west(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlock(level, pos2.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.north(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.north(2).east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.north(2).west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.south(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.south(2).east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.south(2).west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.east(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.east(2).north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.east(2).south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.west(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.west(2).north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos2.west(2).south(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesBlobNorth(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int n = random.nextInt(3);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(2).east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(2).west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().west(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesBlobSouth(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int n = random.nextInt(3);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(2).east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(2).west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().west(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesBlobEast(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int n = random.nextInt(3);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().north(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().south(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(2).north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(2).south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east().south(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesBlobWest(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int n = random.nextInt(3);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().north(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().south(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(2).north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(2).south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west().south(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (BlackwoodTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis), 2);
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public void placeBranchDecorator(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (randomSource.nextInt(10) == 0) {
            int rd = random.nextInt(4);
            if (rd == 0) {
                this.placeNorthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 1) {
                this.placeSouthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 2) {
                this.placeEastBranch(level, pos, randomSource, treeConfiguration);
            } else {
                this.placeWestBranch(level, pos, randomSource, treeConfiguration);
            }
        }
    }

    public void placeNorthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.getBlockState(pos.north()).canBeReplaced() && !level.isOutsideBuildHeight(pos.north())) {
            level.setBlock(pos.north(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
        if (level.getBlockState(pos.north().above()).canBeReplaced() && !level.isOutsideBuildHeight(pos.north().above())) {
            level.setBlock(pos.north().above(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.north().north()).canBeReplaced() && !level.isOutsideBuildHeight(pos.north().north())) {
            level.setBlock(pos.north().north(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.north().east()).canBeReplaced() && !level.isOutsideBuildHeight(pos.north().east())) {
            level.setBlock(pos.north().east(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.north().west()).canBeReplaced() && !level.isOutsideBuildHeight(pos.north().west())) {
            level.setBlock(pos.north().west(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeSouthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.getBlockState(pos.south()).canBeReplaced() && !level.isOutsideBuildHeight(pos.south())) {
            level.setBlock(pos.south(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
        }
        if (level.getBlockState(pos.south().above()).canBeReplaced() && !level.isOutsideBuildHeight(pos.south().above())) {
            level.setBlock(pos.south().above(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.south().south()).canBeReplaced() && !level.isOutsideBuildHeight(pos.south().south())) {
            level.setBlock(pos.south().south(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.south().east()).canBeReplaced() && !level.isOutsideBuildHeight(pos.south().east())) {
            level.setBlock(pos.south().east(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.south().west()).canBeReplaced() && !level.isOutsideBuildHeight(pos.south().west())) {
            level.setBlock(pos.south().west(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeEastBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.getBlockState(pos.east()).canBeReplaced() && !level.isOutsideBuildHeight(pos.east())) {
            level.setBlock(pos.east(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
        }
        if (level.getBlockState(pos.east().above()).canBeReplaced() && !level.isOutsideBuildHeight(pos.east().above())) {
            level.setBlock(pos.east().above(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.east().east()).canBeReplaced() && !level.isOutsideBuildHeight(pos.east().east())) {
            level.setBlock(pos.east().east(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.east().south()).canBeReplaced() && !level.isOutsideBuildHeight(pos.east().south())) {
            level.setBlock(pos.east().south(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.east().north()).canBeReplaced() && !level.isOutsideBuildHeight(pos.east().north())) {
            level.setBlock(pos.east().north(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeWestBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.getBlockState(pos.west()).canBeReplaced() && !level.isOutsideBuildHeight(pos.west())) {
            level.setBlock(pos.west(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
        }
        if (level.getBlockState(pos.west().above()).canBeReplaced() && !level.isOutsideBuildHeight(pos.west().above())) {
            level.setBlock(pos.west().above(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.west().west()).canBeReplaced() && !level.isOutsideBuildHeight(pos.west().west())) {
            level.setBlock(pos.west().west(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.west().south()).canBeReplaced() && !level.isOutsideBuildHeight(pos.west().south())) {
            level.setBlock(pos.west().south(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.getBlockState(pos.west().north()).canBeReplaced() && !level.isOutsideBuildHeight(pos.west().north())) {
            level.setBlock(pos.west().north(), (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 2;
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int i = 0; i <= rd; ++i) {
            if (level.getBlockState((BlockPos)placePos).canBeReplaced() && level.getBlockState(placePos.above()).is(BlockTags.DIRT)) {
                level.setBlock((BlockPos)placePos, Blocks.HANGING_ROOTS.defaultBlockState(), 2);
                break;
            }
            if (!level.getBlockState((BlockPos)placePos).is(BlockTags.DIRT) && !level.getBlockState((BlockPos)placePos).is(BlockTags.REPLACEABLE_BY_TREES) && !level.isEmptyBlock((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.move(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).canBeReplaced()) {
            level.setBlock(pos, (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return BlackwoodTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, BlackwoodTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, BlackwoodTreeFeature::isReplaceableBlock);
    }
}

