/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.flower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class RuFlowerBlock
extends FlowerBlock {
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    protected static final VoxelShape SHAPE_TALL = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_BUSH = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape SHAPE_DAISY = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);

    public RuFlowerBlock(Holder<MobEffect> mobEffect, int i, BlockBehaviour.Properties properties) {
        super(mobEffect, (float)i, properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(getter, pos);
        if (state == RuBlocks.POPPY_BUSH.get().defaultBlockState() || state == RuBlocks.SALMON_POPPY_BUSH.get().defaultBlockState() || state == RuBlocks.BLUE_LUPINE.get().defaultBlockState() || state == RuBlocks.PINK_LUPINE.get().defaultBlockState() || state == RuBlocks.PURPLE_LUPINE.get().defaultBlockState() || state == RuBlocks.YELLOW_LUPINE.get().defaultBlockState() || state == RuBlocks.RED_LUPINE.get().defaultBlockState() || state == RuBlocks.HYSSOP.get().defaultBlockState() || state.is(RuTags.SNOWBELLE)) {
            return SHAPE_BUSH.move(vec3.x, vec3.y, vec3.z);
        }
        if (state == RuBlocks.FIREWEED.get().defaultBlockState() || state == RuBlocks.WILTING_TRILLIUM.get().defaultBlockState() || state == RuBlocks.WHITE_TRILLIUM.get().defaultBlockState() || state == RuBlocks.WARATAH.get().defaultBlockState()) {
            return SHAPE_TALL.move(vec3.x, vec3.y, vec3.z);
        }
        if (state == RuBlocks.DAISY.get().defaultBlockState() || state == RuBlocks.FELICIA_DAISY.get().defaultBlockState()) {
            return SHAPE_DAISY.move(vec3.x, vec3.y, vec3.z);
        }
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }
}

