/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.cave;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;
import org.jetbrains.annotations.Nullable;

public class PointedRedstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public PointedRedstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return PointedRedstoneBlock.isValidPointedDripstonePlacement(level, pos, (Direction)state.getValue((Property)TIP_DIRECTION));
    }

    public BlockState updateShape(BlockState state1, Direction direction, BlockState state, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        if (((Boolean)state1.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state1;
        }
        Direction direction1 = (Direction)state1.getValue((Property)TIP_DIRECTION);
        if (direction1 == Direction.DOWN && level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            return state1;
        }
        if (direction == direction1.getOpposite() && !this.canSurvive(state1, (LevelReader)level, pos)) {
            if (direction1 == Direction.DOWN) {
                level.scheduleTick(pos, (Block)this, 2);
            } else {
                level.scheduleTick(pos, (Block)this, 1);
            }
            return state1;
        }
        boolean flag = state1.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedRedstoneBlock.calculateDripstoneThickness((LevelReader)level, pos, direction1, flag);
        return (BlockState)state1.setValue(THICKNESS, (Comparable)dripstonethickness);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        BlockPos blockpos = hitResult.getBlockPos();
        if (!level.isClientSide && projectile.mayInteract(level, blockpos) && projectile instanceof ThrownTrident && projectile.getDeltaMovement().length() > 0.6) {
            level.destroyBlock(blockpos, true);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float v) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP && state.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(v + 2.0f, 2.0f, level.damageSources().stalagmite());
        } else {
            super.fallOn(level, state, pos, entity, v);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float f;
        if (PointedRedstoneBlock.canDrip(state) && !((f = random.nextFloat()) > 0.12f)) {
            PointedRedstoneBlock.getFluidAboveStalactite(level, pos, state).filter(p_221848_ -> f < 0.02f || PointedRedstoneBlock.canFillCauldron(p_221848_.fluid)).ifPresent(p_221881_ -> PointedRedstoneBlock.spawnDripParticle(level, pos, state, p_221881_.fluid));
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (PointedRedstoneBlock.isStalagmite(state) && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        } else {
            PointedRedstoneBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.011377778f && PointedRedstoneBlock.isStalactiteStartPos(state, (LevelReader)level, pos)) {
            PointedRedstoneBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = context.getLevel();
        Direction direction1 = PointedRedstoneBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = context.getClickedPos(), direction = context.getNearestLookingVerticalDirection().getOpposite());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !context.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = PointedRedstoneBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction1)).setValue(THICKNESS, (Comparable)dripstonethickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.getValue(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (state.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.getOffset(getter, pos);
        return voxelshape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity entity) {
        if (!entity.isSilent()) {
            level.levelEvent(1045, pos, 0);
        }
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingStalactite(entity);
    }

    public Predicate<Entity> getHurtsEntitySelector() {
        return EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockPos = pos.mutable();
        BlockState blockstate = state;
        while (PointedRedstoneBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)level, (BlockPos)blockPos, (BlockState)blockstate);
            if (PointedRedstoneBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.getY() - blockPos.getY(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.setHurtsEntities(f, 40);
                break;
            }
            blockPos.move(Direction.DOWN);
            blockstate = level.getBlockState((BlockPos)blockPos);
        }
    }

    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockState1;
        BlockState blockState = level.getBlockState(pos.above(1));
        if (PointedRedstoneBlock.canGrow(blockState, blockState1 = level.getBlockState(pos.above(2))) && (blockpos = PointedRedstoneBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && PointedRedstoneBlock.canDrip(blockstate2 = level.getBlockState(blockpos)) && PointedRedstoneBlock.canTipGrow(blockstate2, level, blockpos)) {
            if (random.nextBoolean()) {
                PointedRedstoneBlock.grow(level, blockpos, Direction.DOWN);
            } else {
                PointedRedstoneBlock.growStalagmiteBelow(level, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockPos = pos.mutable();
        for (int i = 0; i < 10; ++i) {
            blockPos.move(Direction.DOWN);
            BlockState blockstate = level.getBlockState((BlockPos)blockPos);
            if (!blockstate.getFluidState().isEmpty()) {
                return;
            }
            if (PointedRedstoneBlock.isUnmergedTipWithDirection(blockstate, Direction.UP) && PointedRedstoneBlock.canTipGrow(blockstate, level, (BlockPos)blockPos)) {
                PointedRedstoneBlock.grow(level, (BlockPos)blockPos, Direction.UP);
                return;
            }
            if (PointedRedstoneBlock.isValidPointedDripstonePlacement((LevelReader)level, (BlockPos)blockPos, Direction.UP) && !level.isWaterAt(blockPos.below())) {
                PointedRedstoneBlock.grow(level, blockPos.below(), Direction.UP);
                return;
            }
            if (PointedRedstoneBlock.canDripThrough((BlockGetter)level, (BlockPos)blockPos, blockstate)) continue;
            return;
        }
    }

    private static void grow(ServerLevel level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = level.getBlockState(blockPos);
        if (PointedRedstoneBlock.isUnmergedTipWithDirection(blockState, direction.getOpposite())) {
            PointedRedstoneBlock.createMergedTips(blockState, (LevelAccessor)level, blockPos);
        } else if (blockState.isAir() || blockState.is(Blocks.WATER)) {
            PointedRedstoneBlock.createDripstone((LevelAccessor)level, blockPos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)RuBlocks.POINTED_REDSTONE.get().defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        level.setBlock(pos, blockstate, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockPos;
        BlockPos blockPos1;
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            blockPos1 = pos;
            blockPos = pos.above();
        } else {
            blockPos = pos;
            blockPos1 = pos.below();
        }
        PointedRedstoneBlock.createDripstone(level, blockPos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        PointedRedstoneBlock.createDripstone(level, blockPos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state, Fluid fluid) {
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        double d0 = 0.0625;
        double d1 = (double)pos.getX() + 0.5 + vec3.x;
        double d2 = (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.getZ() + 0.5 + vec3.z;
        Fluid fluid1 = PointedRedstoneBlock.getDripFluid(level, fluid);
        SimpleParticleType particleoptions = fluid1.is(FluidTags.LAVA) ? ParticleTypes.DRIPPING_DRIPSTONE_LAVA : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        level.addParticle((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int i, boolean bool) {
        if (PointedRedstoneBlock.isTip(state, bool)) {
            return pos;
        }
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (pos1, state1) -> state1.is(RuBlocks.POINTED_REDSTONE.get()) && state1.getValue((Property)TIP_DIRECTION) == direction;
        return PointedRedstoneBlock.findBlockVertical(level, pos, direction.getAxisDirection(), bipredicate, state1 -> PointedRedstoneBlock.isTip(state1, bool), i).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction direction) {
        Direction direction1;
        if (PointedRedstoneBlock.isValidPointedDripstonePlacement(level, pos, direction)) {
            direction1 = direction;
        } else {
            if (!PointedRedstoneBlock.isValidPointedDripstonePlacement(level, pos, direction.getOpposite())) {
                return null;
            }
            direction1 = direction.getOpposite();
        }
        return direction1;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction direction, boolean bool) {
        Direction direction1 = direction.getOpposite();
        BlockState blockState = level.getBlockState(pos.relative(direction));
        if (PointedRedstoneBlock.isPointedDripstoneWithDirection(blockState, direction1)) {
            return !bool && blockState.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedRedstoneBlock.isPointedDripstoneWithDirection(blockState, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockState.getValue(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = level.getBlockState(pos.relative(direction1));
            return !PointedRedstoneBlock.isPointedDripstoneWithDirection(blockstate1, direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return PointedRedstoneBlock.isStalactite(state) && state.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos blockpos = pos.relative(direction);
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.getFluidState().isEmpty()) {
            return false;
        }
        return blockstate.isAir() ? true : PointedRedstoneBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite());
    }

    private static Optional<BlockPos> findRootBlock(Level level, BlockPos pos, BlockState state, int i) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (pos1, state1) -> state1.is(RuBlocks.POINTED_REDSTONE.get()) && state1.getValue((Property)TIP_DIRECTION) == direction;
        return PointedRedstoneBlock.findBlockVertical((LevelAccessor)level, pos, direction.getOpposite().getAxisDirection(), bipredicate, state1 -> !state1.is(RuBlocks.POINTED_REDSTONE.get()), i);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, direction) || PointedRedstoneBlock.isPointedDripstoneWithDirection(blockstate, direction);
    }

    private static boolean isTip(BlockState state, boolean bool) {
        if (!state.is(RuBlocks.POINTED_REDSTONE.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || bool && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction direction) {
        return PointedRedstoneBlock.isTip(state, false) && state.getValue((Property)TIP_DIRECTION) == direction;
    }

    private static boolean isStalactite(BlockState state) {
        return PointedRedstoneBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return PointedRedstoneBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return PointedRedstoneBlock.isStalactite(state) && !level.getBlockState(pos.above()).is(RuBlocks.POINTED_REDSTONE.get());
    }

    public boolean isPathfindable(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction direction) {
        return state.is(RuBlocks.POINTED_REDSTONE.get()) && state.getValue((Property)TIP_DIRECTION) == direction;
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !PointedRedstoneBlock.isStalactite(state) ? Optional.empty() : PointedRedstoneBlock.findRootBlock(level, pos, state, 11).map(pos1 -> {
            BlockPos blockpos = pos1.above();
            BlockState blockstate = level.getBlockState(blockpos);
            Object fluid = blockstate.is(Blocks.MUD) && !level.dimensionType().ultraWarm() ? Fluids.WATER : level.getFluidState(blockpos).getType();
            return new FluidInfo(blockpos, (Fluid)fluid, blockstate);
        });
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.LAVA || fluid == Fluids.WATER;
    }

    private static boolean canGrow(BlockState state, BlockState state1) {
        return state.is(RuBlocks.RAW_REDSTONE_BLOCK.get()) && state1.is(Blocks.WATER) && state1.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level level, Fluid fluid) {
        if (fluid.isSame(Fluids.EMPTY)) {
            return level.dimensionType().ultraWarm() ? Fluids.LAVA : Fluids.WATER;
        }
        return fluid;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BiPredicate<BlockPos, BlockState> biPredicate, Predicate<BlockState> statePredicate, int a) {
        Direction direction1 = Direction.get((Direction.AxisDirection)direction, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockPos = pos.mutable();
        for (int i = 1; i < a; ++i) {
            blockPos.move(direction1);
            BlockState blockstate = level.getBlockState((BlockPos)blockPos);
            if (statePredicate.test(blockstate)) {
                return Optional.of(blockPos.immutable());
            }
            if (!level.isOutsideBuildHeight(blockPos.getY()) && biPredicate.test((BlockPos)blockPos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter getter, BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (state.isSolidRender(getter, pos)) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelshape = state.getCollisionShape(getter, pos);
        return !Shapes.joinIsNotEmpty((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.AND);
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState state) {
    }
}

