/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.tileentity.furnaces;

import com.google.common.collect.Maps;
import ironfurnaces.Config;
import ironfurnaces.blocks.furnaces.BlockIronFurnaceBase;
import ironfurnaces.blocks.furnaces.BlockMillionFurnace;
import ironfurnaces.capability.PlayerFurnacesListProvider;
import ironfurnaces.energy.FEnergyStorage;
import ironfurnaces.init.ModSetup;
import ironfurnaces.init.Registration;
import ironfurnaces.items.ItemHeater;
import ironfurnaces.items.augments.ItemAugment;
import ironfurnaces.items.augments.ItemAugmentBlasting;
import ironfurnaces.items.augments.ItemAugmentBlue;
import ironfurnaces.items.augments.ItemAugmentFactory;
import ironfurnaces.items.augments.ItemAugmentFuel;
import ironfurnaces.items.augments.ItemAugmentGenerator;
import ironfurnaces.items.augments.ItemAugmentGreen;
import ironfurnaces.items.augments.ItemAugmentRed;
import ironfurnaces.items.augments.ItemAugmentSmoking;
import ironfurnaces.items.augments.ItemAugmentSpeed;
import ironfurnaces.recipes.GeneratorRecipe;
import ironfurnaces.tileentity.BlockWirelessEnergyHeaterTile;
import ironfurnaces.tileentity.TileEntityInventory;
import ironfurnaces.tileentity.furnaces.BlockCopperFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockCrystalFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockDiamondFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockEmeraldFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockGoldFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockMillionFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockNetheriteFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockObsidianFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockSilverFurnaceTile;
import ironfurnaces.tileentity.furnaces.other.BlockAllthemodiumFurnaceTile;
import ironfurnaces.tileentity.furnaces.other.BlockUnobtainiumFurnaceTile;
import ironfurnaces.tileentity.furnaces.other.BlockVibraniumFurnaceTile;
import ironfurnaces.util.DirectionUtil;
import ironfurnaces.util.FurnaceSettings;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class BlockIronFurnaceTileBase
extends TileEntityInventory
implements RecipeCraftingHolder,
StackedContentsCompatible {
    public static final int INPUT = 0;
    public static final int FUEL = 1;
    public static final int OUTPUT = 2;
    public static final int AUGMENT_RED = 3;
    public static final int AUGMENT_GREEN = 4;
    public static final int AUGMENT_BLUE = 5;
    public static final int GENERATOR_FUEL = 6;
    public static final int[] FACTORY_INPUT = new int[]{7, 8, 9, 10, 11, 12};
    public final int[] provides = new int[Direction.values().length];
    protected final int[] lastProvides = new int[this.provides.length];
    public int jovial;
    public int[] currentAugment = new int[3];
    public int[] factoryCookTime = new int[6];
    public int[] factoryTotalCookTime = new int[6];
    public double[] usedRF = new double[6];
    public double generatorBurn;
    public int generatorRecentRecipeRF;
    public double gottenRF;
    public int furnaceBurnTime;
    public int cookTime;
    public int totalCookTime;
    public int recipesUsed;
    public long lastGameTickEnergyUpdated;
    public UUID owner;
    public boolean rainbowGenerating;
    public final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    public RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> recipeCheckSmelting;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> recipeCheckSmoking;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> recipeCheckBlasting;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends GeneratorRecipe> recipeCheckGenerator;
    public FurnaceSettings furnaceSettings;
    public FEnergyStorage energyStorage = new FEnergyStorage((int)((Integer)Config.furnaceEnergyCapacityTier2.get())){

        @Override
        protected void onEnergyChanged() {
            if (BlockIronFurnaceTileBase.this.level != null && BlockIronFurnaceTileBase.this.level.getBlockEntity(BlockIronFurnaceTileBase.this.getBlockPos()) != null) {
                if (BlockIronFurnaceTileBase.this.lastGameTickEnergyUpdated <= 0L) {
                    BlockIronFurnaceTileBase.this.setChanged();
                    BlockIronFurnaceTileBase.this.lastGameTickEnergyUpdated = BlockIronFurnaceTileBase.this.level.getGameTime();
                } else if (BlockIronFurnaceTileBase.this.level.getGameTime() - BlockIronFurnaceTileBase.this.lastGameTickEnergyUpdated >= 20L) {
                    BlockIronFurnaceTileBase.this.setChanged();
                    BlockIronFurnaceTileBase.this.lastGameTickEnergyUpdated = BlockIronFurnaceTileBase.this.level.getGameTime();
                }
            }
        }
    };

    public BlockIronFurnaceTileBase(BlockEntityType<?> tileentitytypeIn, BlockPos pos, BlockState state) {
        super(tileentitytypeIn, pos, state, 19);
        this.recipeCheckSmelting = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING);
        this.recipeCheckSmoking = RecipeManager.createCheck((RecipeType)RecipeType.SMOKING);
        this.recipeCheckBlasting = RecipeManager.createCheck((RecipeType)RecipeType.BLASTING);
        this.recipeCheckGenerator = RecipeManager.createCheck(Registration.GENERATOR_RECIPE_TYPE.get());
        this.recipeType = RecipeType.SMELTING;
        this.furnaceSettings = new FurnaceSettings(){

            @Override
            public void onChanged() {
                BlockIronFurnaceTileBase.this.setChanged();
            }
        };
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    public void setMaxEnergy(int energy) {
        this.energyStorage.setCapacity(energy);
    }

    public void removeEnergy(int energy) {
        this.energyStorage.setEnergy(this.energyStorage.getEnergy() - energy);
    }

    public boolean hasRecipe(ItemStack stack) {
        Item item = stack.getItem();
        if (this.recipeType == RecipeType.SMOKING) {
            return ModSetup.HAS_RECIPE_SMOKING.computeIfAbsent(item, value -> this.recipeCheckSmoking.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).isPresent());
        }
        if (this.recipeType == RecipeType.BLASTING) {
            return ModSetup.HAS_RECIPE_BLASTING.computeIfAbsent(item, value -> this.recipeCheckBlasting.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).isPresent());
        }
        return ModSetup.HAS_RECIPE.computeIfAbsent(item, value -> this.recipeCheckSmelting.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).isPresent());
    }

    protected RecipeHolder<? extends AbstractCookingRecipe> getRecipeNonCached(ItemStack stack) {
        if (this.recipeType == RecipeType.SMOKING) {
            return this.recipeCheckSmoking.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).orElse(null);
        }
        if (this.recipeType == RecipeType.BLASTING) {
            return this.recipeCheckBlasting.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).orElse(null);
        }
        return this.recipeCheckSmelting.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).orElse(null);
    }

    public boolean hasGeneratorBlastingRecipe(ItemStack stack) {
        return this.recipeCheckGenerator.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    protected RecipeHolder<? extends GeneratorRecipe> getRecipeGeneratorBlasting(ItemStack stack) {
        return this.recipeCheckGenerator.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).orElse(null);
    }

    protected void checkRecipeType() {
        ItemStack stack = this.getItem(3);
        if (stack.getItem() instanceof ItemAugmentBlasting && this.recipeType != RecipeType.BLASTING) {
            this.recipeType = RecipeType.BLASTING;
        }
        if (stack.getItem() instanceof ItemAugmentSmoking && this.recipeType != RecipeType.SMOKING) {
            this.recipeType = RecipeType.SMOKING;
        }
        if (!(stack.getItem() instanceof ItemAugmentSmoking) && !(stack.getItem() instanceof ItemAugmentBlasting) && this.recipeType != RecipeType.SMELTING) {
            this.recipeType = RecipeType.SMELTING;
        }
    }

    public int getCookTime() {
        ItemStack stack = this.getItem(4);
        if (this.getItem(0).getItem() == Items.AIR) {
            return this.totalCookTime;
        }
        int speed = this.getSpeed();
        if (!stack.isEmpty()) {
            if (stack.getItem() instanceof ItemAugmentSpeed) {
                speed = Math.max(1, speed / 2);
            }
            if (stack.getItem() instanceof ItemAugmentFuel) {
                speed = Math.max(1, (int)Math.ceil((double)speed * 1.25));
            }
        }
        return Math.max(1, speed);
    }

    protected int getSpeed() {
        int regular = (Integer)this.getCookTimeConfig().get();
        RecipeHolder<? extends AbstractCookingRecipe> recipe = this.getRecipeNonCached(this.getItem(0));
        if (recipe != null) {
            int recipe_cooktime = ((AbstractCookingRecipe)recipe.value()).getCookingTime();
            double div = 200.0 / (double)recipe_cooktime;
            double i = (double)regular / div;
            return (int)Math.max(1.0, i);
        }
        return 0;
    }

    protected int getFactoryCookTime(int slot) {
        ItemStack stack = this.getItem(4);
        if (this.getItem(slot).getItem() == Items.AIR) {
            return this.factoryTotalCookTime[slot - FACTORY_INPUT[0]];
        }
        int speed = this.getFactorySpeed(slot);
        if (!stack.isEmpty()) {
            if (stack.getItem() instanceof ItemAugmentSpeed) {
                speed = Math.max(1, speed / 2);
            }
            if (stack.getItem() instanceof ItemAugmentFuel) {
                speed = Math.max(1, (int)Math.ceil((double)speed * 1.25));
            }
        }
        return Math.max(1, speed);
    }

    protected int getFactorySpeed(int slot) {
        int regular = (Integer)this.getCookTimeConfig().get();
        RecipeHolder<? extends AbstractCookingRecipe> recipe = this.getRecipeNonCached(this.getItem(slot));
        if (recipe != null) {
            int recipe_cooktime = ((AbstractCookingRecipe)recipe.value()).getCookingTime();
            double div = 200.0 / (double)recipe_cooktime;
            double i = (double)regular / div;
            return (int)Math.max(1.0, i);
        }
        return 0;
    }

    public ModConfigSpec.IntValue getCookTimeConfig() {
        return null;
    }

    protected int getAugment(ItemStack stack) {
        if (stack.getItem() instanceof ItemAugmentBlasting) {
            return 1;
        }
        if (stack.getItem() instanceof ItemAugmentSmoking) {
            return 2;
        }
        if (stack.getItem() instanceof ItemAugmentSpeed) {
            return 1;
        }
        if (stack.getItem() instanceof ItemAugmentFuel) {
            return 2;
        }
        if (stack.getItem() instanceof ItemAugmentFactory) {
            return 1;
        }
        if (stack.getItem() instanceof ItemAugmentGenerator) {
            return 2;
        }
        return 0;
    }

    public void forceUpdateAllStates() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() != this.isBurning()) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
        }
        if (((Integer)state.getValue((Property)BlockIronFurnaceBase.TYPE)).intValue() != this.getStateType()) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockIronFurnaceBase.TYPE, (Comparable)Integer.valueOf(this.getStateType())), 3);
        }
        if ((Integer)state.getValue((Property)BlockIronFurnaceBase.JOVIAL) != this.jovial) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockIronFurnaceBase.JOVIAL, (Comparable)Integer.valueOf(this.jovial)), 3);
        }
    }

    public void dropContents() {
        for (int i = 0; i <= 18; ++i) {
            if (i >= 3 && i <= 5) continue;
            ItemStack stack = this.getItem(i);
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)stack);
        }
    }

    public int getGeneration() {
        int rf = 0;
        if (this instanceof BlockCopperFurnaceTile) {
            rf = (Integer)Config.copperFurnaceGeneration.get();
        } else if (this instanceof BlockIronFurnaceTile) {
            rf = (Integer)Config.ironFurnaceGeneration.get();
        } else if (this instanceof BlockSilverFurnaceTile) {
            rf = (Integer)Config.silverFurnaceGeneration.get();
        } else if (this instanceof BlockGoldFurnaceTile) {
            rf = (Integer)Config.goldFurnaceGeneration.get();
        } else if (this instanceof BlockDiamondFurnaceTile) {
            rf = (Integer)Config.diamondFurnaceGeneration.get();
        } else if (this instanceof BlockEmeraldFurnaceTile) {
            rf = (Integer)Config.emeraldFurnaceGeneration.get();
        } else if (this instanceof BlockCrystalFurnaceTile) {
            rf = (Integer)Config.crystalFurnaceGeneration.get();
        } else if (this instanceof BlockObsidianFurnaceTile) {
            rf = (Integer)Config.obsidianFurnaceGeneration.get();
        } else if (this instanceof BlockNetheriteFurnaceTile) {
            rf = (Integer)Config.netheriteFurnaceGeneration.get();
        } else if (this instanceof BlockMillionFurnaceTile) {
            rf = (Integer)Config.millionFurnaceGeneration.get();
        } else if (this instanceof BlockAllthemodiumFurnaceTile) {
            rf = (Integer)Config.allthemodiumGeneration.get();
        } else if (this instanceof BlockVibraniumFurnaceTile) {
            rf = (Integer)Config.vibraniumGeneration.get();
        } else if (this instanceof BlockUnobtainiumFurnaceTile) {
            rf = (Integer)Config.unobtainiumGeneration.get();
        }
        return this.getItem(4).getItem() instanceof ItemAugmentSpeed ? rf * 2 : (this.getItem(4).getItem() instanceof ItemAugmentFuel ? (int)((double)rf * 0.75) : rf);
    }

    public static int getSmokingBurn(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        Item item = stack.getItem();
        return ModSetup.SMOKING_BURNS.getOrDefault(item, BlockIronFurnaceTileBase.addSmokingBurn(stack));
    }

    public static int addSmokingBurn(ItemStack stack) {
        int burnTime = BlockIronFurnaceTileBase.getSmokingBurnTime(stack);
        Item item = stack.getItem();
        ModSetup.SMOKING_BURNS.put(item, burnTime);
        return 0;
    }

    public static int getSmokingBurnTime(ItemStack stack) {
        if (!stack.isEmpty() && stack.get(DataComponents.FOOD) != null && ((FoodProperties)stack.get(DataComponents.FOOD)).nutrition() > 0) {
            return ((FoodProperties)stack.get(DataComponents.FOOD)).nutrition() * 800;
        }
        return 0;
    }

    public int getGeneratorBurn() {
        int burn = 0;
        if (this.getItem(3).getItem() instanceof ItemAugmentSmoking) {
            burn = BlockIronFurnaceTileBase.getSmokingBurn(this.getItem(6));
        } else if (this.getItem(3).getItem() instanceof ItemAugmentBlasting) {
            if (!this.getItem(6).isEmpty()) {
                int energy = ((GeneratorRecipe)this.getRecipeGeneratorBlasting(this.getItem(6)).value()).getEnergy();
                burn = energy / 20;
            }
        } else {
            burn = BlockIronFurnaceTileBase.getBurnTime(this.getItem(6), RecipeType.SMELTING);
        }
        if (this.getItem(4).getItem() instanceof ItemAugmentSpeed) {
            burn /= 2;
        } else if (this.getItem(4).getItem() instanceof ItemAugmentFuel) {
            burn *= 2;
        }
        return burn;
    }

    public boolean isFactoryCooking() {
        for (int i = 0; i < this.factoryCookTime.length; ++i) {
            if (this.factoryCookTime[i] <= 0) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, Integer> getSplitCounts(int[] slot, int[] input) {
        if (slot.length != input.length) {
            return null;
        }
        HashMap output = Maps.newHashMap();
        double sum = 0.0;
        for (int i = 0; i < input.length; ++i) {
            sum += (double)input[i];
        }
        double splitted = sum / (double)input.length;
        if (sum % (double)input.length != 0.0) {
            if (Math.floor(splitted) < splitted) {
                double lowest = Math.floor(sum / (double)input.length) * (double)input.length;
                int itemsLeftOver = (int)sum - (int)lowest;
                for (int i = 0; i < input.length; ++i) {
                    if (itemsLeftOver > 0) {
                        input[i] = (int)Math.ceil(splitted);
                        --itemsLeftOver;
                        continue;
                    }
                    input[i] = (int)splitted;
                }
            }
        } else {
            for (int i = 0; i < input.length; ++i) {
                input[i] = (int)splitted;
            }
        }
        for (int i = 0; i < input.length; ++i) {
            output.put(slot[i], input[i]);
        }
        return output;
    }

    public void fillEmptySlots(int start, int size) {
        int amount = 0;
        for (int i = start; i < size; ++i) {
            if (!this.getItem(FACTORY_INPUT[i]).isEmpty()) continue;
            ++amount;
        }
        if (amount == 0) {
            return;
        }
        ItemStack stack = ItemStack.EMPTY;
        for (int j = start; j < size; ++j) {
            if (this.getItem(FACTORY_INPUT[j]).isEmpty() || this.getItem(FACTORY_INPUT[j]).getCount() <= 1 || amount <= 0) continue;
            if (amount >= this.getItem(FACTORY_INPUT[j]).getCount()) {
                amount = this.getItem(FACTORY_INPUT[j]).getCount() - 1;
            }
            stack = this.getItem(FACTORY_INPUT[j]).copy();
            this.getItem(FACTORY_INPUT[j]).shrink(amount);
            for (int i = start; i < size; ++i) {
                if (!this.getItem(FACTORY_INPUT[i]).isEmpty() || amount <= 0) continue;
                this.setItem(FACTORY_INPUT[i], stack.copyWithCount(1));
                --amount;
                this.setChanged();
            }
            this.setChanged();
            break;
        }
    }

    public void split(boolean fullCheck, int start, int size) {
        int i;
        ItemStack itemToCheck = ItemStack.EMPTY;
        int fullCheckCount = 0;
        if (!fullCheck) {
            for (i = start; i < size; ++i) {
                if (!this.getItem(FACTORY_INPUT[i]).isEmpty()) continue;
                ++fullCheckCount;
            }
            if (fullCheckCount == 0) {
                return;
            }
        }
        for (i = start; i < size; ++i) {
            if (this.getItem(FACTORY_INPUT[i]).isEmpty()) continue;
            itemToCheck = this.getItem(FACTORY_INPUT[i]).copy();
        }
        if (itemToCheck.isEmpty()) {
            return;
        }
        this.fillEmptySlots(start, size);
        HashMap items = Maps.newHashMap();
        Map<Object, Object> setCounts = Maps.newHashMap();
        for (int i2 = start; i2 < size; ++i2) {
            if (this.getItem(FACTORY_INPUT[i2]).isEmpty() || this.getItem(FACTORY_INPUT[i2]).getItem() != itemToCheck.getItem()) continue;
            items.put(FACTORY_INPUT[i2], this.getItem(FACTORY_INPUT[i2]).getCount());
        }
        if (items.isEmpty()) {
            return;
        }
        int[] slot = new int[items.size()];
        int[] input = new int[items.size()];
        int j = 0;
        for (Map.Entry itemEntry : items.entrySet()) {
            slot[j] = (Integer)itemEntry.getKey();
            input[j] = (Integer)itemEntry.getValue();
            ++j;
        }
        setCounts = this.getSplitCounts(slot, input);
        int check = 0;
        for (Map.Entry<Object, Object> countsEntry : setCounts.entrySet()) {
            int count = this.getItem((Integer)countsEntry.getKey()).getCount();
            if (count != (Integer)countsEntry.getValue()) continue;
            ++check;
        }
        if (check == setCounts.size()) {
            return;
        }
        for (Map.Entry<Object, Object> countsEntry : setCounts.entrySet()) {
            ItemStack newStack = this.getItem((Integer)countsEntry.getKey()).copy();
            newStack.setCount(((Integer)countsEntry.getValue()).intValue());
            this.setItem((Integer)countsEntry.getKey(), newStack);
            this.setChanged();
        }
    }

    boolean rainbowCheckFurnaceTiers(List<BlockIronFurnaceTileBase> list) {
        if (list.isEmpty()) {
            return false;
        }
        int check = 0;
        for (BlockIronFurnaceTileBase furnace : list) {
            if (!(furnace.generatorBurn > 0.0) || furnace.getEnergy() >= furnace.getCapacity()) continue;
            ++check;
        }
        return check != 0;
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState blockState, final BlockIronFurnaceTileBase e) {
        if (!e.level.isClientSide && e.isGenerator()) {
            boolean flag3 = false;
            ArrayList<BlockIronFurnaceTileBase> iron = new ArrayList<BlockIronFurnaceTileBase>();
            ArrayList<BlockIronFurnaceTileBase> gold = new ArrayList<BlockIronFurnaceTileBase>();
            ArrayList<BlockIronFurnaceTileBase> diamond = new ArrayList<BlockIronFurnaceTileBase>();
            Direction[] emerald = new ArrayList();
            ArrayList<BlockIronFurnaceTileBase> obsidian = new ArrayList<BlockIronFurnaceTileBase>();
            ArrayList<BlockIronFurnaceTileBase> crystal = new ArrayList<BlockIronFurnaceTileBase>();
            ArrayList<BlockIronFurnaceTileBase> netherite = new ArrayList<BlockIronFurnaceTileBase>();
            ArrayList<BlockIronFurnaceTileBase> copper = new ArrayList<BlockIronFurnaceTileBase>();
            ArrayList<BlockIronFurnaceTileBase> silver = new ArrayList<BlockIronFurnaceTileBase>();
            ArrayList<BlockMillionFurnaceTile> rainbow = new ArrayList<BlockMillionFurnaceTile>();
            if (e instanceof BlockMillionFurnaceTile) {
                int i;
                BlockMillionFurnaceTile furnaceTile = (BlockMillionFurnaceTile)e;
                if (furnaceTile.owner != null) {
                    List<BlockPos> furnacesBlockPos;
                    flag3 = true;
                    if (level.getPlayerByUUID(furnaceTile.owner) != null && !(furnacesBlockPos = ((PlayerFurnacesListProvider)level.getPlayerByUUID((UUID)furnaceTile.owner).getData((AttachmentType)((AttachmentType)Registration.PLAYER_FURNACES_LIST.get()))).furnacesList.get()).isEmpty()) {
                        for (i = 0; i < furnacesBlockPos.size(); ++i) {
                            level.getChunkAt(furnacesBlockPos.get(i)).setLoaded(true);
                            BlockEntity be = level.getBlockEntity(furnacesBlockPos.get(i));
                            if (be == null || !(be instanceof BlockIronFurnaceTileBase)) continue;
                            BlockIronFurnaceTileBase te = (BlockIronFurnaceTileBase)be;
                            if (te instanceof BlockIronFurnaceTile) {
                                iron.add((BlockIronFurnaceTile)te);
                            }
                            if (te instanceof BlockGoldFurnaceTile) {
                                gold.add((BlockGoldFurnaceTile)te);
                            }
                            if (te instanceof BlockDiamondFurnaceTile) {
                                diamond.add((BlockDiamondFurnaceTile)te);
                            }
                            if (te instanceof BlockEmeraldFurnaceTile) {
                                emerald.add((BlockEmeraldFurnaceTile)te);
                            }
                            if (te instanceof BlockObsidianFurnaceTile) {
                                obsidian.add((BlockObsidianFurnaceTile)te);
                            }
                            if (te instanceof BlockCrystalFurnaceTile) {
                                crystal.add((BlockCrystalFurnaceTile)te);
                            }
                            if (te instanceof BlockNetheriteFurnaceTile) {
                                netherite.add((BlockNetheriteFurnaceTile)te);
                            }
                            if (te instanceof BlockCopperFurnaceTile) {
                                copper.add((BlockCopperFurnaceTile)te);
                            }
                            if (te instanceof BlockSilverFurnaceTile) {
                                silver.add((BlockSilverFurnaceTile)te);
                            }
                            if (!(te instanceof BlockMillionFurnaceTile)) continue;
                            rainbow.add((BlockMillionFurnaceTile)te);
                        }
                    }
                }
                if (rainbow.size() > 1) {
                    int rainbowGens = 0;
                    for (i = 0; i < rainbow.size(); ++i) {
                        if (!((BlockIronFurnaceTileBase)rainbow.get(i)).isGenerator()) continue;
                        ++rainbowGens;
                    }
                    if (rainbowGens > 1) {
                        flag3 = false;
                    }
                }
                if (flag3 && e.rainbowCheckFurnaceTiers(iron) && e.rainbowCheckFurnaceTiers(gold) && e.rainbowCheckFurnaceTiers(diamond) && e.rainbowCheckFurnaceTiers((List<BlockIronFurnaceTileBase>)emerald) && e.rainbowCheckFurnaceTiers(obsidian) && e.rainbowCheckFurnaceTiers(crystal) && e.rainbowCheckFurnaceTiers(netherite) && e.rainbowCheckFurnaceTiers(copper) && e.rainbowCheckFurnaceTiers(silver)) {
                    e.rainbowGenerating = flag3;
                    state = level.getBlockState(worldPosition);
                    if ((Boolean)state.getValue((Property)BlockMillionFurnace.RAINBOW_GENERATING) != e.rainbowGenerating) {
                        level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockMillionFurnace.RAINBOW_GENERATING, (Comparable)Boolean.valueOf(e.rainbowGenerating)), 3);
                    }
                    e.rainbowEnergyOut();
                } else {
                    e.rainbowGenerating = false;
                    state = level.getBlockState(worldPosition);
                    if ((Boolean)state.getValue((Property)BlockMillionFurnace.RAINBOW_GENERATING) != e.rainbowGenerating) {
                        level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockMillionFurnace.RAINBOW_GENERATING, (Comparable)Boolean.valueOf(e.rainbowGenerating)), 3);
                    }
                }
            }
        }
        boolean flag1 = false;
        boolean wasBurning = e.isBurning();
        if (e.furnaceSettings.size() <= 0) {
            e.furnaceSettings = new FurnaceSettings(){

                @Override
                public void onChanged() {
                    e.setChanged();
                }
            };
        }
        for (int i = 3; i <= 5; ++i) {
            if (e.currentAugment[i - 3] == e.getAugment(e.getItem(i))) continue;
            e.currentAugment[i - 3] = e.getAugment(e.getItem(i));
            e.furnaceBurnTime = 0;
            e.generatorBurn = 0.0;
            if (i - 3 != 2 && (!e.isGenerator() || i - 3 != 0)) continue;
            e.dropContents();
        }
        if (!e.level.isClientSide) {
            int mode;
            if (e.getCapacity() != e.getCapacityFromTier()) {
                e.setMaxEnergy(e.getCapacityFromTier());
            }
            if (e.totalCookTime != e.getCookTime()) {
                e.totalCookTime = e.getCookTime();
            }
            if ((mode = e.getRedstoneSetting()) != 0) {
                if (mode == 2) {
                    int i = 0;
                    for (Direction side : Direction.values()) {
                        if (level.getSignal(worldPosition.offset(side.getNormal()), side) <= 0) continue;
                        ++i;
                    }
                    if (i != 0) {
                        e.cookTime = 0;
                        e.furnaceBurnTime = 0;
                        e.forceUpdateAllStates();
                        return;
                    }
                }
                if (mode == 1) {
                    boolean flag = false;
                    for (Direction side : Direction.values()) {
                        if (level.getSignal(worldPosition.offset(side.getNormal()), side) <= 0) continue;
                        flag = true;
                    }
                    if (!flag) {
                        e.cookTime = 0;
                        e.furnaceBurnTime = 0;
                        e.forceUpdateAllStates();
                        return;
                    }
                }
                for (i = 0; i < Direction.values().length; ++i) {
                    e.provides[i] = e.getBlockState().getDirectSignal((BlockGetter)e.level, worldPosition, DirectionUtil.fromId(i));
                }
            } else {
                for (i = 0; i < Direction.values().length; ++i) {
                    e.provides[i] = 0;
                }
            }
            if (e.doesNeedUpdateSend()) {
                e.onUpdateSent();
            }
        }
        if (e.isFactory()) {
            if (!e.level.isClientSide) {
                int size;
                int start;
                if (!e.energyStorage.canReceive()) {
                    e.energyStorage.setMaxReceive(e.energyStorage.getMaxEnergyStored());
                }
                if (e.energyStorage.canExtract()) {
                    e.energyStorage.setMaxExtract(0);
                }
                e.checkRecipeType();
                int n = e.getTier() == 0 ? 2 : (start = e.getTier() == 1 ? 1 : 0);
                int n2 = e.getTier() == 0 ? 4 : (size = e.getTier() == 1 ? 5 : 6);
                if (e.isAutoSplit()) {
                    e.split(false, start, size);
                }
                for (int i = start; i < size; ++i) {
                    int slot = FACTORY_INPUT[i];
                    if (e.factoryTotalCookTime[i] != e.getFactoryCookTime(slot)) {
                        e.factoryTotalCookTime[i] = e.getFactoryCookTime(slot);
                    }
                    if (!e.getItem(slot).isEmpty()) {
                        int energy;
                        RecipeHolder<? extends AbstractCookingRecipe> irecipe = e.getRecipeNonCached(e.getItem(slot));
                        boolean valid = e.canFactorySmelt(irecipe, slot);
                        if (!valid) continue;
                        int energyRecipe = ((AbstractCookingRecipe)irecipe.value()).getCookingTime() * 20;
                        int n3 = e.getItem(4).getItem() instanceof ItemAugmentSpeed ? energyRecipe * 2 : (energy = e.getItem(4).getItem() instanceof ItemAugmentFuel ? energyRecipe / 2 : energyRecipe);
                        if (e.getEnergy() < energy && e.factoryCookTime[i] <= 0) continue;
                        int n4 = i;
                        e.factoryCookTime[n4] = e.factoryCookTime[n4] + 1;
                        int n5 = i;
                        e.usedRF[n5] = e.usedRF[n5] + (double)(energy / e.factoryTotalCookTime[i]);
                        e.setEnergy((int)((double)e.getEnergy() - (double)(energy / e.factoryTotalCookTime[i])));
                        if (((Boolean)level.getBlockState(e.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue() != e.isFactoryCooking()) {
                            level.setBlock(worldPosition, (BlockState)level.getBlockState(worldPosition).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(e.isFactoryCooking())), 3);
                        }
                        if (e.factoryCookTime[i] < e.factoryTotalCookTime[i]) continue;
                        e.factoryCookTime[i] = 0;
                        if (e.usedRF[i] < (double)energy) {
                            double diff = (double)energy - e.usedRF[i];
                            e.setEnergy((int)((double)e.getEnergy() - diff));
                        }
                        e.usedRF[i] = 0.0;
                        e.factoryTotalCookTime[i] = e.getFactoryCookTime(slot);
                        if (e.isAutoSplit()) {
                            e.split(true, start, size);
                        }
                        e.factorySmelt(irecipe, slot);
                        e.setChanged();
                        continue;
                    }
                    e.factoryCookTime[i] = 0;
                    if (((Boolean)level.getBlockState(e.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue() == e.isFactoryCooking()) continue;
                    level.setBlock(worldPosition, (BlockState)level.getBlockState(worldPosition).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(e.isFactoryCooking())), 3);
                }
                if (e.level.getGameTime() % 24L == 0L) {
                    BlockState state = level.getBlockState(worldPosition);
                    if (((Integer)state.getValue((Property)BlockIronFurnaceBase.TYPE)).intValue() != e.getStateType()) {
                        level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockIronFurnaceBase.TYPE, (Comparable)Integer.valueOf(e.getStateType())), 3);
                    }
                    if ((Integer)state.getValue((Property)BlockIronFurnaceBase.JOVIAL) != e.jovial) {
                        level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockIronFurnaceBase.JOVIAL, (Comparable)Integer.valueOf(e.jovial)), 3);
                    }
                    for (int i = 0; i < e.factoryCookTime.length; ++i) {
                        int j;
                        if (e.factoryCookTime[i] > 0) continue;
                        for (j = 0; j < FACTORY_INPUT.length; ++j) {
                            if (e.getItem(FACTORY_INPUT[j]).isEmpty()) {
                                e.autoFactoryIO();
                                e.setChanged();
                                continue;
                            }
                            if (e.getItem(FACTORY_INPUT[j]).getCount() >= e.getItem(FACTORY_INPUT[j]).getMaxStackSize()) continue;
                            e.autoFactoryIO();
                            e.setChanged();
                        }
                        for (j = 0; j < FACTORY_INPUT.length; ++j) {
                            int outputSlot = FACTORY_INPUT[j] + 6;
                            if (e.getItem(outputSlot).isEmpty() || e.getItem(outputSlot).getCount() < 64) continue;
                            e.autoFactoryIO();
                        }
                    }
                }
            }
        } else if (e.isGenerator()) {
            if (!level.isClientSide) {
                if (e.energyStorage.canReceive()) {
                    e.energyStorage.setMaxReceive(0);
                }
                if (!e.energyStorage.canExtract()) {
                    e.energyStorage.setMaxExtract(e.energyStorage.getMaxEnergyStored());
                }
                if (e.getEnergy() < e.getCapacity()) {
                    if (!e.getItem(6).isEmpty() && e.generatorBurn <= 0.0) {
                        e.generatorBurn = e.getGeneratorBurn();
                        e.generatorRecentRecipeRF = (int)e.generatorBurn;
                        if (e.getItem(6).hasCraftingRemainingItem()) {
                            e.setItem(6, e.getItem(6).getCraftingRemainingItem());
                        } else if (!e.getItem(6).isEmpty()) {
                            e.getItem(6).shrink(1);
                            if (e.getItem(6).isEmpty()) {
                                e.setItem(6, e.getItem(6).getCraftingRemainingItem());
                            }
                        }
                        e.setChanged();
                    }
                    if (e.isGenerator() && (Boolean)level.getBlockState(e.getBlockPos()).getValue((Property)BlockStateProperties.LIT) != e.generatorBurn > 0.0) {
                        level.setBlock(worldPosition, (BlockState)level.getBlockState(worldPosition).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(e.generatorBurn > 0.0)), 3);
                    }
                    if (e.generatorBurn > 0.0) {
                        double max = e.generatorRecentRecipeRF * 20;
                        e.gottenRF += (double)e.getGeneration();
                        e.setEnergy(e.getEnergy() + e.getGeneration());
                        if (e.generatorBurn - (double)e.getGeneration() / 20.0 <= 0.0) {
                            if (e.gottenRF + (double)e.getGeneration() > max && e.gottenRF + (double)e.getGeneration() < (double)e.getCapacity()) {
                                int diff = (int)(e.gottenRF + (double)e.getGeneration() - max);
                                e.setEnergy(e.getEnergy() + e.getGeneration());
                                e.removeEnergy(diff);
                            }
                            if (e.gottenRF + (double)e.getGeneration() < max) {
                                int diff = (int)(max - e.gottenRF + (double)e.getGeneration());
                                e.setEnergy(e.getEnergy() + e.getGeneration());
                                e.setEnergy(e.getEnergy() + diff);
                            }
                            e.gottenRF = 0.0;
                        }
                        e.generatorBurn -= (double)e.getGeneration() / 20.0;
                        if (e.generatorBurn <= 0.0) {
                            e.autoIOGenerator();
                            e.generatorBurn = 0.0;
                        }
                    }
                }
                if (e.generatorBurn <= 0.0) {
                    e.generatorBurn = 0.0;
                }
                e.energyOut();
                if (e.level.getGameTime() % 24L == 0L && e.generatorBurn <= 0.0) {
                    if (e.getItem(6).isEmpty()) {
                        e.autoIOGenerator();
                        e.setChanged();
                    } else if (e.getItem(6).getCount() < e.getItem(6).getMaxStackSize()) {
                        e.autoIOGenerator();
                        e.setChanged();
                    }
                }
            }
            if (e.level.getGameTime() % 24L == 0L) {
                BlockState state = level.getBlockState(worldPosition);
                if (((Integer)state.getValue((Property)BlockIronFurnaceBase.TYPE)).intValue() != e.getStateType()) {
                    level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockIronFurnaceBase.TYPE, (Comparable)Integer.valueOf(e.getStateType())), 3);
                }
                if ((Integer)state.getValue((Property)BlockIronFurnaceBase.JOVIAL) != e.jovial) {
                    level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockIronFurnaceBase.JOVIAL, (Comparable)Integer.valueOf(e.jovial)), 3);
                }
            }
        } else if (e.isFurnace()) {
            if (e.energyStorage.canReceive()) {
                e.energyStorage.setMaxReceive(0);
            }
            if (e.energyStorage.canExtract()) {
                e.energyStorage.setMaxExtract(0);
            }
            if (!e.level.isClientSide) {
                if (e.isBurning()) {
                    --e.furnaceBurnTime;
                }
                e.checkRecipeType();
                ItemStack itemstack = e.getItem(1);
                if (e.isBurning() || !itemstack.isEmpty() && !e.getItem(0).isEmpty()) {
                    RecipeHolder<? extends AbstractCookingRecipe> irecipe = null;
                    if (!e.getItem(0).isEmpty()) {
                        irecipe = e.getRecipeNonCached(e.getItem(0));
                    }
                    boolean valid = e.canSmelt(irecipe);
                    if (!e.isBurning() && valid) {
                        if (itemstack.getItem() instanceof ItemHeater) {
                            int energy;
                            int z;
                            int y;
                            CompoundTag tag;
                            int x;
                            BlockEntity te;
                            CustomData data = (CustomData)itemstack.get(DataComponents.CUSTOM_DATA);
                            if (data != null && (te = level.getBlockEntity(new BlockPos(x = (tag = data.copyTag()).getInt("HeaterPosX"), y = tag.getInt("HeaterPosY"), z = tag.getInt("HeaterPosZ")))) != null && te instanceof BlockWirelessEnergyHeaterTile && (energy = ((BlockWirelessEnergyHeaterTile)te).getEnergy()) >= 2000) {
                                if (!e.getItem(4).isEmpty() && e.getItem(4).getItem() instanceof ItemAugmentFuel) {
                                    e.furnaceBurnTime = 400 * e.getCookTime() / 200;
                                } else if (!e.getItem(4).isEmpty() && e.getItem(4).getItem() instanceof ItemAugmentSpeed) {
                                    if (energy >= 4000) {
                                        e.furnaceBurnTime = 100 * e.getCookTime() / 200;
                                    }
                                } else {
                                    e.furnaceBurnTime = 200 * e.getCookTime() / 200;
                                }
                                if (e.furnaceBurnTime > 0) {
                                    ((BlockWirelessEnergyHeaterTile)te).removeEnergy(2000);
                                }
                                e.recipesUsed = e.furnaceBurnTime;
                            }
                        } else {
                            if (!e.getItem(4).isEmpty()) {
                                if (e.getItem(4).getItem() instanceof ItemAugmentFuel) {
                                    e.furnaceBurnTime = BlockIronFurnaceTileBase.getBurnTime(itemstack, e.recipeType) * e.getCookTime() / 200 * 2;
                                } else if (e.getItem(4).getItem() instanceof ItemAugmentSpeed) {
                                    e.furnaceBurnTime = BlockIronFurnaceTileBase.getBurnTime(itemstack, e.recipeType) * e.getCookTime() / 200 / 2;
                                }
                            } else {
                                e.furnaceBurnTime = BlockIronFurnaceTileBase.getBurnTime(itemstack, e.recipeType) * e.getCookTime() / 200;
                            }
                            e.recipesUsed = e.furnaceBurnTime;
                        }
                        if (e.isBurning()) {
                            flag1 = true;
                            if (!(itemstack.getItem() instanceof ItemHeater)) {
                                if (itemstack.hasCraftingRemainingItem()) {
                                    e.setItem(1, itemstack.getCraftingRemainingItem());
                                } else if (!itemstack.isEmpty()) {
                                    itemstack.shrink(1);
                                    if (itemstack.isEmpty()) {
                                        e.setItem(1, itemstack.getCraftingRemainingItem());
                                    }
                                }
                            }
                        }
                    }
                    if (e.isBurning() && valid) {
                        ++e.cookTime;
                        if (e.cookTime >= e.totalCookTime) {
                            e.cookTime = 0;
                            e.totalCookTime = e.getCookTime();
                            e.smelt(irecipe);
                            e.autoIO();
                            flag1 = true;
                        }
                    } else {
                        e.cookTime = 0;
                    }
                } else if (!e.isBurning() && e.cookTime > 0) {
                    e.cookTime = BlockIronFurnaceTileBase.clamp(e.cookTime - 2, 0, e.totalCookTime);
                }
                if (e.level.getGameTime() % 24L == 0L && e.cookTime <= 0) {
                    if (e.getItem(0).isEmpty()) {
                        e.autoIO();
                        flag1 = true;
                    } else if (e.getItem(0).getCount() < e.getItem(0).getMaxStackSize()) {
                        e.autoIO();
                        flag1 = true;
                    }
                    if (e.getItem(1).isEmpty()) {
                        e.autoIO();
                        flag1 = true;
                    } else if (e.getItem(1).getCount() < e.getItem(1).getMaxStackSize()) {
                        e.autoIO();
                        flag1 = true;
                    }
                    if (!e.getItem(2).isEmpty() && e.getItem(2).getCount() >= 64) {
                        e.autoIO();
                    }
                }
            }
            if (wasBurning != e.isBurning()) {
                level.setBlock(worldPosition, (BlockState)level.getBlockState(e.worldPosition).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(e.isBurning())), 3);
            }
            if (e.level.getGameTime() % 24L == 0L) {
                BlockState state = level.getBlockState(worldPosition);
                if (((Integer)state.getValue((Property)BlockIronFurnaceBase.TYPE)).intValue() != e.getStateType()) {
                    level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockIronFurnaceBase.TYPE, (Comparable)Integer.valueOf(e.getStateType())), 3);
                }
                if ((Integer)state.getValue((Property)BlockIronFurnaceBase.JOVIAL) != e.jovial) {
                    level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockIronFurnaceBase.JOVIAL, (Comparable)Integer.valueOf(e.jovial)), 3);
                }
            }
            if (flag1) {
                e.setChanged();
            }
        }
    }

    public static int clamp(int p_76125_0_, int p_76125_1_, int p_76125_2_) {
        if (p_76125_0_ < p_76125_1_) {
            return p_76125_1_;
        }
        return p_76125_0_ > p_76125_2_ ? p_76125_2_ : p_76125_0_;
    }

    protected int getCapacityFromTier() {
        return switch (this.getTier()) {
            case 1 -> (Integer)Config.furnaceEnergyCapacityTier1.get();
            case 2 -> (Integer)Config.furnaceEnergyCapacityTier2.get();
            default -> (Integer)Config.furnaceEnergyCapacityTier0.get();
        };
    }

    protected void rainbowEnergyOut() {
        HashMap tiles = Maps.newHashMap();
        for (Direction dir : Direction.values()) {
            IEnergyStorage other;
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.offset(dir.getNormal()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 || (other = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, tile.getBlockPos(), (Object)dir.getOpposite())) == null || !other.canReceive() || other.getEnergyStored() >= other.getMaxEnergyStored()) continue;
            tiles.put(tile, dir.getOpposite());
        }
        for (Map.Entry entry : tiles.entrySet()) {
            int energy = (Integer)Config.millionFurnacePowerToGenerate.get() / tiles.size();
            IEnergyStorage other = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, ((BlockEntity)entry.getKey()).getBlockPos(), (Object)((Direction)entry.getValue()));
            if (other == null) continue;
            other.receiveEnergy(energy, false);
        }
    }

    protected void energyOut() {
        HashMap tiles = Maps.newHashMap();
        for (Direction dir : Direction.values()) {
            IEnergyStorage other;
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.offset(dir.getNormal()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 || (other = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, tile.getBlockPos(), (Object)dir.getOpposite())) == null || !other.canReceive() || other.getEnergyStored() >= other.getMaxEnergyStored()) continue;
            tiles.put(tile, dir.getOpposite());
        }
        for (Map.Entry entry : tiles.entrySet()) {
            IEnergyStorage other = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, ((BlockEntity)entry.getKey()).getBlockPos(), (Object)((Direction)entry.getValue()));
            int energy = Math.min(this.energyStorage.getMaxExtract(), this.getEnergy());
            if (other == null) continue;
            this.removeEnergy(other.receiveEnergy(energy, false));
        }
    }

    protected void autoIO() {
        for (Direction dir : Direction.values()) {
            boolean check;
            ItemStack stack;
            int i;
            IItemHandler other;
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.offset(dir.getNormal()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 1 && this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 && this.furnaceSettings.get(dir.ordinal()) != 4 || tile == null || (other = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), (Object)dir.getOpposite())) == null || other == null || this.getAutoInput() == 0 && this.getAutoOutput() == 0) continue;
            if (this.getAutoInput() == 1) {
                if (this.furnaceSettings.get(dir.ordinal()) == 1 || this.furnaceSettings.get(dir.ordinal()) == 3) {
                    if (this.getItem(0).getCount() >= this.getItem(0).getMaxStackSize()) continue;
                    for (i = 0; i < other.getSlots(); ++i) {
                        if (other.getStackInSlot(i).isEmpty() || (!this.hasRecipe(stack = other.extractItem(i, other.getStackInSlot(i).getMaxStackSize(), true)) || !this.getItem(0).isEmpty()) && !ItemStack.isSameItemSameComponents((ItemStack)this.getItem(0), (ItemStack)stack)) continue;
                        this.insertItemInternal(0, other.extractItem(i, other.getStackInSlot(i).getMaxStackSize() - this.getItem(0).getCount(), false), false);
                    }
                }
                if (this.furnaceSettings.get(dir.ordinal()) == 4) {
                    if (this.getItem(1).getCount() >= this.getItem(1).getMaxStackSize()) continue;
                    for (i = 0; i < other.getSlots(); ++i) {
                        if (other.getStackInSlot(i).isEmpty() || !BlockIronFurnaceTileBase.isItemFuel(other.getStackInSlot(i), this.recipeType) || (!BlockIronFurnaceTileBase.isItemFuel(stack = other.extractItem(i, other.getStackInSlot(i).getMaxStackSize(), true), this.recipeType) || !this.getItem(1).isEmpty()) && !ItemStack.isSameItemSameComponents((ItemStack)this.getItem(1), (ItemStack)stack)) continue;
                        this.insertItemInternal(1, other.extractItem(i, other.getStackInSlot(i).getMaxStackSize() - this.getItem(1).getCount(), false), false);
                    }
                }
            }
            if (this.getAutoOutput() != 1) continue;
            if (this.furnaceSettings.get(dir.ordinal()) == 4) {
                if (this.getItem(1).isEmpty() || BlockIronFurnaceTileBase.isItemFuel(this.getItem(1), this.recipeType)) continue;
                for (i = 0; i < other.getSlots(); ++i) {
                    stack = this.extractItemInternal(1, other.getSlotLimit(i) - other.getStackInSlot(i).getCount(), true);
                    if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).getCount() + stack.getCount() > other.getSlotLimit(i)) || !(check = other.insertItem(i, this.extractItemInternal(1, stack.getCount(), true), true).isEmpty())) continue;
                    other.insertItem(i, this.extractItemInternal(1, stack.getCount(), false), false);
                }
            }
            if (this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 || this.getItem(2).isEmpty()) continue;
            for (i = 0; i < other.getSlots(); ++i) {
                stack = this.extractItemInternal(2, other.getSlotLimit(i) - other.getStackInSlot(i).getCount(), true);
                if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).getCount() + stack.getCount() > other.getSlotLimit(i)) || !(check = other.insertItem(i, this.extractItemInternal(2, stack.getCount(), true), true).isEmpty())) continue;
                other.insertItem(i, this.extractItemInternal(2, stack.getCount(), false), false);
            }
        }
    }

    protected void autoIOGenerator() {
        for (Direction dir : Direction.values()) {
            ItemStack stack;
            int i;
            IItemHandler other;
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.offset(dir.getNormal()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 4 || tile == null || (other = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), (Object)dir.getOpposite())) == null || other == null) continue;
            if (this.getAutoInput() != 0 && this.furnaceSettings.get(dir.ordinal()) == 4) {
                if (this.getItem(6).getCount() >= this.getItem(6).getMaxStackSize()) continue;
                for (i = 0; i < other.getSlots(); ++i) {
                    if (other.getStackInSlot(i).isEmpty() || other.getStackInSlot(i).getItem() == Items.BUCKET || (stack = other.extractItem(i, other.getStackInSlot(i).getMaxStackSize(), true)).getItem() instanceof ItemHeater || (!BlockIronFurnaceTileBase.isItemFuel(stack, this.recipeType) || !this.getItem(6).isEmpty()) && !ItemStack.isSameItemSameComponents((ItemStack)this.getItem(6), (ItemStack)stack)) continue;
                    this.insertItemInternal(6, other.extractItem(i, other.getStackInSlot(i).getMaxStackSize() - this.getItem(6).getCount(), false), false);
                }
            }
            if (this.getAutoOutput() == 0 || this.furnaceSettings.get(dir.ordinal()) != 4 || this.getItem(6).isEmpty() || BlockIronFurnaceTileBase.isItemFuel(this.getItem(6), this.recipeType)) continue;
            for (i = 0; i < other.getSlots(); ++i) {
                boolean check;
                stack = this.extractItemInternal(6, this.getItem(6).getMaxStackSize() - other.getStackInSlot(i).getCount(), true);
                if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).getCount() + stack.getCount() > other.getSlotLimit(i)) || !(check = other.insertItem(i, this.extractItemInternal(6, stack.getCount(), true), true).isEmpty())) continue;
                other.insertItem(i, this.extractItemInternal(6, stack.getCount(), false), false);
            }
        }
    }

    protected void autoFactoryIO() {
        for (Direction dir : Direction.values()) {
            ItemStack stack;
            int i;
            int j;
            int size;
            int start;
            IItemHandler other;
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.offset(dir.getNormal()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 1 && this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 || tile == null || (other = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), (Object)dir.getOpposite())) == null || other == null || this.getAutoInput() == 0 && this.getAutoOutput() == 0) continue;
            if (this.getAutoInput() == 1 && (this.furnaceSettings.get(dir.ordinal()) == 1 || this.furnaceSettings.get(dir.ordinal()) == 3)) {
                int n = this.getTier() == 0 ? 2 : (start = this.getTier() == 1 ? 1 : 0);
                size = this.getTier() == 0 ? 4 : (this.getTier() == 1 ? 5 : 6);
                for (j = start; j < size; ++j) {
                    if (this.getItem(FACTORY_INPUT[j]).getCount() >= this.getItem(FACTORY_INPUT[j]).getMaxStackSize()) continue;
                    for (i = 0; i < other.getSlots(); ++i) {
                        if (other.getStackInSlot(i).isEmpty() || (!this.hasRecipe(stack = other.extractItem(i, other.getStackInSlot(i).getMaxStackSize(), true)) || !this.getItem(FACTORY_INPUT[j]).isEmpty()) && !ItemStack.isSameItemSameComponents((ItemStack)this.getItem(FACTORY_INPUT[j]), (ItemStack)stack)) continue;
                        this.insertItemInternal(FACTORY_INPUT[j], other.extractItem(i, other.getStackInSlot(i).getMaxStackSize() - this.getItem(FACTORY_INPUT[j]).getCount(), false), false);
                    }
                }
            }
            if (this.getAutoOutput() != 1 || this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3) continue;
            int n = this.getTier() == 0 ? 2 : (start = this.getTier() == 1 ? 1 : 0);
            size = this.getTier() == 0 ? 4 : (this.getTier() == 1 ? 5 : 6);
            for (j = start; j < size; ++j) {
                if (this.getItem(FACTORY_INPUT[j] + 6).isEmpty()) continue;
                for (i = 0; i < other.getSlots(); ++i) {
                    boolean check;
                    stack = this.extractItemInternal(FACTORY_INPUT[j] + 6, other.getSlotLimit(i) - other.getStackInSlot(i).getCount(), true);
                    if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).getCount() + stack.getCount() > other.getSlotLimit(i)) || !(check = other.insertItem(i, this.extractItemInternal(FACTORY_INPUT[j] + 6, stack.getCount(), true), true).isEmpty())) continue;
                    other.insertItem(i, this.extractItemInternal(FACTORY_INPUT[j] + 6, stack.getCount(), false), false);
                }
            }
        }
    }

    @Nonnull
    public ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.canPlaceItemThroughFace(slot, stack, null)) {
            return stack;
        }
        ItemStack existing = this.getItem(slot);
        int limit = stack.getMaxStackSize();
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.setItem(slot, reachedLimit ? stack.copyWithCount(limit) : stack);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.setChanged();
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @Nonnull
    private ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = this.getItem(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.setItem(slot, ItemStack.EMPTY);
                this.setChanged();
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            this.setItem(slot, existing.copyWithCount(existing.getCount() - toExtract));
            this.setChanged();
        }
        return existing.copyWithCount(toExtract);
    }

    public boolean isAutoSplit() {
        return this.furnaceSettings.autoSplit == 1;
    }

    public int getSettingBottom() {
        return this.furnaceSettings.get(0);
    }

    public int getSettingTop() {
        return this.furnaceSettings.get(1);
    }

    public int getSettingFront() {
        int i = DirectionUtil.getId((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        return this.furnaceSettings.get(i);
    }

    public int getSettingBack() {
        int i = DirectionUtil.getId(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
        return this.furnaceSettings.get(i);
    }

    public int getSettingLeft() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (facing == Direction.NORTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.EAST));
        }
        if (facing == Direction.WEST) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.NORTH));
        }
        if (facing == Direction.SOUTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.WEST));
        }
        return this.furnaceSettings.get(DirectionUtil.getId(Direction.SOUTH));
    }

    public int getSettingRight() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (facing == Direction.NORTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.WEST));
        }
        if (facing == Direction.WEST) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.SOUTH));
        }
        if (facing == Direction.SOUTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.EAST));
        }
        return this.furnaceSettings.get(DirectionUtil.getId(Direction.NORTH));
    }

    public int getIndexFront() {
        int i = ((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).ordinal();
        return i;
    }

    public int getIndexBack() {
        int i = ((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite().ordinal();
        return i;
    }

    public int getIndexLeft() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (facing == Direction.NORTH) {
            return Direction.EAST.ordinal();
        }
        if (facing == Direction.WEST) {
            return Direction.NORTH.ordinal();
        }
        if (facing == Direction.SOUTH) {
            return Direction.WEST.ordinal();
        }
        return Direction.SOUTH.ordinal();
    }

    public int getIndexRight() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (facing == Direction.NORTH) {
            return Direction.WEST.ordinal();
        }
        if (facing == Direction.WEST) {
            return Direction.SOUTH.ordinal();
        }
        if (facing == Direction.SOUTH) {
            return Direction.EAST.ordinal();
        }
        return Direction.NORTH.ordinal();
    }

    public int getAutoInput() {
        return this.furnaceSettings.get(6);
    }

    public int getAugmentGUI() {
        return this.furnaceSettings.get(10);
    }

    public int getAutoOutput() {
        return this.furnaceSettings.get(7);
    }

    public int getRedstoneSetting() {
        return this.furnaceSettings.get(8);
    }

    public int getRedstoneComSub() {
        return this.furnaceSettings.get(9);
    }

    protected int getStateType() {
        if (this.getItem(3).getItem() == Registration.SMOKING_AUGMENT.get()) {
            return 1;
        }
        if (this.getItem(3).getItem() == Registration.BLASTING_AUGMENT.get()) {
            return 2;
        }
        return 0;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public boolean isRainbowFurnace() {
        return this instanceof BlockMillionFurnaceTile;
    }

    protected void smelt(@Nullable RecipeHolder<?> recipe) {
        if (this instanceof BlockMillionFurnaceTile) {
            this.smeltItemMult(recipe, 64);
        } else if (this instanceof BlockAllthemodiumFurnaceTile) {
            this.smeltItemMult(recipe, (Integer)Config.allthemodiumFurnaceSmeltMult.get());
        } else if (this instanceof BlockVibraniumFurnaceTile) {
            this.smeltItemMult(recipe, (Integer)Config.vibraniumFurnaceSmeltMult.get());
        } else if (this instanceof BlockUnobtainiumFurnaceTile) {
            this.smeltItemMult(recipe, (Integer)Config.unobtainiumFurnaceSmeltMult.get());
        } else {
            this.smeltItem(recipe);
        }
    }

    protected void factorySmelt(@Nullable RecipeHolder<?> recipe, int slot) {
        if (this instanceof BlockMillionFurnaceTile) {
            this.smeltFactoryItemMult(recipe, slot, 64);
        } else if (this instanceof BlockAllthemodiumFurnaceTile) {
            this.smeltFactoryItemMult(recipe, slot, (Integer)Config.allthemodiumFurnaceSmeltMult.get());
        } else if (this instanceof BlockVibraniumFurnaceTile) {
            this.smeltFactoryItemMult(recipe, slot, (Integer)Config.vibraniumFurnaceSmeltMult.get());
        } else if (this instanceof BlockUnobtainiumFurnaceTile) {
            this.smeltFactoryItemMult(recipe, slot, (Integer)Config.unobtainiumFurnaceSmeltMult.get());
        } else {
            this.smeltFactoryItem(recipe, slot);
        }
    }

    protected boolean canSmelt(@Nullable RecipeHolder<?> recipe) {
        ItemStack recipeOutput;
        if (!this.getItem(0).isEmpty() && recipe != null && !(recipeOutput = recipe.value().getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)).isEmpty()) {
            ItemStack output = this.getItem(2);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            return output.getCount() + recipeOutput.getCount() <= Math.min(output.getMaxStackSize(), 64);
        }
        return false;
    }

    protected void smeltItem(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = this.getItem(0);
            ItemStack itemstack1 = recipe.value().getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
            ItemStack itemstack2 = this.getItem(2);
            if (itemstack2.isEmpty()) {
                this.setItem(2, itemstack1.copy());
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (!this.level.isClientSide) {
                this.setRecipeUsed(recipe);
            }
            if (itemstack.getItem() == Blocks.WET_SPONGE.asItem() && !this.getItem(1).isEmpty() && this.getItem(1).getItem() == Items.BUCKET) {
                this.setItem(1, new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
        }
    }

    protected boolean canFactorySmelt(@Nullable RecipeHolder<?> recipe, int slot) {
        ItemStack recipeOutput;
        int outputSlot = slot + 6;
        if (!this.getItem(slot).isEmpty() && recipe != null && !(recipeOutput = recipe.value().getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)).isEmpty()) {
            ItemStack output = this.getItem(outputSlot);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            return output.getCount() + recipeOutput.getCount() <= output.getMaxStackSize();
        }
        return false;
    }

    protected void smeltFactoryItem(@Nullable RecipeHolder<?> recipe, int slot) {
        int outputSlot = slot + 6;
        if (recipe != null && this.canFactorySmelt(recipe, slot)) {
            ItemStack itemstack = this.getItem(slot);
            ItemStack itemstack1 = recipe.value().getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
            ItemStack itemstack2 = this.getItem(outputSlot);
            if (itemstack2.isEmpty()) {
                this.setItem(outputSlot, itemstack1.copy());
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (!this.level.isClientSide) {
                this.setRecipeUsed(recipe);
            }
            itemstack.shrink(1);
        }
    }

    protected void smeltItemMult(@Nullable RecipeHolder<?> recipe, int div) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = this.getItem(0);
            ItemStack itemstack1 = recipe.value().getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
            ItemStack itemstack2 = this.getItem(2);
            int maxCanSmelt = (64 - itemstack2.getCount()) / itemstack1.getCount();
            int wantToSmeltCount = Math.min(Math.min(div, maxCanSmelt), itemstack.getCount());
            int whenSmelted = itemstack1.getCount() * wantToSmeltCount;
            int decrement = whenSmelted / itemstack1.getCount();
            if (itemstack2.isEmpty()) {
                this.setItem(2, new ItemStack((ItemLike)itemstack1.copy().getItem(), whenSmelted));
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(whenSmelted);
            }
            if (!this.level.isClientSide) {
                for (int i = 0; i < decrement; ++i) {
                    this.setRecipeUsed(recipe);
                }
            }
            if (itemstack.getItem() == Blocks.WET_SPONGE.asItem() && !this.getItem(1).isEmpty() && this.getItem(1).getItem() == Items.BUCKET) {
                this.setItem(1, new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            itemstack.shrink(decrement);
        }
    }

    protected void smeltFactoryItemMult(@Nullable RecipeHolder<?> recipe, int slot, int div) {
        int outputSlot = slot + 6;
        if (recipe != null && this.canFactorySmelt(recipe, slot)) {
            ItemStack itemstack = this.getItem(slot);
            ItemStack itemstack1 = recipe.value().getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
            ItemStack itemstack2 = this.getItem(outputSlot);
            int maxCanSmelt = (64 - itemstack2.getCount()) / itemstack1.getCount();
            int wantToSmeltCount = Math.min(Math.min(div, maxCanSmelt), itemstack.getCount());
            int whenSmelted = itemstack1.getCount() * wantToSmeltCount;
            int decrement = whenSmelted / itemstack1.getCount();
            if (itemstack2.isEmpty()) {
                this.setItem(outputSlot, new ItemStack((ItemLike)itemstack1.copy().getItem(), whenSmelted));
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(whenSmelted);
            }
            if (!this.level.isClientSide) {
                for (int i = 0; i < decrement; ++i) {
                    this.setRecipeUsed(recipe);
                }
            }
            itemstack.shrink(decrement);
        }
    }

    private void handleSmeltedPMMO(ItemStack stack, Level level, BlockPos pos) {
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        int[] tagArr;
        int i;
        if (tag.get("Owner") != null) {
            this.owner = tag.getUUID("Owner");
        }
        tag.getBoolean("RainbowGen");
        for (i = 0; i < this.factoryCookTime.length; ++i) {
            tagArr = tag.getIntArray("FactoryCookTime");
            if (tagArr.length != this.factoryCookTime.length) continue;
            this.factoryCookTime[i] = tagArr[i];
        }
        for (i = 0; i < this.factoryTotalCookTime.length; ++i) {
            tagArr = tag.getIntArray("FactoryTotalCookTime");
            if (tagArr.length != this.factoryTotalCookTime.length) continue;
            this.factoryTotalCookTime[i] = tagArr[i];
        }
        for (i = 0; i < this.usedRF.length; ++i) {
            double tagRF;
            this.usedRF[i] = tagRF = tag.getDouble("UsedRF" + i);
        }
        this.generatorBurn = tag.getDouble("GeneratorBurn");
        this.generatorRecentRecipeRF = tag.getInt("GeneratorRecent");
        this.gottenRF = tag.getDouble("GottenRF");
        this.furnaceBurnTime = tag.getInt("BurnTime");
        this.cookTime = tag.getInt("CookTime");
        this.totalCookTime = tag.getInt("CookTimeTotal");
        this.currentAugment = tag.getIntArray("Augment");
        this.jovial = tag.getInt("Jovial");
        this.recipesUsed = BlockIronFurnaceTileBase.getBurnTime(this.getItem(1), this.recipeType);
        CompoundTag compoundtag = tag.getCompound("RecipesUsed");
        for (String s : compoundtag.getAllKeys()) {
            this.recipes.put((Object)ResourceLocation.parse((String)s), compoundtag.getInt(s));
        }
        this.furnaceSettings.read(tag);
        this.setEnergy(tag.getInt("Energy"));
        this.lastGameTickEnergyUpdated = 0L;
        super.loadAdditional(tag, provider);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.owner != null) {
            tag.putUUID("Owner", this.owner);
        }
        tag.putBoolean("RainbowGen", this.rainbowGenerating);
        tag.putIntArray("FactoryCookTime", this.factoryCookTime);
        tag.putIntArray("FactoryTotalCookTime", this.factoryTotalCookTime);
        for (int i = 0; i < this.usedRF.length; ++i) {
            tag.putDouble("UsedRF" + i, this.usedRF[i]);
        }
        tag.putDouble("GeneratorBurn", this.generatorBurn);
        tag.putInt("GeneratorRecent", this.generatorRecentRecipeRF);
        tag.putDouble("GottenRF", this.gottenRF);
        tag.putInt("BurnTime", this.furnaceBurnTime);
        tag.putInt("CookTime", this.cookTime);
        tag.putInt("CookTimeTotal", this.totalCookTime);
        tag.putIntArray("Augment", this.currentAugment);
        tag.putInt("Jovial", this.jovial);
        this.furnaceSettings.write(tag);
        tag.putInt("Energy", this.getEnergy());
        CompoundTag compoundtag = new CompoundTag();
        this.recipes.forEach((p_187449_, p_187450_) -> compoundtag.putInt(p_187449_.toString(), p_187450_.intValue()));
        tag.put("RecipesUsed", (Tag)compoundtag);
    }

    public static int getBurnTime(ItemStack stack, RecipeType recipeType) {
        return EventHooks.getItemBurnTime((ItemStack)stack, (int)stack.getBurnTime(recipeType), (RecipeType)recipeType);
    }

    public static boolean isItemFuel(ItemStack stack, RecipeType recipeType) {
        return BlockIronFurnaceTileBase.getBurnTime(stack, recipeType) > 0 || stack.getItem() instanceof ItemHeater;
    }

    public static boolean isItemAugment(ItemStack stack, int type) {
        if (type == 0) {
            return stack.getItem() instanceof ItemAugmentRed;
        }
        if (type == 1) {
            return stack.getItem() instanceof ItemAugmentGreen;
        }
        if (type == 2) {
            return stack.getItem() instanceof ItemAugmentBlue;
        }
        return stack.getItem() instanceof ItemAugment;
    }

    @Override
    public int[] IgetSlotsForFace(Direction side) {
        if (this.isFurnace()) {
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 0) {
                return new int[0];
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 1) {
                return new int[]{0, 1};
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 2) {
                return new int[]{2};
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 3) {
                return new int[]{0, 1, 2};
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 4) {
                return new int[]{1};
            }
        } else if (this.isGenerator()) {
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 4) {
                return new int[]{6};
            }
        } else if (this.isFactory()) {
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 0) {
                return new int[0];
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 1) {
                return FACTORY_INPUT;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 2) {
                return new int[]{13, 14, 15, 16, 17, 18};
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 3) {
                return new int[]{7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
            }
        }
        return new int[0];
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack, Direction direction) {
        if (this.isFurnace()) {
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 0) {
                return false;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 1) {
                return false;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 2) {
                return index == 2;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 3) {
                return index == 2;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.getItem() != Items.BUCKET) {
                return false;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.getItem() == Items.BUCKET) {
                return true;
            }
        } else if (this.isGenerator()) {
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.getItem() == Items.BUCKET) {
                return true;
            }
        } else if (this.isFactory()) {
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 2) {
                return index >= 13 && index <= 18;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 3) {
                return index >= 13 && index <= 18;
            }
        }
        return false;
    }

    @Override
    public boolean IisItemValidForSlot(int index, ItemStack stack) {
        if (this.isFurnace()) {
            if (index == 2 || index == 3 || index == 4 || index == 5) {
                return false;
            }
            if (index == 0) {
                if (stack.isEmpty()) {
                    return false;
                }
                return this.hasRecipe(stack);
            }
            if (index == 1) {
                ItemStack itemstack = this.getItem(1);
                return BlockIronFurnaceTileBase.getBurnTime(stack, this.recipeType) > 0 || stack.getItem() == Items.BUCKET && itemstack.getItem() != Items.BUCKET || stack.getItem() instanceof ItemHeater;
            }
        } else if (this.isGenerator()) {
            if (index == 6) {
                if (this.getItem(3).getItem() instanceof ItemAugmentSmoking && BlockIronFurnaceTileBase.getSmokingBurn(stack) > 0) {
                    return true;
                }
                if (this.getItem(3).getItem() instanceof ItemAugmentBlasting && this.hasGeneratorBlastingRecipe(stack)) {
                    return true;
                }
                if (this.getItem(3).isEmpty() && BlockIronFurnaceTileBase.getBurnTime(stack, this.recipeType) > 0) {
                    return true;
                }
                if (stack.getItem() instanceof ItemHeater) {
                    return false;
                }
            }
        } else if (this.isFactory()) {
            if (index >= 13 && index <= 18 || index == 3 || index == 4 || index == 5) {
                return false;
            }
            if (index >= 7 && index <= 12) {
                if (stack.isEmpty()) {
                    return false;
                }
                if (this.getTier() == 0) {
                    if (index >= 9 && index <= 10) {
                        return this.hasRecipe(stack);
                    }
                    return false;
                }
                if (this.getTier() == 1) {
                    if (index >= 8 && index <= 11) {
                        return this.hasRecipe(stack);
                    }
                    return false;
                }
                return this.hasRecipe(stack);
            }
        }
        return false;
    }

    public void setJovial(int value) {
        this.jovial = value;
    }

    public int getXpNeededForNextLevel(int experienceLevel) {
        if (experienceLevel >= 30) {
            return 112 + (experienceLevel - 30) * 9;
        }
        return experienceLevel >= 15 ? 37 + (experienceLevel - 15) * 5 : 7 + experienceLevel * 2;
    }

    public int getXpNeededForLevel(int level) {
        int xp = 0;
        for (int i = 0; i < level; ++i) {
            xp += this.getXpNeededForNextLevel(i);
        }
        return xp + 1;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.id();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void unlockRecipes(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.grantStoredRecipeExperience(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            player.triggerRecipeCrafted(recipeholder, (List)this.inventory);
        }
        this.recipes.clear();
    }

    public List<RecipeHolder<?>> grantStoredRecipeExperience(ServerLevel level, Vec3 worldPosition) {
        ArrayList list = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(h -> {
                list.add((RecipeHolder<?>)h);
                BlockIronFurnaceTileBase.splitAndSpawnExperience(level, worldPosition, entry.getIntValue(), ((AbstractCookingRecipe)h.value()).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 worldPosition, int craftedAmount, float experience) {
        int i = Mth.floor((float)((float)craftedAmount * experience));
        float f = Mth.frac((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)worldPosition, (int)i);
    }

    public void fillStackedContents(StackedContents helper) {
        for (ItemStack itemstack : this.inventory) {
            helper.accountStack(itemstack);
        }
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
    }

    public void placeConfig() {
        if (this.furnaceSettings != null) {
            this.furnaceSettings.set(0, 2);
            this.furnaceSettings.set(1, 1);
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN || dir == Direction.UP) continue;
                this.furnaceSettings.set(dir.ordinal(), 4);
            }
            this.level.markAndNotifyBlock(this.worldPosition, this.level.getChunkAt(this.worldPosition), this.level.getBlockState(this.worldPosition).getBlock().defaultBlockState(), this.level.getBlockState(this.worldPosition), 3, 3);
        }
    }

    public boolean isGenerator() {
        return this.currentAugment[2] == 2;
    }

    public boolean isFactory() {
        return this.currentAugment[2] == 1;
    }

    public boolean isFurnace() {
        return this.currentAugment[2] == 0;
    }

    public int getTier() {
        return 0;
    }
}

