/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table.core;

import com.mojang.blaze3d.systems.RenderSystem;
import neoforge.com.cursee.disenchanting_table.DisenchantingTable;
import neoforge.com.cursee.disenchanting_table.core.DisenchantingTableMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class DisenchantingTableScreen
extends AbstractContainerScreen<DisenchantingTableMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"disenchanting_table", (String)"textures/gui/container/disenchanting.png");
    @NotNull
    private final Player player;
    @NotNull
    private final DisenchantingTableMenu menu;
    private int playerExperienceLevels;

    public DisenchantingTableScreen(@NotNull DisenchantingTableMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.menu = menu;
        this.player = inventory.player;
    }

    protected void init() {
        super.init();
        this.titleLabelY += 9999;
        this.inventoryLabelY += 9999;
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, 0, 0, 0.0f);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        if (this.minecraft != null && this.minecraft.player != null && DisenchantingTable.experienceIsRequired) {
            LocalPlayer player = this.minecraft.player;
            if (!player.getAbilities().instabuild) {
                int color = -40864;
                MutableComponent component = Component.literal((String)"Cost: 5 Levels");
                if (player.experienceLevel >= 5) {
                    color = -10420384;
                }
                int minimumX = this.imageWidth - this.font.width((FormattedText)component) - 10;
                int textBGTopLeftY = 67;
                int xMod = 1;
                int yMod = 4;
                graphics.fill(minimumX - 2 + xMod, textBGTopLeftY + yMod, this.imageWidth - 8 + xMod, 79 + yMod, -12242305);
                graphics.drawString(this.font, (Component)component, minimumX + xMod, textBGTopLeftY + 2 + yMod, color);
            }
        }
    }
}

