/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table.core;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Predicate;
import neoforge.com.cursee.disenchanting_table.DisenchantingTable;
import neoforge.com.cursee.disenchanting_table.DisenchantingTableNeoForge;
import neoforge.com.cursee.disenchanting_table.core.DisenchantingTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisenchantingTableBlockEntity
extends BlockEntity
implements MenuProvider,
IAttachmentHolder {
    protected static final int TOTAL_SLOTS = 3;
    protected static final int ITEM_INPUT_SLOT = 0;
    protected static final int BOOK_INPUT_SLOT = 1;
    protected static final int OUTPUT_SLOT = 2;
    public static final BlockCapability<Capabilities.ItemHandler, Void> ITEM_HANDLER_NO_CONTEXT = BlockCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"disenchanting_table", (String)"item_handler_no_context"), Capabilities.ItemHandler.class);
    public final IItemHandlerModifiable handler = new IItemHandlerModifiable(){

        public void setStackInSlot(int i, ItemStack itemStack) {
            DisenchantingTableBlockEntity.this.itemStackHandler.setStackInSlot(i, itemStack);
        }

        public int getSlots() {
            return 3;
        }

        public ItemStack getStackInSlot(int i) {
            return DisenchantingTableBlockEntity.this.itemStackHandler.getStackInSlot(i);
        }

        public ItemStack insertItem(int i, ItemStack itemStack, boolean b) {
            return DisenchantingTableBlockEntity.this.itemStackHandler.insertItem(i, itemStack, b);
        }

        public ItemStack extractItem(int index, int amount, boolean simulate) {
            return DisenchantingTableBlockEntity.this.itemStackHandler.extractItem(index, amount, simulate);
        }

        public int getSlotLimit(int i) {
            return DisenchantingTableBlockEntity.this.itemStackHandler.getSlotLimit(i);
        }

        public boolean isItemValid(int i, ItemStack itemStack) {
            return DisenchantingTableBlockEntity.this.itemStackHandler.isItemValid(i, itemStack);
        }
    };
    private int progress = 0;
    private int maxProgress = 10;
    protected final ContainerData data;
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            DisenchantingTableBlockEntity.super.setChanged();
            if (DisenchantingTableBlockEntity.this.level != null && !DisenchantingTableBlockEntity.this.level.isClientSide()) {
                DisenchantingTableBlockEntity.this.level.sendBlockUpdated(DisenchantingTableBlockEntity.this.getBlockPos(), DisenchantingTableBlockEntity.this.getBlockState(), DisenchantingTableBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> EnchantmentHelper.hasAnyEnchantments((ItemStack)stack);
                case 1 -> {
                    if (stack.getItem() == Items.BOOK) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };

    public DisenchantingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DisenchantingTableNeoForge.DISENCHANTING_TABLE_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> DisenchantingTableBlockEntity.this.progress;
                    case 1 -> DisenchantingTableBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        DisenchantingTableBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        DisenchantingTableBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void drops() {
        if (this.level != null) {
            SimpleContainer inventory = new SimpleContainer(this.itemStackHandler.getSlots());
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                inventory.setItem(i, this.itemStackHandler.getStackInSlot(i));
            }
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
        }
    }

    public Component getDisplayName() {
        return Component.literal((String)"Dis-Enchanting Table");
    }

    public AbstractContainerMenu createMenu(int containerID, Inventory inventory, Player player) {
        return new DisenchantingTableMenu(containerID, inventory, this, this.data);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider holder) {
        return this.saveWithoutMetadata(holder);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider holder) {
        pTag.put("inventory", (Tag)this.itemStackHandler.serializeNBT(holder));
        pTag.putInt("disenchanting_table.progress", this.progress);
        pTag.putInt("disenchanting_table.max_progress", this.maxProgress);
        super.saveAdditional(pTag, holder);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider holder) {
        super.loadAdditional(pTag, holder);
        this.itemStackHandler.deserializeNBT(holder, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("disenchanting_table.progress");
        this.maxProgress = pTag.getInt("disenchanting_table.max_progress");
    }

    private boolean hasProperInput() {
        return EnchantmentHelper.hasAnyEnchantments((ItemStack)this.itemStackHandler.getStackInSlot(0)) && this.itemStackHandler.getStackInSlot(1).getItem() == Items.BOOK;
    }

    private boolean outputSlotIsEmpty() {
        return this.itemStackHandler.getStackInSlot(2).isEmpty();
    }

    private static boolean takeExperienceFromNearestPlayer(Level level, BlockPos pos) {
        if (!DisenchantingTable.experienceIsRequired) {
            return true;
        }
        @Nullable ServerPlayer player = (ServerPlayer)level.getNearestPlayer(TargetingConditions.forNonCombat(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (player != null && player.getAbilities().instabuild) {
            return true;
        }
        if (player != null && !player.getAbilities().instabuild && player.experienceLevel >= 5) {
            player.setExperienceLevels(player.experienceLevel - 5);
            return true;
        }
        return false;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level == null || level.isClientSide()) {
            return;
        }
        if (this.hasProperInput() && this.outputSlotIsEmpty()) {
            ++this.progress;
            DisenchantingTableBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.progress >= this.maxProgress) {
                this.craftItem(level, pos, state);
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
    }

    private void craftItem(Level level, BlockPos pos, BlockState state) {
        ItemStack input = this.itemStackHandler.getStackInSlot(0);
        if (input.getItem() == Items.ENCHANTED_BOOK) {
            ItemEnchantments enchantments = (ItemEnchantments)input.getComponents().get(DataComponents.STORED_ENCHANTMENTS);
            if (enchantments != null && enchantments.size() >= 2) {
                ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enchantments);
                if (!DisenchantingTableBlockEntity.takeExperienceFromNearestPlayer(level, pos)) {
                    return;
                }
                Object2IntMap.Entry[] extractedEnchantmentEntry = new Object2IntMap.Entry[1];
                enchantments.entrySet().forEach(holderEntry -> {
                    extractedEnchantmentEntry[0] = holderEntry;
                });
                EnchantmentInstance extractedEnchantmentInstance = new EnchantmentInstance((Holder)extractedEnchantmentEntry[0].getKey(), extractedEnchantmentEntry[0].getIntValue());
                mutable.removeIf(Predicate.isEqual(extractedEnchantmentEntry[0].getKey()));
                EnchantmentHelper.setEnchantments((ItemStack)input, (ItemEnchantments)mutable.toImmutable());
                this.itemStackHandler.setStackInSlot(0, input);
                this.itemStackHandler.extractItem(1, 1, false);
                this.itemStackHandler.setStackInSlot(2, EnchantedBookItem.createForEnchantment((EnchantmentInstance)extractedEnchantmentInstance));
            }
        } else {
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(input.getEnchantments());
            if (!DisenchantingTableBlockEntity.takeExperienceFromNearestPlayer(level, pos)) {
                return;
            }
            this.itemStackHandler.extractItem(1, 1, false);
            ItemStack returnedEnchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantmentHelper.setEnchantments((ItemStack)returnedEnchantedBook, (ItemEnchantments)mutable.toImmutable());
            EnchantmentHelper.setEnchantments((ItemStack)input, (ItemEnchantments)ItemEnchantments.EMPTY);
            this.itemStackHandler.setStackInSlot(2, returnedEnchantedBook);
            this.itemStackHandler.setStackInSlot(0, input);
        }
    }
}

