/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table;

import com.cursee.monolib.platform.Services;
import com.cursee.monolib.util.toml.Toml;
import com.cursee.monolib.util.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import neoforge.com.cursee.disenchanting_table.Constants;
import neoforge.com.cursee.disenchanting_table.DisenchantingTable;

public class ConfigNeoForge {
    public static final File CONFIG_DIRECTORY = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
    public static final String CONFIG_FILEPATH = String.valueOf(CONFIG_DIRECTORY) + File.separator + "disenchanting_table.toml";
    public static boolean experienceIsRequired = true;
    public static final Map<String, Object> defaults = new HashMap<String, Object>();

    public static void initialize() {
        defaults.put("experienceIsRequired", experienceIsRequired);
        DisenchantingTable.experienceIsRequired = experienceIsRequired;
        if (!CONFIG_DIRECTORY.isDirectory()) {
            CONFIG_DIRECTORY.mkdir();
        }
        File CONFIG_FILE = new File(CONFIG_FILEPATH);
        ConfigNeoForge.handle(CONFIG_FILE);
    }

    public static void handle(File file) {
        boolean FILE_NOT_FOUND;
        boolean bl = FILE_NOT_FOUND = !file.isFile();
        if (FILE_NOT_FOUND) {
            try {
                TomlWriter writer = new TomlWriter();
                writer.write(defaults, file);
            }
            catch (IOException exception) {
                Constants.LOG.error("Fatal error occurred while attempting to write disenchanting_table.toml");
                Constants.LOG.error("Did another process delete the config directory during writing?");
                Constants.LOG.error(exception.getMessage());
            }
        } else {
            try {
                Toml toml = new Toml().read(file);
                DisenchantingTable.experienceIsRequired = experienceIsRequired = toml.getBoolean("experienceIsRequired").booleanValue();
            }
            catch (IllegalStateException exception) {
                Constants.LOG.error("Fatal error occurred while attempting to read disenchanting_table.toml");
                Constants.LOG.error("Did another process delete the file during reading?");
                Constants.LOG.error(exception.getMessage());
            }
        }
    }
}

