/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core;

import forge.com.cursee.disenchanting_table.DisenchantingTableForge;
import forge.com.cursee.disenchanting_table.core.DisenchantingTableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;

public class DisenchantingTableMenu
extends AbstractContainerMenu {
    private final Level level;
    public final int cost = 5;
    private final ContainerData data;
    public boolean playerCanAfford = false;
    private final DisenchantingTableBlockEntity entity;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TILE_ENTITY_INVENTORY_FIRST_SLOT_INDEX = 36;

    public DisenchantingTableMenu(int containerID, Inventory inventory, FriendlyByteBuf buffer) {
        this(containerID, inventory, inventory.f_35978_.m_9236_().m_7702_(buffer.m_130135_()), (ContainerData)new SimpleContainerData(2));
    }

    public DisenchantingTableMenu(int containerID, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)DisenchantingTableForge.DISENCHANTING_TABLE_MENU.get(), containerID);
        DisenchantingTableMenu.m_38869_((Container)inventory, (int)3);
        this.data = data;
        this.level = inventory.f_35978_.m_9236_();
        this.entity = (DisenchantingTableBlockEntity)entity;
        this.playerCanAfford = inventory.f_35978_.f_36078_ >= 5;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.entity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 27, 47));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 76, 47));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 134, 47));
        });
        this.m_38884_(data);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean m_6875_(Player pPlayer) {
        return DisenchantingTableMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.entity.m_58899_()), (Player)pPlayer, (Block)((Block)DisenchantingTableForge.DISENCHANTING_TABLE_BLOCK.get()));
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack stackCopy = stack.m_41777_();
        if (slotIndex < 36) {
            if (!this.m_38903_(stack, 36, 39, false)) {
                return ItemStack.f_41583_;
            }
        } else if (slotIndex < 39) {
            if (!this.m_38903_(stack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + slotIndex);
            return ItemStack.f_41583_;
        }
        if (stack.m_41613_() == 0) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(player, stack);
        return stackCopy;
    }
}

