/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.golden_foods.mixin;

import neoforge.com.cursee.golden_foods.core.item.ForgeItems;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FishingHook.class})
public abstract class NeoForgeFishingHookMixin {
    @Shadow
    @Nullable
    public abstract Player getPlayerOwner();

    @Redirect(method={"retrieve"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z", ordinal=0))
    boolean injected(Level instance, Entity entity) {
        float localRandom = instance.random.nextFloat();
        ItemEntity original = (ItemEntity)entity;
        if (this.getPlayerOwner() != null && localRandom <= 1.0f) {
            Player player = this.getPlayerOwner();
            boolean has_enchantment = false;
            ItemEnchantments enchantmentsFound = player.getItemInHand(InteractionHand.MAIN_HAND).getEnchantments();
            for (Holder holder : enchantmentsFound.keySet()) {
                if (!holder.getRegisteredName().toLowerCase().contains("golden_food") && !holder.getRegisteredName().toLowerCase().contains("golden food")) continue;
                has_enchantment = true;
            }
            if (!has_enchantment) {
                return instance.addFreshEntity(entity);
            }
            if (original.getItem().is(Items.COD)) {
                ItemEntity enchantedGoldenCodItemEntity = new ItemEntity(((FishingHook)this).level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)ForgeItems.ENCHANTED_GOLDEN_COOKED_COD.get()));
                return instance.addFreshEntity((Entity)enchantedGoldenCodItemEntity);
            }
            if (original.getItem().is(Items.SALMON)) {
                ItemEntity enchantedGoldenSalmonItemEntity = new ItemEntity(((FishingHook)this).level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)ForgeItems.ENCHANTED_GOLDEN_COOKED_SALMON.get()));
                return instance.addFreshEntity((Entity)enchantedGoldenSalmonItemEntity);
            }
        }
        return instance.addFreshEntity(entity);
    }
}

