/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.golden_foods.core.item.custom;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ChorusFruitItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class GoldenChorusFruitItem
extends ChorusFruitItem {
    public GoldenChorusFruitItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        ItemStack itemStack2 = super.finishUsingItem(itemStack, level, livingEntity);
        if (!level.isClientSide) {
            double d = livingEntity.getX();
            double e = livingEntity.getY();
            double f = livingEntity.getZ();
            for (int i = 0; i < 16; ++i) {
                double g = livingEntity.getX() + (livingEntity.getRandom().nextDouble() - 0.5) * 16.0;
                double h = Mth.clamp((double)(livingEntity.getY() + (double)(livingEntity.getRandom().nextInt(16) - 8)), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + ((ServerLevel)level).getLogicalHeight() - 1));
                double j = livingEntity.getZ() + (livingEntity.getRandom().nextDouble() - 0.5) * 16.0;
                if (livingEntity.isPassenger()) {
                    livingEntity.stopRiding();
                }
                Vec3 vec3 = livingEntity.position();
                if (!livingEntity.randomTeleport(g, h, j, true)) continue;
                level.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)livingEntity));
                SoundEvent soundEvent = livingEntity instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
                level.playSound((Player)null, d, e, f, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                livingEntity.playSound(soundEvent, 1.0f, 1.0f);
                break;
            }
            if (livingEntity instanceof Player) {
                ((Player)livingEntity).getCooldowns().addCooldown((Item)this, 20);
            }
        }
        return itemStack2;
    }
}

