/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.golden_foods.core.item.custom;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ChorusFruitItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class ModChorusFruitItem
extends ChorusFruitItem {
    public ModChorusFruitItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack itemstack = super.finishUsingItem(stack, level, entity);
        if (!level.isClientSide) {
            double d0 = entity.getX();
            double d1 = entity.getY();
            double d2 = entity.getZ();
            for (int i = 0; i < 32; ++i) {
                double d3 = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 32.0;
                double d4 = Mth.clamp((double)(entity.getY() + (double)(entity.getRandom().nextInt(32) - 8)), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + ((ServerLevel)level).getLogicalHeight() - 1));
                double d5 = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 32.0;
                if (entity.isPassenger()) {
                    entity.stopRiding();
                }
                Vec3 vec3 = entity.position();
                level.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)entity));
                EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)entity, (double)d3, (double)d4, (double)d5);
                if (event.isCanceled()) {
                    return itemstack;
                }
                if (!entity.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                SoundEvent soundevent = entity instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
                level.playSound((Player)null, d0, d1, d2, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.playSound(soundevent, 1.0f, 1.0f);
                break;
            }
            if (entity instanceof Player) {
                ((Player)entity).getCooldowns().addCooldown((Item)this, 10);
            }
        }
        return itemstack;
    }
}

