/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SetStewEffectFunction
extends LootItemConditionalFunction {
    private static final Codec<List<EffectEntry>> EFFECTS_LIST = EffectEntry.CODEC.listOf().validate(p_298165_ -> {
        ObjectOpenHashSet $$1 = new ObjectOpenHashSet();
        for (EffectEntry $$2 : p_298165_) {
            if ($$1.add($$2.effect())) continue;
            return DataResult.error(() -> "Encountered duplicate mob effect: '" + String.valueOf($$2.effect()) + "'");
        }
        return DataResult.success((Object)p_298165_);
    });
    public static final MapCodec<SetStewEffectFunction> CODEC = RecordCodecBuilder.mapCodec(p_338164_ -> SetStewEffectFunction.commonFields(p_338164_).and((App)EFFECTS_LIST.optionalFieldOf("effects", List.of()).forGetter(p_298162_ -> p_298162_.effects)).apply((Applicative)p_338164_, SetStewEffectFunction::new));
    private final List<EffectEntry> effects;

    SetStewEffectFunction(List<LootItemCondition> p_298938_, List<EffectEntry> p_298439_) {
        super(p_298938_);
        this.effects = p_298439_;
    }

    public LootItemFunctionType<SetStewEffectFunction> getType() {
        return LootItemFunctions.SET_STEW_EFFECT;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return (Set)this.effects.stream().flatMap(p_298164_ -> p_298164_.duration().getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack p_81223_, LootContext p_81224_) {
        if (!p_81223_.is(Items.SUSPICIOUS_STEW) || this.effects.isEmpty()) {
            return p_81223_;
        }
        EffectEntry $$2 = Util.getRandom(this.effects, p_81224_.getRandom());
        Holder<MobEffect> $$3 = $$2.effect();
        int $$4 = $$2.duration().getInt(p_81224_);
        if (!$$3.value().isInstantenous()) {
            $$4 *= 20;
        }
        SuspiciousStewEffects.Entry $$5 = new SuspiciousStewEffects.Entry($$3, $$4);
        p_81223_.update(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY, $$5, SuspiciousStewEffects::withEffectAdded);
        return p_81223_;
    }

    public static Builder stewEffect() {
        return new Builder();
    }

    record EffectEntry(Holder<MobEffect> effect, NumberProvider duration) {
        public static final Codec<EffectEntry> CODEC = RecordCodecBuilder.create(p_348461_ -> p_348461_.group((App)MobEffect.CODEC.fieldOf("type").forGetter(EffectEntry::effect), (App)NumberProviders.CODEC.fieldOf("duration").forGetter(EffectEntry::duration)).apply((Applicative)p_348461_, EffectEntry::new));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final ImmutableList.Builder<EffectEntry> effects = ImmutableList.builder();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEffect(Holder<MobEffect> p_316210_, NumberProvider p_165474_) {
            this.effects.add((Object)new EffectEntry(p_316210_, p_165474_));
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetStewEffectFunction(this.getConditions(), (List<EffectEntry>)this.effects.build());
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

