/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;

public class PistonStructureResolver {
    public static final int MAX_PUSH_DEPTH = 12;
    private final Level level;
    private final BlockPos pistonPos;
    private final boolean extending;
    private final BlockPos startPos;
    private final Direction pushDirection;
    private final List<BlockPos> toPush = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();
    private final Direction pistonDirection;

    public PistonStructureResolver(Level p_60418_, BlockPos p_60419_, Direction p_60420_, boolean p_60421_) {
        this.level = p_60418_;
        this.pistonPos = p_60419_;
        this.pistonDirection = p_60420_;
        this.extending = p_60421_;
        if (p_60421_) {
            this.pushDirection = p_60420_;
            this.startPos = p_60419_.relative(p_60420_);
        } else {
            this.pushDirection = p_60420_.getOpposite();
            this.startPos = p_60419_.relative(p_60420_, 2);
        }
    }

    public boolean resolve() {
        this.toPush.clear();
        this.toDestroy.clear();
        BlockState $$0 = this.level.getBlockState(this.startPos);
        if (!PistonBaseBlock.isPushable($$0, this.level, this.startPos, this.pushDirection, false, this.pistonDirection)) {
            if (this.extending && $$0.getPistonPushReaction() == PushReaction.DESTROY) {
                this.toDestroy.add(this.startPos);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.startPos, this.pushDirection)) {
            return false;
        }
        for (int $$1 = 0; $$1 < this.toPush.size(); ++$$1) {
            BlockPos $$2 = this.toPush.get($$1);
            if (!PistonStructureResolver.isSticky(this.level.getBlockState($$2)) || this.addBranchingBlocks($$2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSticky(BlockState p_155938_) {
        return p_155938_.is(Blocks.SLIME_BLOCK) || p_155938_.is(Blocks.HONEY_BLOCK);
    }

    private static boolean canStickToEachOther(BlockState p_155940_, BlockState p_155941_) {
        if (p_155940_.is(Blocks.HONEY_BLOCK) && p_155941_.is(Blocks.SLIME_BLOCK)) {
            return false;
        }
        if (p_155940_.is(Blocks.SLIME_BLOCK) && p_155941_.is(Blocks.HONEY_BLOCK)) {
            return false;
        }
        return PistonStructureResolver.isSticky(p_155940_) || PistonStructureResolver.isSticky(p_155941_);
    }

    private boolean addBlockLine(BlockPos p_60434_, Direction p_60435_) {
        BlockState $$2 = this.level.getBlockState(p_60434_);
        if ($$2.isAir()) {
            return true;
        }
        if (!PistonBaseBlock.isPushable($$2, this.level, p_60434_, this.pushDirection, false, p_60435_)) {
            return true;
        }
        if (p_60434_.equals(this.pistonPos)) {
            return true;
        }
        if (this.toPush.contains(p_60434_)) {
            return true;
        }
        int $$3 = 1;
        if ($$3 + this.toPush.size() > 12) {
            return false;
        }
        while (PistonStructureResolver.isSticky($$2)) {
            BlockPos $$4 = p_60434_.relative(this.pushDirection.getOpposite(), $$3);
            BlockState $$5 = $$2;
            $$2 = this.level.getBlockState($$4);
            if ($$2.isAir() || !PistonStructureResolver.canStickToEachOther($$5, $$2) || !PistonBaseBlock.isPushable($$2, this.level, $$4, this.pushDirection, false, this.pushDirection.getOpposite()) || $$4.equals(this.pistonPos)) break;
            if (++$$3 + this.toPush.size() <= 12) continue;
            return false;
        }
        int $$6 = 0;
        for (int $$7 = $$3 - 1; $$7 >= 0; --$$7) {
            this.toPush.add(p_60434_.relative(this.pushDirection.getOpposite(), $$7));
            ++$$6;
        }
        int $$8 = 1;
        while (true) {
            BlockPos $$9;
            int $$10;
            if (($$10 = this.toPush.indexOf($$9 = p_60434_.relative(this.pushDirection, $$8))) > -1) {
                this.reorderListAtCollision($$6, $$10);
                for (int $$11 = 0; $$11 <= $$10 + $$6; ++$$11) {
                    BlockPos $$12 = this.toPush.get($$11);
                    if (!PistonStructureResolver.isSticky(this.level.getBlockState($$12)) || this.addBranchingBlocks($$12)) continue;
                    return false;
                }
                return true;
            }
            $$2 = this.level.getBlockState($$9);
            if ($$2.isAir()) {
                return true;
            }
            if (!PistonBaseBlock.isPushable($$2, this.level, $$9, this.pushDirection, true, this.pushDirection) || $$9.equals(this.pistonPos)) {
                return false;
            }
            if ($$2.getPistonPushReaction() == PushReaction.DESTROY) {
                this.toDestroy.add($$9);
                return true;
            }
            if (this.toPush.size() >= 12) {
                return false;
            }
            this.toPush.add($$9);
            ++$$6;
            ++$$8;
        }
    }

    private void reorderListAtCollision(int p_60424_, int p_60425_) {
        ArrayList $$2 = Lists.newArrayList();
        ArrayList $$3 = Lists.newArrayList();
        ArrayList $$4 = Lists.newArrayList();
        $$2.addAll(this.toPush.subList(0, p_60425_));
        $$3.addAll(this.toPush.subList(this.toPush.size() - p_60424_, this.toPush.size()));
        $$4.addAll(this.toPush.subList(p_60425_, this.toPush.size() - p_60424_));
        this.toPush.clear();
        this.toPush.addAll($$2);
        this.toPush.addAll($$3);
        this.toPush.addAll($$4);
    }

    private boolean addBranchingBlocks(BlockPos p_60432_) {
        BlockState $$1 = this.level.getBlockState(p_60432_);
        for (Direction $$2 : Direction.values()) {
            BlockPos $$3;
            BlockState $$4;
            if ($$2.getAxis() == this.pushDirection.getAxis() || !PistonStructureResolver.canStickToEachOther($$4 = this.level.getBlockState($$3 = p_60432_.relative($$2)), $$1) || this.addBlockLine($$3, $$2)) continue;
            return false;
        }
        return true;
    }

    public Direction getPushDirection() {
        return this.pushDirection;
    }

    public List<BlockPos> getToPush() {
        return this.toPush;
    }

    public List<BlockPos> getToDestroy() {
        return this.toDestroy;
    }
}

