/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShulkerBoxBlock
extends BaseEntityBlock {
    public static final MapCodec<ShulkerBoxBlock> CODEC = RecordCodecBuilder.mapCodec(p_308835_ -> p_308835_.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(p_304373_ -> Optional.ofNullable(p_304373_.color)), ShulkerBoxBlock.propertiesCodec()).apply((Applicative)p_308835_, (p_304374_, p_304375_) -> new ShulkerBoxBlock(p_304374_.orElse(null), (BlockBehaviour.Properties)p_304375_)));
    private static final Component UNKNOWN_CONTENTS = Component.translatable("container.shulkerBox.unknownContents");
    private static final float OPEN_AABB_SIZE = 1.0f;
    private static final VoxelShape UP_OPEN_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape DOWN_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape WES_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_OPEN_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_OPEN_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<Direction, VoxelShape> OPEN_SHAPE_BY_DIRECTION = Util.make(Maps.newEnumMap(Direction.class), p_258974_ -> {
        p_258974_.put(Direction.NORTH, NORTH_OPEN_AABB);
        p_258974_.put(Direction.EAST, EAST_OPEN_AABB);
        p_258974_.put(Direction.SOUTH, SOUTH_OPEN_AABB);
        p_258974_.put(Direction.WEST, WES_OPEN_AABB);
        p_258974_.put(Direction.UP, UP_OPEN_AABB);
        p_258974_.put(Direction.DOWN, DOWN_OPEN_AABB);
    });
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    public static final ResourceLocation CONTENTS = ResourceLocation.withDefaultNamespace("contents");
    @Nullable
    private final DyeColor color;

    public MapCodec<ShulkerBoxBlock> codec() {
        return CODEC;
    }

    public ShulkerBoxBlock(@Nullable DyeColor p_56188_, BlockBehaviour.Properties p_56189_) {
        super(p_56189_);
        this.color = p_56188_;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.UP));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_154552_, BlockState p_154553_) {
        return new ShulkerBoxBlockEntity(this.color, p_154552_, p_154553_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_154543_, BlockState p_154544_, BlockEntityType<T> p_154545_) {
        return ShulkerBoxBlock.createTickerHelper(p_154545_, BlockEntityType.SHULKER_BOX, ShulkerBoxBlockEntity::tick);
    }

    @Override
    protected RenderShape getRenderShape(BlockState p_56255_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_56227_, Level p_56228_, BlockPos p_56229_, Player p_56230_, BlockHitResult p_56232_) {
        if (p_56228_.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (p_56230_.isSpectator()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity $$5 = p_56228_.getBlockEntity(p_56229_);
        if ($$5 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity $$6 = (ShulkerBoxBlockEntity)$$5;
            if (ShulkerBoxBlock.canOpen(p_56227_, p_56228_, p_56229_, $$6)) {
                p_56230_.openMenu($$6);
                p_56230_.awardStat(Stats.OPEN_SHULKER_BOX);
                PiglinAi.angerNearbyPiglins(p_56230_, true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static boolean canOpen(BlockState p_154547_, Level p_154548_, BlockPos p_154549_, ShulkerBoxBlockEntity p_154550_) {
        if (p_154550_.getAnimationStatus() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB $$4 = Shulker.getProgressDeltaAabb(1.0f, p_154547_.getValue(FACING), 0.0f, 0.5f).move(p_154549_).deflate(1.0E-6);
        return p_154548_.noCollision($$4);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_56198_) {
        return (BlockState)this.defaultBlockState().setValue(FACING, p_56198_.getClickedFace());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56249_) {
        p_56249_.add(FACING);
    }

    @Override
    public BlockState playerWillDestroy(Level p_56212_, BlockPos p_56213_, BlockState p_56214_, Player p_56215_) {
        BlockEntity $$4 = p_56212_.getBlockEntity(p_56213_);
        if ($$4 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity $$5 = (ShulkerBoxBlockEntity)$$4;
            if (!p_56212_.isClientSide && p_56215_.isCreative() && !$$5.isEmpty()) {
                ItemStack $$6 = ShulkerBoxBlock.getColoredItemStack(this.getColor());
                $$6.applyComponents($$4.collectComponents());
                ItemEntity $$7 = new ItemEntity(p_56212_, (double)p_56213_.getX() + 0.5, (double)p_56213_.getY() + 0.5, (double)p_56213_.getZ() + 0.5, $$6);
                $$7.setDefaultPickUpDelay();
                p_56212_.addFreshEntity($$7);
            } else {
                $$5.unpackLootTable(p_56215_);
            }
        }
        return super.playerWillDestroy(p_56212_, p_56213_, p_56214_, p_56215_);
    }

    @Override
    protected List<ItemStack> getDrops(BlockState p_287632_, LootParams.Builder p_287691_) {
        BlockEntity $$2 = p_287691_.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if ($$2 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity $$3 = (ShulkerBoxBlockEntity)$$2;
            p_287691_ = p_287691_.withDynamicDrop(CONTENTS, p_56219_ -> {
                for (int $$2 = 0; $$2 < $$3.getContainerSize(); ++$$2) {
                    p_56219_.accept($$3.getItem($$2));
                }
            });
        }
        return super.getDrops(p_287632_, p_287691_);
    }

    @Override
    protected void onRemove(BlockState p_56234_, Level p_56235_, BlockPos p_56236_, BlockState p_56237_, boolean p_56238_) {
        if (p_56234_.is(p_56237_.getBlock())) {
            return;
        }
        BlockEntity $$5 = p_56235_.getBlockEntity(p_56236_);
        if ($$5 instanceof ShulkerBoxBlockEntity) {
            p_56235_.updateNeighbourForOutputSignal(p_56236_, p_56234_.getBlock());
        }
        super.onRemove(p_56234_, p_56235_, p_56236_, p_56237_, p_56238_);
    }

    @Override
    public void appendHoverText(ItemStack p_56193_, Item.TooltipContext p_339693_, List<Component> p_56195_, TooltipFlag p_56196_) {
        super.appendHoverText(p_56193_, p_339693_, p_56195_, p_56196_);
        if (p_56193_.has(DataComponents.CONTAINER_LOOT)) {
            p_56195_.add(UNKNOWN_CONTENTS);
        }
        int $$4 = 0;
        int $$5 = 0;
        for (ItemStack $$6 : p_56193_.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).nonEmptyItems()) {
            ++$$5;
            if ($$4 > 4) continue;
            ++$$4;
            p_56195_.add(Component.translatable("container.shulkerBox.itemCount", $$6.getHoverName(), $$6.getCount()));
        }
        if ($$5 - $$4 > 0) {
            p_56195_.add(Component.translatable("container.shulkerBox.more", $$5 - $$4).withStyle(ChatFormatting.ITALIC));
        }
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState p_259177_, BlockGetter p_260305_, BlockPos p_259168_) {
        ShulkerBoxBlockEntity $$4;
        BlockEntity $$3 = p_260305_.getBlockEntity(p_259168_);
        if ($$3 instanceof ShulkerBoxBlockEntity && !($$4 = (ShulkerBoxBlockEntity)$$3).isClosed()) {
            return OPEN_SHAPE_BY_DIRECTION.get(p_259177_.getValue(FACING).getOpposite());
        }
        return Shapes.block();
    }

    @Override
    protected VoxelShape getShape(BlockState p_56257_, BlockGetter p_56258_, BlockPos p_56259_, CollisionContext p_56260_) {
        BlockEntity $$4 = p_56258_.getBlockEntity(p_56259_);
        if ($$4 instanceof ShulkerBoxBlockEntity) {
            return Shapes.create(((ShulkerBoxBlockEntity)$$4).getBoundingBox(p_56257_));
        }
        return Shapes.block();
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState p_341628_, BlockGetter p_341633_, BlockPos p_341694_) {
        return false;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_56221_) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState p_56223_, Level p_56224_, BlockPos p_56225_) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity(p_56224_.getBlockEntity(p_56225_));
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader p_304539_, BlockPos p_56203_, BlockState p_56204_) {
        ItemStack $$3 = super.getCloneItemStack(p_304539_, p_56203_, p_56204_);
        p_304539_.getBlockEntity(p_56203_, BlockEntityType.SHULKER_BOX).ifPresent(p_323411_ -> p_323411_.saveToItem($$3, p_304539_.registryAccess()));
        return $$3;
    }

    @Nullable
    public static DyeColor getColorFromItem(Item p_56253_) {
        return ShulkerBoxBlock.getColorFromBlock(Block.byItem(p_56253_));
    }

    @Nullable
    public static DyeColor getColorFromBlock(Block p_56263_) {
        if (p_56263_ instanceof ShulkerBoxBlock) {
            return ((ShulkerBoxBlock)p_56263_).getColor();
        }
        return null;
    }

    public static Block getBlockByColor(@Nullable DyeColor p_56191_) {
        if (p_56191_ == null) {
            return Blocks.SHULKER_BOX;
        }
        return switch (p_56191_) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_SHULKER_BOX;
            case DyeColor.ORANGE -> Blocks.ORANGE_SHULKER_BOX;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_SHULKER_BOX;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_SHULKER_BOX;
            case DyeColor.YELLOW -> Blocks.YELLOW_SHULKER_BOX;
            case DyeColor.LIME -> Blocks.LIME_SHULKER_BOX;
            case DyeColor.PINK -> Blocks.PINK_SHULKER_BOX;
            case DyeColor.GRAY -> Blocks.GRAY_SHULKER_BOX;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_SHULKER_BOX;
            case DyeColor.CYAN -> Blocks.CYAN_SHULKER_BOX;
            case DyeColor.BLUE -> Blocks.BLUE_SHULKER_BOX;
            case DyeColor.BROWN -> Blocks.BROWN_SHULKER_BOX;
            case DyeColor.GREEN -> Blocks.GREEN_SHULKER_BOX;
            case DyeColor.RED -> Blocks.RED_SHULKER_BOX;
            case DyeColor.BLACK -> Blocks.BLACK_SHULKER_BOX;
            case DyeColor.PURPLE -> Blocks.PURPLE_SHULKER_BOX;
        };
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor p_56251_) {
        return new ItemStack(ShulkerBoxBlock.getBlockByColor(p_56251_));
    }

    @Override
    protected BlockState rotate(BlockState p_56243_, Rotation p_56244_) {
        return (BlockState)p_56243_.setValue(FACING, p_56244_.rotate(p_56243_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_56240_, Mirror p_56241_) {
        return p_56240_.rotate(p_56241_.getRotation(p_56240_.getValue(FACING)));
    }
}

