/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class GrassBlock
extends SpreadingSnowyDirtBlock
implements BonemealableBlock {
    public static final MapCodec<GrassBlock> CODEC = GrassBlock.simpleCodec(GrassBlock::new);

    public MapCodec<GrassBlock> codec() {
        return CODEC;
    }

    public GrassBlock(BlockBehaviour.Properties p_53685_) {
        super(p_53685_);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader p_256229_, BlockPos p_256432_, BlockState p_255677_) {
        return p_256229_.getBlockState(p_256432_.above()).isAir();
    }

    @Override
    public boolean isBonemealSuccess(Level p_221275_, RandomSource p_221276_, BlockPos p_221277_, BlockState p_221278_) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel p_221270_, RandomSource p_221271_, BlockPos p_221272_, BlockState p_221273_) {
        BlockPos $$4 = p_221272_.above();
        BlockState $$5 = Blocks.SHORT_GRASS.defaultBlockState();
        Optional<Holder.Reference<PlacedFeature>> $$6 = p_221270_.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(VegetationPlacements.GRASS_BONEMEAL);
        block0: for (int $$7 = 0; $$7 < 128; ++$$7) {
            Holder $$13;
            BlockPos $$8 = $$4;
            for (int $$9 = 0; $$9 < $$7 / 16; ++$$9) {
                if (!p_221270_.getBlockState(($$8 = $$8.offset(p_221271_.nextInt(3) - 1, (p_221271_.nextInt(3) - 1) * p_221271_.nextInt(3) / 2, p_221271_.nextInt(3) - 1)).below()).is(this) || p_221270_.getBlockState($$8).isCollisionShapeFullBlock(p_221270_, $$8)) continue block0;
            }
            BlockState $$10 = p_221270_.getBlockState($$8);
            if ($$10.is($$5.getBlock()) && p_221271_.nextInt(10) == 0) {
                ((BonemealableBlock)((Object)$$5.getBlock())).performBonemeal(p_221270_, p_221271_, $$8, $$10);
            }
            if (!$$10.isAir()) continue;
            if (p_221271_.nextInt(8) == 0) {
                List<ConfiguredFeature<?, ?>> $$11 = p_221270_.getBiome($$8).value().getGenerationSettings().getFlowerFeatures();
                if ($$11.isEmpty()) continue;
                Holder<PlacedFeature> $$12 = ((RandomPatchConfiguration)$$11.get(0).config()).feature();
            } else {
                if (!$$6.isPresent()) continue;
                $$13 = $$6.get();
            }
            ((PlacedFeature)$$13.value()).place(p_221270_, p_221270_.getChunkSource().getGenerator(), p_221271_, $$8);
        }
    }

    @Override
    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

