/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;

public class PublishCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.publish.failed"));
    private static final DynamicCommandExceptionType ERROR_ALREADY_PUBLISHED = new DynamicCommandExceptionType(p_304281_ -> Component.translatableEscape("commands.publish.alreadyPublished", p_304281_));

    public static void register(CommandDispatcher<CommandSourceStack> p_138185_) {
        p_138185_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("publish").requires(p_138189_ -> p_138189_.hasPermission(4))).executes(p_258235_ -> PublishCommand.publish((CommandSourceStack)p_258235_.getSource(), HttpUtil.getAvailablePort(), false, null))).then(((RequiredArgumentBuilder)Commands.argument("allowCommands", BoolArgumentType.bool()).executes(p_258236_ -> PublishCommand.publish((CommandSourceStack)p_258236_.getSource(), HttpUtil.getAvailablePort(), BoolArgumentType.getBool((CommandContext)p_258236_, (String)"allowCommands"), null))).then(((RequiredArgumentBuilder)Commands.argument("gamemode", GameModeArgument.gameMode()).executes(p_258237_ -> PublishCommand.publish((CommandSourceStack)p_258237_.getSource(), HttpUtil.getAvailablePort(), BoolArgumentType.getBool((CommandContext)p_258237_, (String)"allowCommands"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)p_258237_, "gamemode")))).then(Commands.argument("port", IntegerArgumentType.integer((int)0, (int)65535)).executes(p_258238_ -> PublishCommand.publish((CommandSourceStack)p_258238_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_258238_, (String)"port"), BoolArgumentType.getBool((CommandContext)p_258238_, (String)"allowCommands"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)p_258238_, "gamemode")))))));
    }

    private static int publish(CommandSourceStack p_260117_, int p_259411_, boolean p_260137_, @Nullable GameType p_259145_) throws CommandSyntaxException {
        if (p_260117_.getServer().isPublished()) {
            throw ERROR_ALREADY_PUBLISHED.create((Object)p_260117_.getServer().getPort());
        }
        if (!p_260117_.getServer().publishServer(p_259145_, p_260137_, p_259411_)) {
            throw ERROR_FAILED.create();
        }
        p_260117_.sendSuccess(() -> PublishCommand.getSuccessMessage(p_259411_), true);
        return p_259411_;
    }

    public static MutableComponent getSuccessMessage(int p_259532_) {
        MutableComponent $$1 = ComponentUtils.copyOnClickText(String.valueOf(p_259532_));
        return Component.translatable("commands.publish.started", $$1);
    }
}

