/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps INSTANCE = new NbtOps();
    private static final String WRAPPER_MARKER = "";

    protected NbtOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> p_128980_, Tag p_128981_) {
        return (U)(switch (p_128981_.getId()) {
            case 0 -> p_128980_.empty();
            case 1 -> p_128980_.createByte(((NumericTag)p_128981_).getAsByte());
            case 2 -> p_128980_.createShort(((NumericTag)p_128981_).getAsShort());
            case 3 -> p_128980_.createInt(((NumericTag)p_128981_).getAsInt());
            case 4 -> p_128980_.createLong(((NumericTag)p_128981_).getAsLong());
            case 5 -> p_128980_.createFloat(((NumericTag)p_128981_).getAsFloat());
            case 6 -> p_128980_.createDouble(((NumericTag)p_128981_).getAsDouble());
            case 7 -> p_128980_.createByteList(ByteBuffer.wrap(((ByteArrayTag)p_128981_).getAsByteArray()));
            case 8 -> p_128980_.createString(p_128981_.getAsString());
            case 9 -> this.convertList(p_128980_, p_128981_);
            case 10 -> this.convertMap(p_128980_, p_128981_);
            case 11 -> p_128980_.createIntList(Arrays.stream(((IntArrayTag)p_128981_).getAsIntArray()));
            case 12 -> p_128980_.createLongList(Arrays.stream(((LongArrayTag)p_128981_).getAsLongArray()));
            default -> throw new IllegalStateException("Unknown tag type: " + String.valueOf(p_128981_));
        });
    }

    public DataResult<Number> getNumberValue(Tag p_129030_) {
        if (p_129030_ instanceof NumericTag) {
            NumericTag $$1 = (NumericTag)p_129030_;
            return DataResult.success((Object)$$1.getAsNumber());
        }
        return DataResult.error(() -> "Not a number");
    }

    public Tag createNumeric(Number p_128983_) {
        return DoubleTag.valueOf(p_128983_.doubleValue());
    }

    public Tag createByte(byte p_128963_) {
        return ByteTag.valueOf(p_128963_);
    }

    public Tag createShort(short p_129048_) {
        return ShortTag.valueOf(p_129048_);
    }

    public Tag createInt(int p_128976_) {
        return IntTag.valueOf(p_128976_);
    }

    public Tag createLong(long p_128978_) {
        return LongTag.valueOf(p_128978_);
    }

    public Tag createFloat(float p_128974_) {
        return FloatTag.valueOf(p_128974_);
    }

    public Tag createDouble(double p_128972_) {
        return DoubleTag.valueOf(p_128972_);
    }

    public Tag createBoolean(boolean p_129050_) {
        return ByteTag.valueOf(p_129050_);
    }

    public DataResult<String> getStringValue(Tag p_129061_) {
        if (p_129061_ instanceof StringTag) {
            StringTag $$1 = (StringTag)p_129061_;
            return DataResult.success((Object)$$1.getAsString());
        }
        return DataResult.error(() -> "Not a string");
    }

    public Tag createString(String p_128985_) {
        return StringTag.valueOf(p_128985_);
    }

    public DataResult<Tag> mergeToList(Tag p_129041_, Tag p_129042_) {
        return NbtOps.createCollector(p_129041_).map(p_248053_ -> DataResult.success((Object)p_248053_.accept(p_129042_).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(p_129041_), (Object)p_129041_));
    }

    public DataResult<Tag> mergeToList(Tag p_129038_, List<Tag> p_129039_) {
        return NbtOps.createCollector(p_129038_).map(p_248048_ -> DataResult.success((Object)p_248048_.acceptAll(p_129039_).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(p_129038_), (Object)p_129038_));
    }

    public DataResult<Tag> mergeToMap(Tag p_129044_, Tag p_129045_, Tag p_129046_) {
        CompoundTag compoundTag;
        if (!(p_129044_ instanceof CompoundTag) && !(p_129044_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129044_), (Object)p_129044_);
        }
        if (!(p_129045_ instanceof StringTag)) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(p_129045_), (Object)p_129044_);
        }
        if (p_129044_ instanceof CompoundTag) {
            CompoundTag $$3 = (CompoundTag)p_129044_;
            compoundTag = $$3.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$4 = compoundTag;
        $$4.put(p_129045_.getAsString(), p_129046_);
        return DataResult.success((Object)$$4);
    }

    public DataResult<Tag> mergeToMap(Tag p_129032_, MapLike<Tag> p_129033_) {
        CompoundTag compoundTag;
        if (!(p_129032_ instanceof CompoundTag) && !(p_129032_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129032_), (Object)p_129032_);
        }
        if (p_129032_ instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)p_129032_;
            compoundTag = $$2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$3 = compoundTag;
        ArrayList $$4 = new ArrayList();
        p_129033_.entries().forEach(p_128994_ -> {
            Tag $$3 = (Tag)p_128994_.getFirst();
            if (!($$3 instanceof StringTag)) {
                $$4.add($$3);
                return;
            }
            $$3.put($$3.getAsString(), (Tag)p_128994_.getSecond());
        });
        if (!$$4.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf($$4), (Object)$$3);
        }
        return DataResult.success((Object)$$3);
    }

    public DataResult<Tag> mergeToMap(Tag p_341945_, Map<Tag, Tag> p_341920_) {
        CompoundTag compoundTag;
        if (!(p_341945_ instanceof CompoundTag) && !(p_341945_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_341945_), (Object)p_341945_);
        }
        if (p_341945_ instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)p_341945_;
            compoundTag = $$2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$3 = compoundTag;
        ArrayList<Tag> $$4 = new ArrayList<Tag>();
        for (Map.Entry<Tag, Tag> $$5 : p_341920_.entrySet()) {
            Tag $$6 = $$5.getKey();
            if ($$6 instanceof StringTag) {
                $$3.put($$6.getAsString(), $$5.getValue());
                continue;
            }
            $$4.add($$6);
        }
        if (!$$4.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf($$4), (Object)$$3);
        }
        return DataResult.success((Object)$$3);
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag p_129070_) {
        if (p_129070_ instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)p_129070_;
            return DataResult.success($$1.entrySet().stream().map(p_341872_ -> Pair.of((Object)this.createString((String)p_341872_.getKey()), (Object)((Tag)p_341872_.getValue()))));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(p_129070_));
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag p_129103_) {
        if (p_129103_ instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)p_129103_;
            return DataResult.success(p_341867_ -> {
                for (Map.Entry<String, Tag> $$2 : $$1.entrySet()) {
                    p_341867_.accept(this.createString($$2.getKey()), $$2.getValue());
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(p_129103_));
    }

    public DataResult<MapLike<Tag>> getMap(Tag p_129105_) {
        if (p_129105_ instanceof CompoundTag) {
            final CompoundTag $$1 = (CompoundTag)p_129105_;
            return DataResult.success((Object)new MapLike<Tag>(){

                @Nullable
                public Tag get(Tag p_129174_) {
                    return $$1.get(p_129174_.getAsString());
                }

                @Nullable
                public Tag get(String p_129169_) {
                    return $$1.get(p_129169_);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return $$1.entrySet().stream().map(p_341873_ -> Pair.of((Object)NbtOps.this.createString((String)p_341873_.getKey()), (Object)((Tag)p_341873_.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf($$1) + "]";
                }

                @Nullable
                public /* synthetic */ Object get(String string) {
                    return this.get(string);
                }

                @Nullable
                public /* synthetic */ Object get(Object object) {
                    return this.get((Tag)object);
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(p_129105_));
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> p_129004_) {
        CompoundTag $$1 = new CompoundTag();
        p_129004_.forEach(p_129018_ -> $$1.put(((Tag)p_129018_.getFirst()).getAsString(), (Tag)p_129018_.getSecond()));
        return $$1;
    }

    private static Tag tryUnwrap(CompoundTag p_251041_) {
        Tag $$1;
        if (p_251041_.size() == 1 && ($$1 = p_251041_.get(WRAPPER_MARKER)) != null) {
            return $$1;
        }
        return p_251041_;
    }

    public DataResult<Stream<Tag>> getStream(Tag p_129108_) {
        if (p_129108_ instanceof ListTag) {
            ListTag $$1 = (ListTag)p_129108_;
            if ($$1.getElementType() == 10) {
                return DataResult.success($$1.stream().map(p_248049_ -> NbtOps.tryUnwrap((CompoundTag)p_248049_)));
            }
            return DataResult.success($$1.stream());
        }
        if (p_129108_ instanceof CollectionTag) {
            CollectionTag $$2 = (CollectionTag)p_129108_;
            return DataResult.success($$2.stream().map(p_129158_ -> p_129158_));
        }
        return DataResult.error(() -> "Not a list");
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag p_129110_) {
        if (p_129110_ instanceof ListTag) {
            ListTag $$1 = (ListTag)p_129110_;
            if ($$1.getElementType() == 10) {
                return DataResult.success(p_341869_ -> {
                    for (Tag $$2 : $$1) {
                        p_341869_.accept(NbtOps.tryUnwrap((CompoundTag)$$2));
                    }
                });
            }
            return DataResult.success($$1::forEach);
        }
        if (p_129110_ instanceof CollectionTag) {
            CollectionTag $$2 = (CollectionTag)p_129110_;
            return DataResult.success($$2::forEach);
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(p_129110_));
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag p_129132_) {
        if (p_129132_ instanceof ByteArrayTag) {
            ByteArrayTag $$1 = (ByteArrayTag)p_129132_;
            return DataResult.success((Object)ByteBuffer.wrap($$1.getAsByteArray()));
        }
        return super.getByteBuffer((Object)p_129132_);
    }

    public Tag createByteList(ByteBuffer p_128990_) {
        ByteBuffer $$1 = p_128990_.duplicate().clear();
        byte[] $$2 = new byte[p_128990_.capacity()];
        $$1.get(0, $$2, 0, $$2.length);
        return new ByteArrayTag($$2);
    }

    public DataResult<IntStream> getIntStream(Tag p_129134_) {
        if (p_129134_ instanceof IntArrayTag) {
            IntArrayTag $$1 = (IntArrayTag)p_129134_;
            return DataResult.success((Object)Arrays.stream($$1.getAsIntArray()));
        }
        return super.getIntStream((Object)p_129134_);
    }

    public Tag createIntList(IntStream p_129000_) {
        return new IntArrayTag(p_129000_.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag p_129136_) {
        if (p_129136_ instanceof LongArrayTag) {
            LongArrayTag $$1 = (LongArrayTag)p_129136_;
            return DataResult.success((Object)Arrays.stream($$1.getAsLongArray()));
        }
        return super.getLongStream((Object)p_129136_);
    }

    public Tag createLongList(LongStream p_129002_) {
        return new LongArrayTag(p_129002_.toArray());
    }

    public Tag createList(Stream<Tag> p_129052_) {
        return InitialListCollector.INSTANCE.acceptAll(p_129052_).result();
    }

    public Tag remove(Tag p_129035_, String p_129036_) {
        if (p_129035_ instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)p_129035_;
            CompoundTag $$3 = $$2.shallowCopy();
            $$3.remove(p_129036_);
            return $$3;
        }
        return p_129035_;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder(this);
    }

    private static Optional<ListCollector> createCollector(Tag p_249503_) {
        if (p_249503_ instanceof EndTag) {
            return Optional.of(InitialListCollector.INSTANCE);
        }
        if (p_249503_ instanceof CollectionTag) {
            CollectionTag $$1 = (CollectionTag)p_249503_;
            if ($$1.isEmpty()) {
                return Optional.of(InitialListCollector.INSTANCE);
            }
            if ($$1 instanceof ListTag) {
                ListTag $$2 = (ListTag)$$1;
                return switch ($$2.getElementType()) {
                    case 0 -> Optional.of(InitialListCollector.INSTANCE);
                    case 10 -> Optional.of(new HeterogenousListCollector($$2));
                    default -> Optional.of(new HomogenousListCollector($$2));
                };
            }
            if ($$1 instanceof ByteArrayTag) {
                ByteArrayTag $$3 = (ByteArrayTag)$$1;
                return Optional.of(new ByteListCollector($$3.getAsByteArray()));
            }
            if ($$1 instanceof IntArrayTag) {
                IntArrayTag $$4 = (IntArrayTag)$$1;
                return Optional.of(new IntListCollector($$4.getAsIntArray()));
            }
            if ($$1 instanceof LongArrayTag) {
                LongArrayTag $$5 = (LongArrayTag)$$1;
                return Optional.of(new LongListCollector($$5.getAsLongArray()));
            }
        }
        return Optional.empty();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((Tag)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((Tag)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((Tag)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((Tag)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((Tag)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((Tag)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((Tag)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((Tag)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((Tag)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((Tag)object, (MapLike<Tag>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Map map) {
        return this.mergeToMap((Tag)object, (Map<Tag, Tag>)map);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((Tag)object, (Tag)object2, (Tag)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((Tag)object, (List<Tag>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((Tag)object, (Tag)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((Tag)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((Tag)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (Tag)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    static class InitialListCollector
    implements ListCollector {
        public static final InitialListCollector INSTANCE = new InitialListCollector();

        private InitialListCollector() {
        }

        @Override
        public ListCollector accept(Tag p_251635_) {
            if (p_251635_ instanceof CompoundTag) {
                CompoundTag $$1 = (CompoundTag)p_251635_;
                return new HeterogenousListCollector().accept($$1);
            }
            if (p_251635_ instanceof ByteTag) {
                ByteTag $$2 = (ByteTag)p_251635_;
                return new ByteListCollector($$2.getAsByte());
            }
            if (p_251635_ instanceof IntTag) {
                IntTag $$3 = (IntTag)p_251635_;
                return new IntListCollector($$3.getAsInt());
            }
            if (p_251635_ instanceof LongTag) {
                LongTag $$4 = (LongTag)p_251635_;
                return new LongListCollector($$4.getAsLong());
            }
            return new HomogenousListCollector(p_251635_);
        }

        @Override
        public Tag result() {
            return new ListTag();
        }
    }

    static interface ListCollector {
        public ListCollector accept(Tag var1);

        default public ListCollector acceptAll(Iterable<Tag> p_249781_) {
            ListCollector $$1 = this;
            for (Tag $$2 : p_249781_) {
                $$1 = $$1.accept($$2);
            }
            return $$1;
        }

        default public ListCollector acceptAll(Stream<Tag> p_249876_) {
            return this.acceptAll(p_249876_::iterator);
        }

        public Tag result();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder(NbtOps nbtOps) {
            super((DynamicOps)nbtOps);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String p_129186_, Tag p_129187_, CompoundTag p_129188_) {
            p_129188_.put(p_129186_, p_129187_);
            return p_129188_;
        }

        protected DataResult<Tag> build(CompoundTag p_129190_, Tag p_129191_) {
            if (p_129191_ == null || p_129191_ == EndTag.INSTANCE) {
                return DataResult.success((Object)p_129190_);
            }
            if (p_129191_ instanceof CompoundTag) {
                CompoundTag $$2 = (CompoundTag)p_129191_;
                CompoundTag $$3 = $$2.shallowCopy();
                for (Map.Entry<String, Tag> $$4 : p_129190_.entrySet()) {
                    $$3.put($$4.getKey(), $$4.getValue());
                }
                return DataResult.success((Object)$$3);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129191_), (Object)p_129191_);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.append(string, (Tag)object, (CompoundTag)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((CompoundTag)object, (Tag)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }

    static class HeterogenousListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        public HeterogenousListCollector() {
        }

        public HeterogenousListCollector(Collection<Tag> p_249606_) {
            this.result.addAll(p_249606_);
        }

        public HeterogenousListCollector(IntArrayList p_250270_) {
            p_250270_.forEach(p_249166_ -> this.result.add(HeterogenousListCollector.wrapElement(IntTag.valueOf(p_249166_))));
        }

        public HeterogenousListCollector(ByteArrayList p_248575_) {
            p_248575_.forEach(p_249160_ -> this.result.add(HeterogenousListCollector.wrapElement(ByteTag.valueOf(p_249160_))));
        }

        public HeterogenousListCollector(LongArrayList p_249410_) {
            p_249410_.forEach(p_249754_ -> this.result.add(HeterogenousListCollector.wrapElement(LongTag.valueOf(p_249754_))));
        }

        private static boolean isWrapper(CompoundTag p_252073_) {
            return p_252073_.size() == 1 && p_252073_.contains(NbtOps.WRAPPER_MARKER);
        }

        private static Tag wrapIfNeeded(Tag p_252042_) {
            CompoundTag $$1;
            if (p_252042_ instanceof CompoundTag && !HeterogenousListCollector.isWrapper($$1 = (CompoundTag)p_252042_)) {
                return $$1;
            }
            return HeterogenousListCollector.wrapElement(p_252042_);
        }

        private static CompoundTag wrapElement(Tag p_251263_) {
            CompoundTag $$1 = new CompoundTag();
            $$1.put(NbtOps.WRAPPER_MARKER, p_251263_);
            return $$1;
        }

        @Override
        public ListCollector accept(Tag p_249045_) {
            this.result.add(HeterogenousListCollector.wrapIfNeeded(p_249045_));
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class HomogenousListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        HomogenousListCollector(Tag p_249247_) {
            this.result.add(p_249247_);
        }

        HomogenousListCollector(ListTag p_249889_) {
            this.result.addAll(p_249889_);
        }

        @Override
        public ListCollector accept(Tag p_248727_) {
            if (p_248727_.getId() != this.result.getElementType()) {
                return new HeterogenousListCollector().acceptAll(this.result).accept(p_248727_);
            }
            this.result.add(p_248727_);
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList values = new ByteArrayList();

        public ByteListCollector(byte p_249905_) {
            this.values.add(p_249905_);
        }

        public ByteListCollector(byte[] p_250457_) {
            this.values.addElements(0, p_250457_);
        }

        @Override
        public ListCollector accept(Tag p_250723_) {
            if (p_250723_ instanceof ByteTag) {
                ByteTag $$1 = (ByteTag)p_250723_;
                this.values.add($$1.getAsByte());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept(p_250723_);
        }

        @Override
        public Tag result() {
            return new ByteArrayTag(this.values.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList values = new IntArrayList();

        public IntListCollector(int p_250274_) {
            this.values.add(p_250274_);
        }

        public IntListCollector(int[] p_249489_) {
            this.values.addElements(0, p_249489_);
        }

        @Override
        public ListCollector accept(Tag p_251372_) {
            if (p_251372_ instanceof IntTag) {
                IntTag $$1 = (IntTag)p_251372_;
                this.values.add($$1.getAsInt());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept(p_251372_);
        }

        @Override
        public Tag result() {
            return new IntArrayTag(this.values.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList values = new LongArrayList();

        public LongListCollector(long p_249842_) {
            this.values.add(p_249842_);
        }

        public LongListCollector(long[] p_251409_) {
            this.values.addElements(0, p_251409_);
        }

        @Override
        public ListCollector accept(Tag p_252167_) {
            if (p_252167_ instanceof LongTag) {
                LongTag $$1 = (LongTag)p_252167_;
                this.values.add($$1.getAsLong());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept(p_252167_);
        }

        @Override
        public Tag result() {
            return new LongArrayTag(this.values.toLongArray());
        }
    }
}

