/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.placement.VillagePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class SnowyVillagePools {
    public static final ResourceKey<StructureTemplatePool> START = Pools.createKey("village/snowy/town_centers");
    private static final ResourceKey<StructureTemplatePool> TERMINATORS_KEY = Pools.createKey("village/snowy/terminators");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> p_321804_) {
        HolderGetter<PlacedFeature> $$1 = p_321804_.lookup(Registries.PLACED_FEATURE);
        Holder.Reference<PlacedFeature> $$2 = $$1.getOrThrow(VillagePlacements.SPRUCE_VILLAGE);
        Holder.Reference<PlacedFeature> $$3 = $$1.getOrThrow(VillagePlacements.PILE_SNOW_VILLAGE);
        Holder.Reference<PlacedFeature> $$4 = $$1.getOrThrow(VillagePlacements.PILE_ICE_VILLAGE);
        HolderGetter<StructureProcessorList> $$5 = p_321804_.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference<StructureProcessorList> $$6 = $$5.getOrThrow(ProcessorLists.STREET_SNOWY_OR_TAIGA);
        Holder.Reference<StructureProcessorList> $$7 = $$5.getOrThrow(ProcessorLists.FARM_SNOWY);
        Holder.Reference<StructureProcessorList> $$8 = $$5.getOrThrow(ProcessorLists.ZOMBIE_SNOWY);
        HolderGetter<StructureTemplatePool> $$9 = p_321804_.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> $$10 = $$9.getOrThrow(Pools.EMPTY);
        Holder.Reference<StructureTemplatePool> $$11 = $$9.getOrThrow(TERMINATORS_KEY);
        p_321804_.register(START, new StructureTemplatePool($$10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/town_centers/snowy_meeting_point_1"), (Object)100), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/town_centers/snowy_meeting_point_2"), (Object)50), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/town_centers/snowy_meeting_point_3"), (Object)150), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/town_centers/snowy_meeting_point_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/town_centers/snowy_meeting_point_2"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/town_centers/snowy_meeting_point_3"), (Object)3)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_321804_, "village/snowy/streets", new StructureTemplatePool($$11, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/corner_01", $$6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/corner_02", $$6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/corner_03", $$6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/square_01", $$6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_01", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_02", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_03", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_04", $$6), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_06", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_08", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_02", $$6), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_03", $$6), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_04", $$6), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_05", $$6), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_06", $$6), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/streets/turn_01", $$6), (Object)3)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_321804_, "village/snowy/zombie/streets", new StructureTemplatePool($$11, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/corner_01", $$6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/corner_02", $$6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/corner_03", $$6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/square_01", $$6), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_01", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_02", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_03", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_04", $$6), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_06", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_08", $$6), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_02", $$6), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_03", $$6), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_04", $$6), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_05", $$6), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_06", $$6), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/turn_01", $$6), (Object)3)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_321804_, "village/snowy/houses", new StructureTemplatePool($$11, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_2"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_3"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_4"), (Object)3), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_5"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_6"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_7"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_8"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_medium_house_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_medium_house_2"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_medium_house_3"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_butchers_shop_1"), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_butchers_shop_2"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_tool_smith_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_fletcher_house_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_shepherds_house_1"), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_armorer_house_1"), (Object)1), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_armorer_house_2"), (Object)1), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_fisher_cottage"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_tannery_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_cartographer_house_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_library_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_masons_house_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_masons_house_2"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_weapon_smith_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_temple_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_farm_1", $$7), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_farm_2", $$7), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_animal_pen_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_animal_pen_2"), (Object)2), Pair.of(StructurePoolElement.empty(), (Object)6)}), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_321804_, "village/snowy/zombie/houses", new StructureTemplatePool($$11, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_1", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_2", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_3", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_4", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_5", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_6", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_7", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_8", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_medium_house_1", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_medium_house_2", $$8), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_medium_house_3", $$8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_butchers_shop_1", $$8), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_butchers_shop_2", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_tool_smith_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_fletcher_house_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_shepherds_house_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_armorer_house_1", $$8), (Object)1), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_armorer_house_2", $$8), (Object)1), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_fisher_cottage", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_tannery_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_cartographer_house_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_library_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_masons_house_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_masons_house_2", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_weapon_smith_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_temple_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_farm_1", $$8), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_farm_2", $$8), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_animal_pen_1", $$8), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_animal_pen_2", $$8), (Object)2), Pair.of(StructurePoolElement.empty(), (Object)6)}), StructureTemplatePool.Projection.RIGID));
        p_321804_.register(TERMINATORS_KEY, new StructureTemplatePool($$10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_01", $$6), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_02", $$6), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_03", $$6), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_04", $$6), (Object)1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_321804_, "village/snowy/trees", new StructureTemplatePool($$10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.feature($$2), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_321804_, "village/snowy/decor", new StructureTemplatePool($$10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_01"), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_02"), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_03"), (Object)1), (Object)Pair.of(StructurePoolElement.feature($$2), (Object)4), (Object)Pair.of(StructurePoolElement.feature($$3), (Object)4), (Object)Pair.of(StructurePoolElement.feature($$4), (Object)1), (Object)Pair.of(StructurePoolElement.empty(), (Object)9)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_321804_, "village/snowy/zombie/decor", new StructureTemplatePool($$10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_01", $$8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_02", $$8), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_03", $$8), (Object)1), (Object)Pair.of(StructurePoolElement.feature($$2), (Object)4), (Object)Pair.of(StructurePoolElement.feature($$3), (Object)4), (Object)Pair.of(StructurePoolElement.feature($$4), (Object)4), (Object)Pair.of(StructurePoolElement.empty(), (Object)7)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_321804_, "village/snowy/villagers", new StructureTemplatePool($$10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/villagers/baby"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_321804_, "village/snowy/zombie/villagers", new StructureTemplatePool($$10, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
    }
}

