/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.spongepowered.asm.mixin.injection.code.IInsnListEx;
import org.spongepowered.asm.mixin.injection.code.InsnListReadOnly;
import org.spongepowered.asm.mixin.injection.struct.Constructor;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.struct.Initialiser;
import org.spongepowered.asm.util.Bytecode;

public class InsnListEx
extends InsnListReadOnly
implements IInsnListEx {
    private final Target target;

    public InsnListEx(Target target) {
        super(target.insns);
        this.target = target;
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public String getTargetName() {
        return this.target.getName();
    }

    @Override
    public String getTargetDesc() {
        return this.target.getDesc();
    }

    @Override
    public String getTargetSignature() {
        return this.target.getSignature();
    }

    @Override
    public int getTargetAccess() {
        return this.target.method.access;
    }

    @Override
    public boolean isTargetStatic() {
        return this.target.isStatic;
    }

    @Override
    public boolean isTargetConstructor() {
        return this.target instanceof Constructor;
    }

    @Override
    public boolean isTargetStaticInitialiser() {
        return "<clinit>".equals(this.target.getName());
    }

    @Override
    public AbstractInsnNode getSpecialNode(IInsnListEx.SpecialNodeType type) {
        switch (type) {
            case DELEGATE_CTOR: {
                if (this.target instanceof Constructor) {
                    Bytecode.DelegateInitialiser superCall = ((Constructor)this.target).findDelegateInitNode();
                    if (superCall.isPresent && this.contains((AbstractInsnNode)superCall.insn)) {
                        return superCall.insn;
                    }
                }
                return null;
            }
            case INITIALISER_INJECTION_POINT: {
                Initialiser.InjectionMode mode;
                AbstractInsnNode initialiserInjectionPoint;
                if (this.target instanceof Constructor && this.contains(initialiserInjectionPoint = ((Constructor)this.target).findInitialiserInjectionPoint(mode = Initialiser.InjectionMode.DEFAULT))) {
                    return initialiserInjectionPoint;
                }
                return null;
            }
            case CTOR_BODY: {
                AbstractInsnNode beforeBody;
                if (this.target instanceof Constructor && this.contains(beforeBody = ((Constructor)this.target).findFirstBodyInsn())) {
                    return beforeBody;
                }
                return null;
            }
        }
        return null;
    }
}

