/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.moddiscovery.locators.PathBasedLocator;
import net.neoforged.fml.loading.targets.CommonServerLaunchHandler;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;

public class NeoForgeServerLaunchHandler
extends CommonServerLaunchHandler {
    public String name() {
        return "forgeserver";
    }

    @Override
    protected List<MavenCoordinate> getAdditionalMinecraftJarContent(VersionInfo versionInfo) {
        return List.of(new MavenCoordinate("net.neoforged", "neoforge", "", "server", versionInfo.neoForgeVersion()));
    }

    @Override
    public void collectAdditionalModFileLocators(VersionInfo versionInfo, Consumer<IModFileCandidateLocator> output) {
        super.collectAdditionalModFileLocators(versionInfo, output);
        Path nfJar = LibraryFinder.findPathForMaven("net.neoforged", "neoforge", "", "universal", versionInfo.neoForgeVersion());
        output.accept(new PathBasedLocator("neoforge", nfJar));
    }
}

