/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.configuration.ClientConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import net.neoforged.fml.common.asm.enumextension.NetworkedEnum;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.payload.ExtensibleEnumAcknowledgePayload;
import net.neoforged.neoforge.network.payload.ExtensibleEnumDataPayload;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

@ApiStatus.Internal
public record CheckExtensibleEnums(ServerConfigurationPacketListener listener) implements ConfigurationTask
{
    public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"check_extensible_enum"));
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Type NETWORKED_ENUM = Type.getType(NetworkedEnum.class);
    private static final List<? extends Class<? extends Enum<?>>> NETWORKED_EXTENSIBLE_ENUM_CLASSES = CheckExtensibleEnums.collectNetworkedEnumClasses();
    private static Map<String, EnumEntry> enumEntries = null;

    public void start(Consumer<Packet<?>> packetSender) {
        if (this.listener.getConnection().isMemoryConnection()) {
            this.listener.finishCurrentTask(TYPE);
            return;
        }
        Map<String, EnumEntry> enumEntries = CheckExtensibleEnums.getEnumEntries();
        if (this.listener.getConnectionType().isOther()) {
            List<EnumEntry> extendedClientboundEnums = enumEntries.values().stream().filter(entry -> entry.isClientbound() && entry.isExtended()).toList();
            if (!extendedClientboundEnums.isEmpty()) {
                this.listener.disconnect((Component)Component.literal((String)"This server does not support vanilla clients as it has extended enums used in clientbound networking"));
            } else {
                this.listener.finishCurrentTask(TYPE);
            }
            return;
        }
        packetSender.accept((Packet<?>)new ExtensibleEnumDataPayload(enumEntries).toVanillaClientbound());
    }

    public static void handleClientboundPayload(ExtensibleEnumDataPayload payload, IPayloadContext context) {
        Map<String, EnumEntry> localEnumEntries = CheckExtensibleEnums.getEnumEntries();
        Map<String, EnumEntry> remoteEnumEntries = payload.enumEntries();
        Sets.SetView keyDiff = Sets.symmetricDifference(localEnumEntries.keySet(), remoteEnumEntries.keySet());
        if (!keyDiff.isEmpty()) {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.extensible_enums.enum_set_mismatch"));
            return;
        }
        HashMap<String, Mismatch> mismatched = new HashMap<String, Mismatch>();
        block5: for (EnumEntry localEntry : localEnumEntries.values()) {
            EnumEntry remoteEntry = remoteEnumEntries.get(localEntry.className);
            if (!localEntry.isExtended() && !remoteEntry.isExtended()) continue;
            if (localEntry.networkCheck != remoteEntry.networkCheck) {
                mismatched.put(localEntry.className, Mismatch.NETWORK_CHECK);
                continue;
            }
            if (localEntry.isExtended() != remoteEntry.isExtended()) {
                mismatched.put(localEntry.className, Mismatch.EXTENSION);
                continue;
            }
            ExtensionData localData = localEntry.data.orElseThrow();
            ExtensionData remoteData = remoteEntry.data.orElseThrow();
            if (localData.vanillaCount != remoteData.vanillaCount || localData.totalCount != remoteData.totalCount) {
                mismatched.put(localEntry.className, Mismatch.ENTRY_COUNT);
                continue;
            }
            List<String> localValues = localData.entries;
            List<String> remoteValues = remoteData.entries;
            for (int i = 0; i < localData.totalCount - localData.vanillaCount; ++i) {
                if (localValues.get(i).equals(remoteValues.get(i))) continue;
                mismatched.put(localEntry.className, Mismatch.ENTRY_MISMATCH);
                continue block5;
            }
        }
        if (!mismatched.isEmpty()) {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.extensible_enums.enum_entry_mismatch"));
            StringBuilder message = new StringBuilder("The configuration or set of values added to extensible enums on the client and server do not match");
            for (Map.Entry entry : mismatched.entrySet()) {
                String enumClass = (String)entry.getKey();
                message.append("\n").append(enumClass).append(": ");
                switch (((Mismatch)((Object)entry.getValue())).ordinal()) {
                    case 0: {
                        message.append("Mismatched NetworkCheck (server: ").append(remoteEnumEntries.get((Object)enumClass).networkCheck).append(", client: ").append(localEnumEntries.get((Object)enumClass).networkCheck).append(")");
                        break;
                    }
                    case 1: {
                        if (remoteEnumEntries.get(enumClass).isExtended()) {
                            message.append("Enum has additional entries on the server but not on the client");
                            break;
                        }
                        message.append("Enum has additional entries on the client but not on the server");
                        break;
                    }
                    case 2: 
                    case 3: {
                        message.append("Set of entries does not match (server: ").append(remoteEnumEntries.get((Object)enumClass).data.orElseThrow().entries).append(", client: ").append(localEnumEntries.get((Object)enumClass).data.orElseThrow().entries).append(")");
                    }
                }
            }
            LOGGER.warn(message.toString());
            return;
        }
        context.reply(ExtensibleEnumAcknowledgePayload.INSTANCE);
    }

    public static void handleServerboundPayload(ExtensibleEnumAcknowledgePayload payload, IPayloadContext context) {
        context.finishCurrentTask(TYPE);
    }

    public static boolean handleVanillaServerConnection(ClientConfigurationPacketListener listener) {
        Collection<EnumEntry> enumEntries = CheckExtensibleEnums.getEnumEntries().values();
        if (enumEntries.stream().anyMatch(entry -> entry.isServerbound() && entry.isExtended())) {
            listener.disconnect((Component)Component.translatable((String)"neoforge.network.extensible_enums.no_vanilla_server"));
            return false;
        }
        return true;
    }

    private static synchronized Map<String, EnumEntry> getEnumEntries() {
        if (enumEntries == null) {
            HashMap<String, EnumEntry> entries = new HashMap<String, EnumEntry>();
            for (Class<Enum<?>> enumClass : NETWORKED_EXTENSIBLE_ENUM_CLASSES) {
                Optional<ExtensionData> extData = Optional.empty();
                ExtensionInfo extInfo = CheckExtensibleEnums.getEnumExtensionInfo(enumClass);
                if (extInfo.extended()) {
                    ArrayList<String> values = new ArrayList<String>(extInfo.totalCount() - extInfo.vanillaCount());
                    Enum<?>[] constants = enumClass.getEnumConstants();
                    for (int i = extInfo.vanillaCount(); i < extInfo.totalCount(); ++i) {
                        values.add(constants[i].name());
                    }
                    extData = Optional.of(new ExtensionData(extInfo.vanillaCount(), extInfo.totalCount(), values));
                }
                String name = enumClass.getName();
                entries.put(name, new EnumEntry(name, (NetworkedEnum.NetworkCheck)Preconditions.checkNotNull((Object)extInfo.netCheck(), (String)"Enum %s does not have a NetworkCheck value", (Object)name), extData));
            }
            enumEntries = entries;
        }
        return enumEntries;
    }

    private static ExtensionInfo getEnumExtensionInfo(Class<? extends Enum<?>> enumClass) {
        try {
            Method mth = enumClass.getDeclaredMethod("getExtensionInfo", new Class[0]);
            return (ExtensionInfo)mth.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<? extends Class<? extends Enum<?>>> collectNetworkedEnumClasses() {
        return ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> NETWORKED_ENUM.equals((Object)a.annotationType())).map(a -> CheckExtensibleEnums.classForName(a.clazz().getClassName())).filter(Class::isEnum).filter(IExtensibleEnum.class::isAssignableFrom).map(c -> c).toList();
    }

    private static Class<?> classForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class specified by annotation data", e);
        }
    }

    public ConfigurationTask.Type type() {
        return TYPE;
    }

    public record EnumEntry(String className, NetworkedEnum.NetworkCheck networkCheck, Optional<ExtensionData> data) {
        public static final StreamCodec<ByteBuf, EnumEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, EnumEntry::className, (StreamCodec)ByteBufCodecs.STRING_UTF8.map(NetworkedEnum.NetworkCheck::valueOf, Enum::name), EnumEntry::networkCheck, (StreamCodec)ByteBufCodecs.optional(ExtensionData.STREAM_CODEC), EnumEntry::data, EnumEntry::new);

        public boolean isClientbound() {
            return this.networkCheck == NetworkedEnum.NetworkCheck.CLIENTBOUND || this.networkCheck == NetworkedEnum.NetworkCheck.BIDIRECTIONAL;
        }

        public boolean isServerbound() {
            return this.networkCheck == NetworkedEnum.NetworkCheck.SERVERBOUND || this.networkCheck == NetworkedEnum.NetworkCheck.BIDIRECTIONAL;
        }

        public boolean isExtended() {
            return this.data.isPresent();
        }
    }

    private static enum Mismatch {
        NETWORK_CHECK,
        EXTENSION,
        ENTRY_COUNT,
        ENTRY_MISMATCH;

    }

    public record ExtensionData(int vanillaCount, int totalCount, List<String> entries) {
        public static final StreamCodec<ByteBuf, ExtensionData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ExtensionData::vanillaCount, (StreamCodec)ByteBufCodecs.VAR_INT, ExtensionData::totalCount, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), ExtensionData::entries, ExtensionData::new);
    }
}

