/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import net.neoforged.neoforge.common.util.strategy.BasicStrategy;

public class InsertableLinkedOpenCustomHashSet<T>
extends ObjectLinkedOpenCustomHashSet<T> {
    private static final long LINK_BIT_SPACE = 32L;
    private static final long NEXT_LINK = 0xFFFFFFFFL;
    private static final long PREV_LINK = -4294967296L;

    public InsertableLinkedOpenCustomHashSet() {
        super(BasicStrategy.BASIC);
    }

    public InsertableLinkedOpenCustomHashSet(Hash.Strategy<? super T> strategy) {
        super(strategy);
    }

    public boolean addAfter(T insertAfter, T element) {
        int afterPos;
        if (this.contains(insertAfter) && this.last != (afterPos = this.getPos(insertAfter))) {
            int pos = HashCommon.mix((int)this.strategy.hashCode(element)) & this.mask;
            Object curr = this.key[pos];
            if (curr != null) {
                do {
                    if (!this.strategy.equals(curr, element)) continue;
                    return false;
                } while ((curr = this.key[pos = pos + 1 & this.mask]) != null);
            }
            this.key[pos] = element;
            long nextPos = this.link[afterPos] & 0xFFFFFFFFL;
            int n = (int)nextPos;
            this.link[n] = this.link[n] ^ (this.link[(int)nextPos] ^ ((long)pos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            int n2 = afterPos;
            this.link[n2] = this.link[n2] ^ (this.link[afterPos] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)afterPos & 0xFFFFFFFFL) << 32 | nextPos;
            if (this.size++ >= this.maxFill) {
                this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)this.f));
            }
            return true;
        }
        return this.add(element);
    }

    public boolean addBefore(T insertBefore, T element) {
        if (this.contains(insertBefore)) {
            int beforePos = this.getPos(insertBefore);
            if (beforePos == this.first) {
                if (this.contains(element)) {
                    return false;
                }
                return this.addAndMoveToFirst(element);
            }
            int pos = HashCommon.mix((int)this.strategy.hashCode(element)) & this.mask;
            Object curr = this.key[pos];
            if (curr != null) {
                do {
                    if (!this.strategy.equals(curr, element)) continue;
                    return false;
                } while ((curr = this.key[pos = pos + 1 & this.mask]) != null);
            }
            this.key[pos] = element;
            long prevPos = (this.link[beforePos] & 0xFFFFFFFF00000000L) >> 32;
            int n = (int)prevPos;
            this.link[n] = this.link[n] ^ (this.link[(int)prevPos] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = beforePos;
            this.link[n2] = this.link[n2] ^ (this.link[beforePos] ^ ((long)pos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[pos] = prevPos << 32 | (long)beforePos & 0xFFFFFFFFL;
            if (this.size++ >= this.maxFill) {
                this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)this.f));
            }
            return true;
        }
        return this.add(element);
    }

    public void addFirst(T element) {
        this.addAndMoveToFirst(element);
    }

    public void addLast(T element) {
        this.addAndMoveToLast(element);
    }

    private int getPos(T existingElement) {
        int pos = HashCommon.mix((int)this.strategy.hashCode(existingElement)) & this.mask;
        Object curr = this.key[pos];
        while (!this.strategy.equals(curr, existingElement) && (curr = this.key[pos = pos + 1 & this.mask]) != null) {
        }
        return pos;
    }
}

