/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Node {
    public final int x;
    public final int y;
    public final int z;
    private final int hash;
    public int heapIdx = -1;
    public float g;
    public float h;
    public float f;
    @Nullable
    public Node cameFrom;
    public boolean closed;
    public float walkedDistance;
    public float costMalus;
    public PathType type = PathType.BLOCKED;

    public Node(int p_77285_, int p_77286_, int p_77287_) {
        this.x = p_77285_;
        this.y = p_77286_;
        this.z = p_77287_;
        this.hash = Node.createHash(p_77285_, p_77286_, p_77287_);
    }

    public Node cloneAndMove(int p_77290_, int p_77291_, int p_77292_) {
        Node $$3 = new Node(p_77290_, p_77291_, p_77292_);
        $$3.heapIdx = this.heapIdx;
        $$3.g = this.g;
        $$3.h = this.h;
        $$3.f = this.f;
        $$3.cameFrom = this.cameFrom;
        $$3.closed = this.closed;
        $$3.walkedDistance = this.walkedDistance;
        $$3.costMalus = this.costMalus;
        $$3.type = this.type;
        return $$3;
    }

    public static int createHash(int p_77296_, int p_77297_, int p_77298_) {
        return p_77297_ & 0xFF | (p_77296_ & Short.MAX_VALUE) << 8 | (p_77298_ & Short.MAX_VALUE) << 24 | (p_77296_ < 0 ? Integer.MIN_VALUE : 0) | (p_77298_ < 0 ? 32768 : 0);
    }

    public float distanceTo(Node p_77294_) {
        float $$1 = p_77294_.x - this.x;
        float $$2 = p_77294_.y - this.y;
        float $$3 = p_77294_.z - this.z;
        return Mth.sqrt($$1 * $$1 + $$2 * $$2 + $$3 * $$3);
    }

    public float distanceToXZ(Node p_230614_) {
        float $$1 = p_230614_.x - this.x;
        float $$2 = p_230614_.z - this.z;
        return Mth.sqrt($$1 * $$1 + $$2 * $$2);
    }

    public float distanceTo(BlockPos p_164698_) {
        float $$1 = p_164698_.getX() - this.x;
        float $$2 = p_164698_.getY() - this.y;
        float $$3 = p_164698_.getZ() - this.z;
        return Mth.sqrt($$1 * $$1 + $$2 * $$2 + $$3 * $$3);
    }

    public float distanceToSqr(Node p_77300_) {
        float $$1 = p_77300_.x - this.x;
        float $$2 = p_77300_.y - this.y;
        float $$3 = p_77300_.z - this.z;
        return $$1 * $$1 + $$2 * $$2 + $$3 * $$3;
    }

    public float distanceToSqr(BlockPos p_164703_) {
        float $$1 = p_164703_.getX() - this.x;
        float $$2 = p_164703_.getY() - this.y;
        float $$3 = p_164703_.getZ() - this.z;
        return $$1 * $$1 + $$2 * $$2 + $$3 * $$3;
    }

    public float distanceManhattan(Node p_77305_) {
        float $$1 = Math.abs(p_77305_.x - this.x);
        float $$2 = Math.abs(p_77305_.y - this.y);
        float $$3 = Math.abs(p_77305_.z - this.z);
        return $$1 + $$2 + $$3;
    }

    public float distanceManhattan(BlockPos p_77307_) {
        float $$1 = Math.abs(p_77307_.getX() - this.x);
        float $$2 = Math.abs(p_77307_.getY() - this.y);
        float $$3 = Math.abs(p_77307_.getZ() - this.z);
        return $$1 + $$2 + $$3;
    }

    public BlockPos asBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Vec3 asVec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public boolean equals(Object p_77309_) {
        if (p_77309_ instanceof Node) {
            Node $$1 = (Node)p_77309_;
            return this.hash == $$1.hash && this.x == $$1.x && this.y == $$1.y && this.z == $$1.z;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean inOpenSet() {
        return this.heapIdx >= 0;
    }

    public String toString() {
        return "Node{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    public void writeToStream(FriendlyByteBuf p_164700_) {
        p_164700_.writeInt(this.x);
        p_164700_.writeInt(this.y);
        p_164700_.writeInt(this.z);
        p_164700_.writeFloat(this.walkedDistance);
        p_164700_.writeFloat(this.costMalus);
        p_164700_.writeBoolean(this.closed);
        p_164700_.writeEnum(this.type);
        p_164700_.writeFloat(this.f);
    }

    public static Node createFromStream(FriendlyByteBuf p_77302_) {
        Node $$1 = new Node(p_77302_.readInt(), p_77302_.readInt(), p_77302_.readInt());
        Node.readContents(p_77302_, $$1);
        return $$1;
    }

    protected static void readContents(FriendlyByteBuf p_262984_, Node p_263009_) {
        p_263009_.walkedDistance = p_262984_.readFloat();
        p_263009_.costMalus = p_262984_.readFloat();
        p_263009_.closed = p_262984_.readBoolean();
        p_263009_.type = p_262984_.readEnum(PathType.class);
        p_263009_.f = p_262984_.readFloat();
    }
}

