/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools.alias;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.Direct;
import net.minecraft.world.level.levelgen.structure.pools.alias.Random;
import net.minecraft.world.level.levelgen.structure.pools.alias.RandomGroup;

public interface PoolAliasBinding {
    public static final Codec<PoolAliasBinding> CODEC = BuiltInRegistries.POOL_ALIAS_BINDING_TYPE.byNameCodec().dispatch(PoolAliasBinding::codec, Function.identity());

    public void forEachResolved(RandomSource var1, BiConsumer<ResourceKey<StructureTemplatePool>, ResourceKey<StructureTemplatePool>> var2);

    public Stream<ResourceKey<StructureTemplatePool>> allTargets();

    public static Direct direct(String p_307227_, String p_307334_) {
        return PoolAliasBinding.direct(Pools.createKey(p_307227_), Pools.createKey(p_307334_));
    }

    public static Direct direct(ResourceKey<StructureTemplatePool> p_307379_, ResourceKey<StructureTemplatePool> p_307242_) {
        return new Direct(p_307379_, p_307242_);
    }

    public static Random random(String p_307435_, SimpleWeightedRandomList<String> p_307653_) {
        SimpleWeightedRandomList.Builder $$2 = SimpleWeightedRandomList.builder();
        p_307653_.unwrap().forEach(p_338103_ -> $$2.add(Pools.createKey((String)p_338103_.data()), p_338103_.getWeight().asInt()));
        return PoolAliasBinding.random(Pools.createKey(p_307435_), $$2.build());
    }

    public static Random random(ResourceKey<StructureTemplatePool> p_307260_, SimpleWeightedRandomList<ResourceKey<StructureTemplatePool>> p_307665_) {
        return new Random(p_307260_, p_307665_);
    }

    public static RandomGroup randomGroup(SimpleWeightedRandomList<List<PoolAliasBinding>> p_307498_) {
        return new RandomGroup(p_307498_);
    }

    public MapCodec<? extends PoolAliasBinding> codec();
}

