/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.slf4j.Logger;

public class ChunkGeneratorStructureState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomState randomState;
    private final BiomeSource biomeSource;
    private final long levelSeed;
    private final long concentricRingsSeed;
    private final Map<Structure, List<StructurePlacement>> placementsForStructure = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkPos>>> ringPositions = new Object2ObjectArrayMap();
    private boolean hasGeneratedPositions;
    private final List<Holder<StructureSet>> possibleStructureSets;

    public static ChunkGeneratorStructureState createForFlat(RandomState p_256240_, long p_256404_, BiomeSource p_256274_, Stream<Holder<StructureSet>> p_256348_) {
        List<Holder<StructureSet>> $$4 = p_256348_.filter(p_255616_ -> ChunkGeneratorStructureState.hasBiomesForStructureSet((StructureSet)p_255616_.value(), p_256274_)).toList();
        return new ChunkGeneratorStructureState(p_256240_, p_256274_, p_256404_, 0L, $$4);
    }

    public static ChunkGeneratorStructureState createForNormal(RandomState p_256197_, long p_255806_, BiomeSource p_256653_, HolderLookup<StructureSet> p_256659_) {
        List<Holder<StructureSet>> $$4 = p_256659_.listElements().filter(p_256144_ -> ChunkGeneratorStructureState.hasBiomesForStructureSet((StructureSet)p_256144_.value(), p_256653_)).collect(Collectors.toUnmodifiableList());
        return new ChunkGeneratorStructureState(p_256197_, p_256653_, p_255806_, p_255806_, $$4);
    }

    private static boolean hasBiomesForStructureSet(StructureSet p_255766_, BiomeSource p_256424_) {
        Stream $$2 = p_255766_.structures().stream().flatMap(p_255738_ -> {
            Structure $$1 = p_255738_.structure().value();
            return $$1.biomes().stream();
        });
        return $$2.anyMatch(p_256424_.possibleBiomes()::contains);
    }

    private ChunkGeneratorStructureState(RandomState p_256401_, BiomeSource p_255742_, long p_256615_, long p_255979_, List<Holder<StructureSet>> p_256237_) {
        this.randomState = p_256401_;
        this.levelSeed = p_256615_;
        this.biomeSource = p_255742_;
        this.concentricRingsSeed = p_255979_;
        this.possibleStructureSets = p_256237_;
    }

    public List<Holder<StructureSet>> possibleStructureSets() {
        return this.possibleStructureSets;
    }

    private void generatePositions() {
        Set<Holder<Biome>> $$0 = this.biomeSource.possibleBiomes();
        this.possibleStructureSets().forEach(p_255638_ -> {
            StructurePlacement $$6;
            StructureSet $$2 = (StructureSet)p_255638_.value();
            boolean $$3 = false;
            for (StructureSet.StructureSelectionEntry $$4 : $$2.structures()) {
                Structure $$5 = $$4.structure().value();
                if (!$$5.biomes().stream().anyMatch($$0::contains)) continue;
                this.placementsForStructure.computeIfAbsent($$5, p_256235_ -> new ArrayList()).add($$2.placement());
                $$3 = true;
            }
            if ($$3 && ($$6 = $$2.placement()) instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement $$7 = (ConcentricRingsStructurePlacement)$$6;
                this.ringPositions.put($$7, this.generateRingPositions((Holder<StructureSet>)p_255638_, $$7));
            }
        });
    }

    private CompletableFuture<List<ChunkPos>> generateRingPositions(Holder<StructureSet> p_255966_, ConcentricRingsStructurePlacement p_255744_) {
        if (p_255744_.count() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        Stopwatch $$2 = Stopwatch.createStarted((Ticker)Util.TICKER);
        int $$3 = p_255744_.distance();
        int $$4 = p_255744_.count();
        ArrayList<CompletableFuture<ChunkPos>> $$5 = new ArrayList<CompletableFuture<ChunkPos>>($$4);
        int $$6 = p_255744_.spread();
        HolderSet<Biome> $$7 = p_255744_.preferredBiomes();
        RandomSource $$8 = RandomSource.create();
        $$8.setSeed(this.concentricRingsSeed);
        double $$9 = $$8.nextDouble() * Math.PI * 2.0;
        int $$10 = 0;
        int $$11 = 0;
        for (int $$12 = 0; $$12 < $$4; ++$$12) {
            double $$13 = (double)(4 * $$3 + $$3 * $$11 * 6) + ($$8.nextDouble() - 0.5) * ((double)$$3 * 2.5);
            int $$14 = (int)Math.round(Math.cos($$9) * $$13);
            int $$15 = (int)Math.round(Math.sin($$9) * $$13);
            RandomSource $$16 = $$8.fork();
            $$5.add(CompletableFuture.supplyAsync(() -> {
                Pair<BlockPos, Holder<Biome>> $$4 = this.biomeSource.findBiomeHorizontal(SectionPos.sectionToBlockCoord($$14, 8), 0, SectionPos.sectionToBlockCoord($$15, 8), 112, $$7::contains, $$16, this.randomState.sampler());
                if ($$4 != null) {
                    BlockPos $$5 = (BlockPos)$$4.getFirst();
                    return new ChunkPos(SectionPos.blockToSectionCoord($$5.getX()), SectionPos.blockToSectionCoord($$5.getZ()));
                }
                return new ChunkPos($$14, $$15);
            }, Util.backgroundExecutor()));
            $$9 += Math.PI * 2 / (double)$$6;
            if (++$$10 != $$6) continue;
            $$10 = 0;
            $$6 += 2 * $$6 / (++$$11 + 1);
            $$6 = Math.min($$6, $$4 - $$12);
            $$9 += $$8.nextDouble() * Math.PI * 2.0;
        }
        return Util.sequence($$5).thenApply(p_256372_ -> {
            double $$3 = (double)$$2.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            LOGGER.debug("Calculation for {} took {}s", (Object)p_255966_, (Object)$$3);
            return p_256372_;
        });
    }

    public void ensureStructuresGenerated() {
        if (!this.hasGeneratedPositions) {
            this.generatePositions();
            this.hasGeneratedPositions = true;
        }
    }

    @Nullable
    public List<ChunkPos> getRingPositionsFor(ConcentricRingsStructurePlacement p_256667_) {
        this.ensureStructuresGenerated();
        CompletableFuture<List<ChunkPos>> $$1 = this.ringPositions.get(p_256667_);
        return $$1 != null ? $$1.join() : null;
    }

    public List<StructurePlacement> getPlacementsForStructure(Holder<Structure> p_256494_) {
        this.ensureStructuresGenerated();
        return this.placementsForStructure.getOrDefault(p_256494_.value(), List.of());
    }

    public RandomState randomState() {
        return this.randomState;
    }

    public boolean hasStructureChunkInRange(Holder<StructureSet> p_256489_, int p_256593_, int p_256115_, int p_256619_) {
        StructurePlacement $$4 = p_256489_.value().placement();
        for (int $$5 = p_256593_ - p_256619_; $$5 <= p_256593_ + p_256619_; ++$$5) {
            for (int $$6 = p_256115_ - p_256619_; $$6 <= p_256115_ + p_256619_; ++$$6) {
                if (!$$4.isStructureChunk(this, $$5, $$6)) continue;
                return true;
            }
        }
        return false;
    }

    public long getLevelSeed() {
        return this.levelSeed;
    }
}

